/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.titlelist.plugins.barker;

import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListMetadata;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListErrorCode;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListValidationException;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListValidator;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class BarkerValidator
implements IAssetListValidator {
    public void validateAssetList(AssetList assetList) throws AssetListValidationException {
        for (AssetListAssetMap assetMap : assetList.getAssetsMap()) {
            this.validateAsset(assetMap.getTitle(), assetMap.getAssetId(), assetList);
        }
    }

    private void validateAsset(Title title, long assetId, AssetList assetList) throws AssetListValidationException {
        AssetListValidationException exception = new AssetListValidationException();
        this.checkAssetType(exception, title, assetId);
        this.checkLicensingDate(exception, title, assetList);
        this.checkContentClass(exception, title, assetList);
        if (exception.getCodes().size() > 0) {
            throw exception;
        }
    }

    public void validateAssetToAdd(Title title, long assetId, AssetList assetList) throws AssetListValidationException {
        AssetListValidationException exception = new AssetListValidationException();
        this.checkAssetType(exception, title, assetId);
        this.checkLicensingDate(exception, title, assetList);
        this.checkContentClass(exception, title, assetList);
        this.checkUserAccesToTitle(exception, title);
        if (exception.getCodes().size() > 0) {
            throw exception;
        }
    }

    private void checkUserAccesToTitle(AssetListValidationException exception, Title title) {
        IPartnerUserManager partnerUserManager = (IPartnerUserManager)InjectionUtil.injectInstance((String)"PartnerServices/PartnerUserManager", IPartnerUserManager.class);
        if (!partnerUserManager.isSelfPartnerUser()) {
            boolean hasAccess = false;
            for (Partner partner : partnerUserManager.getPartnersByCurrentUser()) {
                if (partner.getId() != title.getPartnerId().longValue()) continue;
                hasAccess = true;
                break;
            }
            if (!hasAccess) {
                exception.add(AssetListErrorCode.ACCESS_TITLE_DENIED);
            }
        }
    }

    private void checkContentClass(AssetListValidationException exception, Title title, AssetList assetList) {
        if (assetList.getContentClass() != null && !title.getContentClassId().equals(assetList.getContentClass())) {
            exception.add(AssetListErrorCode.INVALID_CONTENT_CLASS);
        }
    }

    private Field getAssetField(String fieldName, Asset asset, AssetListValidationException exception) {
        Field field = null;
        field = asset.getFirstField(fieldName);
        if (field == null) {
            exception.add(AssetListErrorCode.MISSING_ASSET_FIELD);
        }
        return field;
    }

    private AssetListMetadata getAssetListField(String fieldName, AssetList assetList, AssetListValidationException exception) {
        AssetListMetadata field = null;
        field = assetList.getAssetListMetadata(fieldName);
        if (field == null) {
            exception.add(AssetListErrorCode.MISSING_ASSETLIST_FIELD);
        }
        return field;
    }

    private void checkLicensingDate(AssetListValidationException exception, Title title, AssetList assetList) {
        List titleAssets = title.getAsset().getAllAssetsOfType("TITLE");
        if (titleAssets.size() > 1) {
            exception.add(AssetListErrorCode.DUPLICATE_TITLE_TYPE);
        }
        if (titleAssets.size() == 0) {
            exception.add(AssetListErrorCode.MISSING_TITLE_TYPE);
        }
        if (titleAssets.size() == 1) {
            Asset asset = (Asset)titleAssets.get(0);
            Field assetLicensingWindowStart = this.getAssetField("/tns:Fields/tns:Rights/tns:LicensingWindowStart", asset, exception);
            Field assetLicensingWindowEnd = this.getAssetField("/tns:Fields/tns:Rights/tns:LicensingWindowEnd", asset, exception);
            Date assetLicensingStart = null;
            if (assetLicensingWindowStart != null) {
                assetLicensingStart = (Date)assetLicensingWindowStart.getTypedValue();
            }
            Date assetLicensingEnd = null;
            if (assetLicensingWindowEnd != null) {
                assetLicensingEnd = (Date)assetLicensingWindowEnd.getTypedValue();
                assetLicensingEnd = this.checkTime(assetLicensingEnd);
            }
            AssetListMetadata assetListPlayoutStart = this.getAssetListField("Playout Start Date", assetList, exception);
            AssetListMetadata assetListPlayoutEnd = this.getAssetListField("Playout End Date", assetList, exception);
            AssetListMetadata assetListDailyPlayoutStartTime = this.getAssetListField("Daily Playout Start Time", assetList, exception);
            AssetListMetadata assetListDailyPlayoutEndTime = this.getAssetListField("Daily Playout End Time", assetList, exception);
            Date assetListStartDate = null;
            if (assetListPlayoutStart != null) {
                assetListStartDate = (Date)assetListPlayoutStart.getTypedValue();
                if (assetListDailyPlayoutStartTime != null) {
                    assetListStartDate = this.setTimeInfo(assetListStartDate, assetListDailyPlayoutStartTime.getTimeValue());
                }
            }
            Date assetListEndDate = null;
            if (assetListPlayoutEnd != null) {
                assetListEndDate = (Date)assetListPlayoutEnd.getTypedValue();
                if (assetListDailyPlayoutEndTime != null) {
                    assetListEndDate = this.setTimeInfo(assetListEndDate, assetListDailyPlayoutEndTime.getTimeValue());
                    assetListEndDate = this.checkTime(assetListEndDate);
                }
            }
            if (assetListStartDate != null && assetLicensingStart != null && assetListEndDate != null && assetLicensingEnd != null && (assetListStartDate.compareTo(assetLicensingStart) > 0 || assetListEndDate.compareTo(assetLicensingEnd) < 0)) {
                exception.add(AssetListErrorCode.INVALID_LICENSE_WINDOW);
            }
        }
    }

    private Date checkTime(Date date) {
        Calendar newDate = Calendar.getInstance();
        newDate.setTime(date);
        int hour = newDate.get(10);
        int minute = newDate.get(12);
        int second = newDate.get(13);
        if (hour == 0 && minute == 0 && second == 0) {
            newDate.set(10, 23);
            newDate.set(12, 59);
            newDate.set(13, 59);
        }
        return newDate.getTime();
    }

    private Date setTimeInfo(Date date, String time) {
        String[] splitedTime = time.split(":");
        int hour = Integer.parseInt(splitedTime[0]);
        int minute = Integer.parseInt(splitedTime[1]);
        int second = Integer.parseInt(splitedTime[2]);
        Calendar newDate = Calendar.getInstance();
        newDate.setTime(date);
        newDate.set(10, hour);
        newDate.set(12, minute);
        newDate.set(13, second);
        return newDate.getTime();
    }

    private void checkAssetType(AssetListValidationException exception, Title title, long assetId) {
        Asset asset = this.getAssetById(title, assetId);
        if (!asset.getAssetType().equals("LOGICALCLIP") && !asset.getAssetType().equals("PREVIEW")) {
            exception.add(AssetListErrorCode.INVALID_ASSET_TYPE);
        }
    }

    private Asset getAssetById(Title title, long assetId) {
        Asset assetResult = null;
        for (Asset asset : title.getAllAssets(false)) {
            if (asset.getId() != assetId) continue;
            assetResult = asset;
            break;
        }
        return assetResult;
    }
}

