<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns fn">

<xsl:import href="from/common.xsl"/>

<xsl:template name="logicalclip">
<xsl:param name="app_name" />
<xsl:param name="clip_id" />

<xsl:for-each select ="/tns:TTVSpec/tns:Item[@type = 'LOGICALCLIP' and tns:Fields/tns:TTVId/tns:Id = $clip_id]">
<!-- Id should be unique, but let's do extra validation -->
<xsl:if test="position()=1">
	<App_Data>
		<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
		<xsl:attribute name="Name">NPT_Start</xsl:attribute>
		<xsl:attribute name="Value">
			<xsl:value-of select="tns:Fields/tns:CustomFields/tns:CustomField[@name='MarkIn']/@value" />
		</xsl:attribute>
	</App_Data>
	<App_Data>
		<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
		<xsl:attribute name="Name">NPT_End</xsl:attribute>
		<xsl:attribute name="Value">
			<xsl:value-of select="tns:Fields/tns:CustomFields/tns:CustomField[@name='MarkOut']/@value" />
		</xsl:attribute>
	</App_Data>
</xsl:if>
</xsl:for-each>

</xsl:template>
</xsl:stylesheet>
