<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:fn="http://www.w3.org/2005/xpath-functions"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns fn">
<xsl:import href="from/common.xsl"/>

<xsl:output method="xml" indent="yes"/>

<xsl:template match="tns:TTVSpec/tns:Group[@type = 'PACKAGE']">
	<AMS xsl:use-attribute-sets="AmsAttributeSet" >
		<xsl:attribute name="Asset_Class">
			<xsl:choose>
				<xsl:when test="fn:normalize-space(tns:Fields/tns:AssetClass) = ''">package</xsl:when>
				<xsl:otherwise><xsl:value-of select="tns:Fields/tns:AssetClass" /></xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
	</AMS>

	<xsl:for-each select="tns:Fields/tns:ProviderContentTier/tns:Value">
	<App_Data>
		<xsl:attribute name="App">
			<xsl:value-of select="../../tns:ApplicationInfo/tns:Name" />
		</xsl:attribute>
		<xsl:attribute name="Name">Provider_Content_Tier</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="." />
		</xsl:attribute>
	</App_Data>
	</xsl:for-each>
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Metadata_Spec_Version</xsl:attribute>
		<xsl:attribute name="Value">
		<xsl:choose>
		<xsl:when test="tns:Fields/tns:MetadataSpecVersion">
	    	<xsl:value-of select="tns:Fields/tns:MetadataSpecVersion" />
	    </xsl:when>
	    <xsl:otherwise>CableLabsVOD1.1</xsl:otherwise>
	    </xsl:choose>
		</xsl:attribute>
	</App_Data>
	<!--  Custom Field -->
			<xsl:apply-templates select="tns:Fields/tns:CustomFields"/>
			<xsl:apply-templates select="tns:Fields/tns:CustomFields-CL1_1"/>
</xsl:template>


</xsl:stylesheet>