<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tns="http://www.tandbergtv.com/TTVSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" version="1.0">
	<xsl:output method="xml" indent="yes"/>
	<xsl:template match="/importVideoWithClips | /importVideo">
		<xsl:apply-templates select="metadata" mode="metadata" />
	</xsl:template>
	<xsl:template match="metadata" mode="metadata">
		<xsl:element name="tns:TTVSpec">
			<xsl:element name="tns:Group">
				<xsl:attribute name="type">PACKAGE</xsl:attribute>
				<xsl:element name="tns:Fields">
					<xsl:apply-templates select="videoLabel" mode="providerAndProductInfo" />
					<xsl:element name="tns:TTVId">
						<xsl:element name="tns:Id">
							<xsl:value-of select="-1"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>

				<!-- Title -->
				<xsl:element name="tns:Relation">
					<xsl:attribute name="type">PARENT_CHILD</xsl:attribute>
					<xsl:element name="tns:Target">
						<xsl:element name="tns:Id">
							<xsl:value-of select="-2" />
						</xsl:element>
					</xsl:element>
				</xsl:element>

				<!-- Movie/Preview -->
				<xsl:element name="tns:Relation">
					<xsl:attribute name="type">PARENT_CHILD</xsl:attribute>
					<xsl:element name="tns:Target">
						<xsl:element name="tns:Id">
							<xsl:value-of select="-3" />
						</xsl:element>
					</xsl:element>
				</xsl:element>

				<!-- AONTV Movie/Preview -->
				<xsl:if test="//*/clipLabel/AONTV_Available
								or //*/clipLabel/AONTV_Genre
								or //*/clipLabel/AONTV_SubGenre
								or //*/clipLabel/AONTV_Rubrics
								or //*/clipLabel/AONTV_Approved
								or //*/clipLabel/AONTV_AccessRights
								or //*/clipLabel/AONTV_ContractCode
								or //*/clipLabel/AONTV_LicenceStart
								or //*/clipLabel/AONTV_LicenceEnd
								or videoLabel/AONTV_Videofile
								or videoLabel/AONTV_DRM
								or videoLabel/AONTV_AudioFormat">
					<xsl:element name="tns:Relation">
						<xsl:attribute name="type">PARENT_CHILD</xsl:attribute>
						<xsl:element name="tns:Target">
							<xsl:element name="tns:Id">
								<xsl:value-of select="-4" />
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:if>

				<!-- AONDWEB Movie/Preview -->
				<xsl:if test="//*/clipLabel/AONDWEB_Available
								or //*/clipLabel/AONDWEB_Genre
								or //*/clipLabel/AONDWEB_SubGenre
								or //*/clipLabel/AONDWEB_Rubrics
								or //*/clipLabel/AONDWEB_Approved
								or //*/clipLabel/AONDWEB_AvailStart
								or //*/clipLabel/AONDWEB_AvailEnd">
					<xsl:element name="tns:Relation">
						<xsl:attribute name="type">PARENT_CHILD</xsl:attribute>
						<xsl:element name="tns:Target">
							<xsl:element name="tns:Id">
								<xsl:value-of select="-5" />
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:if>

				<!-- Poster -->
				<xsl:if test="videoLabel/previewImage">
					<xsl:element name="tns:Relation">
						<xsl:attribute name="type">PARENT_CHILD</xsl:attribute>
						<xsl:element name="tns:Target">
							<xsl:element name="tns:Id">
								<xsl:value-of select="-6" />
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:if>

				<!-- Encrypted -->
				<xsl:if test="videoLabel/BERT_DRM_Key">
					<xsl:element name="tns:Relation">
						<xsl:attribute name="type">PARENT_CHILD</xsl:attribute>
						<xsl:element name="tns:Target">
							<xsl:element name="tns:Id">
								<xsl:value-of select="-7" />
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:if>

			</xsl:element>

			<!-- Title -->
			<xsl:element name="tns:Item">
				<xsl:attribute name="type">TITLE</xsl:attribute>
				<xsl:element name="tns:Fields">
					<xsl:apply-templates select="videoLabel" mode="providerAndProductInfo" />
					<xsl:if test="videoLabel/title or videoLabel/subTitle">
						<xsl:element name="tns:Title">
							<xsl:if test="videoLabel/title">
								<xsl:element name="tns:DisplayTitle">
									<xsl:element name="tns:Value">
										<xsl:value-of select="videoLabel/title" />
									</xsl:element>
								</xsl:element>
							</xsl:if>
							<xsl:if test="videoLabel/subTitle">
								<xsl:element name="tns:SortTitle">
									<xsl:element name="tns:Value">
										<xsl:value-of select="videoLabel/subTitle" />
									</xsl:element>
								</xsl:element>
							</xsl:if>
						</xsl:element>
					</xsl:if>
					<xsl:if test="//*/clipLabel/contentCategory">
						<xsl:element name="tns:ShowType">
							<xsl:value-of select="//*/clipLabel/contentCategory" />
						</xsl:element>
					</xsl:if>
					<xsl:if test="//*/clipLabel/headline or //*/clipLabel/longText">
						<xsl:element name="tns:Summary">
							<xsl:if test="//*/clipLabel/headline">
								<xsl:element name="tns:ShortSummary">
									<xsl:element name="tns:Value">
										<xsl:value-of select="//*/clipLabel/headline" />
									</xsl:element>
								</xsl:element>
							</xsl:if>
							<xsl:if test="//*/clipLabel/longText">
								<xsl:element name="tns:DisplaySummary">
									<xsl:element name="tns:Value">
										<xsl:value-of select="//*/clipLabel/longText" />
									</xsl:element>
								</xsl:element>
							</xsl:if>
						</xsl:element>
					</xsl:if>
					<xsl:if test="//*/clipLabel/priority">
						<xsl:element name="tns:PropagationPriority">
							<xsl:value-of select="//*/clipLabel/priority" />
						</xsl:element>
					</xsl:if>
					<xsl:if test="//*/clipLabel/country or //*/clipLabel/year or //*/clipLabel/pictureCopyright">
						<xsl:element name="tns:CreationInfo">
							<xsl:if test="//*/clipLabel/country">
								<xsl:element name="tns:Place">
									<xsl:element name="tns:Country">
										<xsl:value-of select="//*/clipLabel/country" />
									</xsl:element>
								</xsl:element>
							</xsl:if>
							<xsl:if test="//*/clipLabel/year">
								<xsl:element name="tns:PublicationDate">
									<xsl:value-of select="//*/clipLabel/year" />
								</xsl:element>
							</xsl:if>
							<xsl:if test="//*/clipLabel/pictureCopyright">
								<xsl:element name="tns:Studio">
									<xsl:element name="tns:Name">
										<xsl:value-of select="//*/clipLabel/pictureCopyright" />
									</xsl:element>
								</xsl:element>
							</xsl:if>
						</xsl:element>
					</xsl:if>
					<xsl:if test="//*/clipLabel/actors">
						<xsl:element name="tns:Source">
							<xsl:element name="tns:Role">
								<xsl:element name="tns:Name">ACTOR</xsl:element>
							</xsl:element>
							<xsl:element name="tns:Contact">
								<xsl:element name="tns:DisplayName">
									<xsl:value-of select="//*/clipLabel/actors" />
								</xsl:element>
							</xsl:element>
						</xsl:element>
					</xsl:if>
					<xsl:if test="//*/clipLabel/director">
						<xsl:element name="tns:Source">
							<xsl:element name="tns:Role">
								<xsl:element name="tns:Name">DIRECTOR</xsl:element>
							</xsl:element>
							<xsl:element name="tns:Contact">
								<xsl:choose>
									<xsl:when test="fn:contains(//*/clipLabel/director, ',')">
										<xsl:element name="tns:FirstName">
											<xsl:value-of select="substring-after(//*/clipLabel/director,',')" />
										</xsl:element>
										<xsl:element name="tns:LastName">
											<xsl:value-of select="substring-before(//*/clipLabel/director,',')" />
										</xsl:element>
									</xsl:when>
									<xsl:otherwise>
										<xsl:element name="tns:LastName">
											<xsl:value-of select="//*/clipLabel/director" />
										</xsl:element>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:element>
						</xsl:element>
					</xsl:if>
					<xsl:if test="//*/clipLabel/episode or //*/clipLabel/episodeTitle">
						<xsl:element name="tns:Episode">
							<xsl:if test="//*/clipLabel/episode">
								<xsl:element name="tns:Number">
									<xsl:value-of select="//*/clipLabel/episode" />
								</xsl:element>
								<xsl:element name="tns:Identifier">
									<xsl:element name="tns:Id">
										<xsl:choose>
											<xsl:when test="//*/clipLabel/season and //*/clipLabel/episode != ''">s<xsl:value-of select="//*/clipLabel/season" />e<xsl:value-of select="//*/clipLabel/episode" /></xsl:when>
											<xsl:otherwise><xsl:value-of select="//*/clipLabel/episode" /></xsl:otherwise>
										</xsl:choose>
									</xsl:element>
								</xsl:element>
							</xsl:if>
							<xsl:if test="//*/clipLabel/episodeTitle">
								<xsl:element name="tns:Name">
									<xsl:element name="tns:Value">
										<xsl:value-of select="//*/clipLabel/episodeTitle" />
									</xsl:element>
								</xsl:element>
							</xsl:if>
						</xsl:element>
					</xsl:if>
					<xsl:if test="//*/clipLabel/season or //*/clipLabel/airDate or videoLabel/broadcaster">
						<xsl:element name="tns:TvId">
							<xsl:if test="//*/clipLabel/season">
								<xsl:element name="tns:EpisodeSeasonNumber">
									<xsl:value-of select="//*/clipLabel/season" />
								</xsl:element>
							</xsl:if>
							<xsl:if test="//*/clipLabel/airDate">
								<xsl:element name="tns:Showtime">
									<xsl:element name="tns:OriginalAirDate">
										<xsl:value-of select="//*/clipLabel/airDate" />
									</xsl:element>
								</xsl:element>
							</xsl:if>
							<xsl:if test="videoLabel/broadcaster">
								<xsl:element name="tns:Network">
									<xsl:value-of select="videoLabel/broadcaster" />
								</xsl:element>
							</xsl:if>
						</xsl:element>
					</xsl:if>
					<xsl:if test="//*/clipLabel/BERT_ContractCode or //*/clipLabel/BERT_LicenceStart or //*/clipLabel/BERT_LicenceEnd or //*/clipLabel/BERT_AvailStart or //*/clipLabel/BERT_AvailEnd">
						<xsl:element name="tns:Rights">
							<xsl:if test="//*/clipLabel/BERT_ContractCode">
								<xsl:element name="tns:Contract">
									<xsl:element name="tns:Name">
										<xsl:value-of select="//*/clipLabel/BERT_ContractCode" />
									</xsl:element>
								</xsl:element>
							</xsl:if>
							<xsl:if test="//*/clipLabel/BERT_LicenceStart">
								<xsl:element name="tns:LicensingWindowStart">
									<xsl:value-of select="//*/clipLabel/BERT_LicenceStart" />
								</xsl:element>
							</xsl:if>
							<xsl:if test="//*/clipLabel/BERT_LicenceEnd">
								<xsl:element name="tns:LicensingWindowEnd">
									<xsl:value-of select="//*/clipLabel/BERT_LicenceEnd" />
								</xsl:element>
							</xsl:if>
							<xsl:if test="//*/clipLabel/BERT_AvailStart">
								<xsl:element name="tns:AvailabilityWindowStart">
									<xsl:value-of select="//*/clipLabel/BERT_AvailStart" />
								</xsl:element>
							</xsl:if>
							<xsl:if test="//*/clipLabel/BERT_AvailEnd">
								<xsl:element name="tns:AvailabilityWindowEnd">
									<xsl:value-of select="//*/clipLabel/BERT_AvailEnd" />
								</xsl:element>
							</xsl:if>
						</xsl:element>
					</xsl:if>
					<xsl:if test="videoLabel/CPAssetID or videoLabel/price">
						<xsl:element name="tns:BillingInfo">
							<xsl:if test="videoLabel/CPAssetID">
								<xsl:element name="tns:Identifier">
									<xsl:element name="tns:Id">
										<xsl:value-of select="videoLabel/CPAssetID" />
									</xsl:element>
								</xsl:element>
							</xsl:if>
							<xsl:if test="videoLabel/price">
								<xsl:element name="tns:SuggestedPrice">
									<xsl:element name="tns:Value">
										<xsl:value-of select="videoLabel/price" />
									</xsl:element>
								</xsl:element>
							</xsl:if>
						</xsl:element>
					</xsl:if>
					<xsl:if test="videoLabel/Duration">
						<xsl:element name="tns:Duration">
							<xsl:element name="tns:Duration">
								<xsl:value-of select="videoLabel/Duration" />
							</xsl:element>
							<xsl:element name="tns:DisplayDuration">
							<xsl:choose>
								<xsl:when test="fn:matches(videoLabel/Duration, '\d{2}:\d{2}:\d{2}')">
									<xsl:choose>
										<xsl:when test="fn:matches(fn:minutes-from-time(videoLabel/Duration), '\d{2}')">
											<xsl:value-of select="fn:concat(fn:hours-from-time(videoLabel/Duration), ':', fn:minutes-from-time(videoLabel/Duration))" />
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="fn:concat(fn:hours-from-time(videoLabel/Duration), ':0', fn:minutes-from-time(videoLabel/Duration))" />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="videoLabel/Duration" />
								</xsl:otherwise>
							</xsl:choose>
							</xsl:element>
						</xsl:element>
					</xsl:if>
					<xsl:if test="//*/clipLabel/BERT_Genre or //*/clipLabel/BERT_SubGenre">
						<xsl:element name="tns:Category">
							<xsl:element name="tns:Text">
								<xsl:value-of select="//*/clipLabel/BERT_Genre" />/<xsl:value-of select="//*/clipLabel/BERT_SubGenre" />
							</xsl:element>
						</xsl:element>
					</xsl:if>
					<xsl:element name="tns:CustomFields">
						<xsl:if test="//*/clipLabel/album">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">Album</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="//*/clipLabel/album" />
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="//*/clipLabel/artist">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">Artist</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="//*/clipLabel/artist" />
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="//*/clipLabel/AssetId">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">EXT_ASSET_ID</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="//*/clipLabel/AssetId" />
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="//*/clipLabel/CP_Release">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">QC_REQUIRED</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:if test="//*/clipLabel/CP_Release = 'yes'">true</xsl:if>
									<xsl:if test="//*/clipLabel/CP_Release = 'no'">false</xsl:if>
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="//*/clipLabel/contentnumber">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">CONTENT_NUM</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="//*/clipLabel/contentnumber" />
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="//*/clipLabel/AONTV_Available">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">AONTV_AVAILABLE</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:if test="//*/clipLabel/AONTV_Available = 'yes'">true</xsl:if>
									<xsl:if test="//*/clipLabel/AONTV_Available = 'no'">false</xsl:if>
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="//*/clipLabel/BERT_Available">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">IAP_AVAILABLE</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:if test="//*/clipLabel/BERT_Available = 'yes'">true</xsl:if>
									<xsl:if test="//*/clipLabel/BERT_Available = 'no'">false</xsl:if>
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="//*/clipLabel/BERT_Rubrics">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">RUBRICS</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="//*/clipLabel/BERT_Rubrics" />
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="//*/clipLabel/BERT_Approved">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">QC_COMPLETE</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:if test="//*/clipLabel/BERT_Approved = 'yes'">true</xsl:if>
									<xsl:if test="//*/clipLabel/BERT_Approved = 'no'">false</xsl:if>
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="//*/clipLabel/BERT_AccessRights">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">ACCESS_RIGHTS</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="//*/clipLabel/BERT_AccessRights" />
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="//*/clipLabel/AONDWEB_Available">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">AONDWEB_AVAILABLE</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:if test="//*/clipLabel/AONDWEB_Available = 'yes'">true</xsl:if>
									<xsl:if test="//*/clipLabel/AONDWEB_Available = 'no'">false</xsl:if>
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="videoLabel/VideoAssetId">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">EXT_TITLE_ID</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="videoLabel/VideoAssetId" />
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="videoLabel/BERT_VodCode">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">VOD_CODE</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="videoLabel/BERT_VodCode" />
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="videoLabel/associationID">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">ASSOCIATION_ID</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="videoLabel/associationID" />
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="videoLabel/reponseUrl">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">CIWS_RESPONSE_URL</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="videoLabel/reponseUrl" />
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="videoLabel/trailerNumber">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">TRAILER_NUM</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="videoLabel/trailerNumber" />
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="videoLabel/broadcastDate">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">BroadcastDate</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="videoLabel/broadcastDate" />
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:if test="videoLabel/broadcastTime">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">BroadcastTime</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="videoLabel/broadcastTime" />
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
					</xsl:element>
					<xsl:element name="tns:TTVId">
						<xsl:element name="tns:Id">
							<xsl:value-of select="-2"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:element>

			<!-- Movie/Preview -->
			<xsl:element name="tns:Group">
				<xsl:attribute name="type">
					<xsl:choose>
						<xsl:when test="clipList">MOVIE</xsl:when>
						<xsl:otherwise>PREVIEW</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:element name="tns:Fields">
					<xsl:apply-templates select="videoLabel" mode="providerAndProductInfo" />
					<xsl:if test="//*/clipLabel/age">
						<xsl:element name="tns:Rating">
							<xsl:element name="tns:Value">
								<xsl:value-of select="//*/clipLabel/age" />
							</xsl:element>
						</xsl:element>
					</xsl:if>
					<xsl:if test="//*/clipLabel/language">
						<xsl:element name="tns:Language">
							<xsl:attribute name="value">
								<xsl:value-of select="//*/clipLabel/language" />
							</xsl:attribute>
						</xsl:element>
					</xsl:if>
					<!-- TODO: may have to split this up -->
					<xsl:if test="//*/clipLabel/dubbedLanguages">
						<xsl:for-each select="fn:tokenize(//*/clipLabel/dubbedLanguages, ',')">
							<xsl:element name="tns:DubbedLanguage">
								<xsl:attribute name="value">
									<xsl:value-of select="." />
								</xsl:attribute>
							</xsl:element>
						</xsl:for-each>
					</xsl:if>
					<xsl:if test="//*/clipLabel/subtitleLanguages">
						<xsl:for-each select="fn:tokenize(//*/clipLabel/subtitleLanguages, ',')">
							<xsl:element name="tns:SubTitleLanguage">
								<xsl:attribute name="value">
									<xsl:value-of select="." />
								</xsl:attribute>
							</xsl:element>
						</xsl:for-each>
					</xsl:if>
					<xsl:if test="videoLabel/BERT_Videofile or videoLabel/BERT_Resolution">
						<xsl:element name="tns:Content">
							<xsl:if test="videoLabel/BERT_Videofile">
								<xsl:element name="tns:Locator">
									<xsl:element name="tns:Uri">
										<xsl:value-of select="videoLabel/BERT_Videofile" />
									</xsl:element>
								</xsl:element>
							</xsl:if>
							<xsl:if test="videoLabel/BERT_Resolution">
								<xsl:element name="Resolution">
									<xsl:value-of select="videoLabel/BERT_Resolution" />
								</xsl:element>
							</xsl:if>
						</xsl:element>
					</xsl:if>
					<xsl:element name="tns:Video">						
						<xsl:if test="videoLabel/BERT_BitRate">
							<xsl:element name="tns:BitRate">
								<xsl:attribute name="value">
									<xsl:value-of select="videoLabel/BERT_BitRate" />
								</xsl:attribute>
							</xsl:element>
						</xsl:if>
						<xsl:element name="tns:ScreenFormat">
							<xsl:choose>
								<xsl:when test="videoLabel/letterbox or videoLabel/videoformat">
										<!-- assumption here is letterbox and videoformat are mutually exclusive -->
										<xsl:choose>
											<xsl:when test="videoLabel/letterbox">
												<xsl:choose>
													<xsl:when test="videoLabel/letterbox = 'yes'">Letterbox</xsl:when>
													<xsl:otherwise>Standard</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:when test="videoLabel/videoformat">
												<xsl:choose>
													<xsl:when test="videoLabel/videoformat = '16:9'">Widescreen</xsl:when>
													<xsl:otherwise>Standard</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
										</xsl:choose>
								</xsl:when>
								<xsl:otherwise>Standard</xsl:otherwise>
							</xsl:choose>
						</xsl:element>							
					</xsl:element>
					<xsl:if test="videoLabel/BERT_DRM">
						<xsl:element name="tns:Encryption">
							<xsl:element name="tns:Value">
								<xsl:if test="videoLabel/BERT_DRM = 'yes'">true</xsl:if>
								<xsl:if test="videoLabel/BERT_DRM = 'no'">false</xsl:if>
							</xsl:element>
						</xsl:element>
					</xsl:if>
					<xsl:if test="videoLabel/BERT_AudioFormat">
						<xsl:element name="tns:Audio">
							<xsl:element name="tns:Type">
								<xsl:value-of select="videoLabel/BERT_AudioFormat" />
							</xsl:element>
						</xsl:element>
					</xsl:if>
					<xsl:if test="videoLabel/BERT_MediaFormat">
						<xsl:element name="tns:CustomFields">
							<xsl:element name="tns:CustomField">
								<xsl:attribute name="name">StreamFormat</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:value-of select="videoLabel/BERT_MediaFormat" />
								</xsl:attribute>
							</xsl:element>
						</xsl:element>
					</xsl:if>		
					<xsl:element name="tns:TTVId">
						<xsl:element name="tns:Id">
							<xsl:value-of select="-3"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>
				<xsl:for-each select="//*/clipLabel">
					<xsl:if test="inTimeMsec and outTimeMsec">
						<xsl:element name="tns:Relation">
							<xsl:attribute name="type">PARENT_CHILD</xsl:attribute>
							<xsl:element name="tns:Target">
								<xsl:element name="tns:Id">
									<xsl:value-of select="-position() - 7" />
								</xsl:element>
							</xsl:element>
						</xsl:element>
					</xsl:if>
				</xsl:for-each>
			</xsl:element>

			<!-- AONTV Movie/Preview -->
			<xsl:if test="//*/clipLabel/AONTV_Available
							or //*/clipLabel/AONTV_Genre
							or //*/clipLabel/AONTV_SubGenre
							or //*/clipLabel/AONTV_Rubrics
							or //*/clipLabel/AONTV_Approved
							or //*/clipLabel/AONTV_AccessRights
							or //*/clipLabel/AONTV_ContractCode
							or //*/clipLabel/AONTV_LicenceStart
							or //*/clipLabel/AONTV_LicenceEnd
							or videoLabel/AONTV_Videofile
							or videoLabel/AONTV_DRM
							or videoLabel/AONTV_AudioFormat">
				<xsl:element name="tns:Group">
					<xsl:attribute name="type">
						<xsl:choose>
							<xsl:when test="clipList">MOVIE</xsl:when>
							<xsl:otherwise>PREVIEW</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
					<xsl:element name="tns:Fields">
						<xsl:apply-templates select="videoLabel" mode="providerAndProductInfo" />
						<xsl:element name="tns:CustomFields">
							<xsl:if test="//*/clipLabel/AONTV_Rubrics">
								<xsl:element name="tns:CustomField">
									<xsl:attribute name="name">AONTV_RUBRICS</xsl:attribute>
									<xsl:attribute name="value">
										<xsl:value-of select="//*/clipLabel/AONTV_Rubrics" />
									</xsl:attribute>
								</xsl:element>
							</xsl:if>
							<xsl:if test="//*/clipLabel/AONTV_Approved">
								<xsl:element name="tns:CustomField">
									<xsl:attribute name="name">QC_COMPLETE</xsl:attribute>
									<xsl:attribute name="value">
										<xsl:if test="//*/clipLabel/AONTV_Approved = 'yes'">true</xsl:if>
										<xsl:if test="//*/clipLabel/AONTV_Approved = 'no'">false</xsl:if>
									</xsl:attribute>
								</xsl:element>
							</xsl:if>
							<xsl:if test="//*/clipLabel/AONTV_AccessRights">
								<xsl:element name="tns:CustomField">
									<xsl:attribute name="name">ACCESS_RIGHTS</xsl:attribute>
									<xsl:attribute name="value">
										<xsl:value-of select="//*/clipLabel/AONTV_AccessRights" />
									</xsl:attribute>
								</xsl:element>
							</xsl:if>
							<xsl:if test="videoLabel/BERT_Macrovision">
								<xsl:element name="tns:CustomField">
									<xsl:attribute name="name">MACROVISION</xsl:attribute>
										<xsl:attribute name="value">
											<xsl:if test="videoLabel/BERT_Macrovision = 'yes'">true</xsl:if>
											<xsl:if test="videoLabel/BERT_Macrovision = 'no'">false</xsl:if>
										</xsl:attribute>
								</xsl:element>
							</xsl:if>
						</xsl:element>
						<xsl:if test="//*/clipLabel/AONTV_Genre or //*/clipLabel/AONTV_SubGenre">
							<xsl:element name="tns:Category">
								<xsl:element name="tns:Text">
									<xsl:value-of select="//*/clipLabel/AONTV_Genre" />/<xsl:value-of select="//*/clipLabel/AONTV_SubGenre" />
								</xsl:element>
							</xsl:element>
						</xsl:if>
						<xsl:if test="//*/clipLabel/AONTV_ContractCode or //*/clipLabel/AONTV_LicenceStart or //*/clipLabel/AONTV_LicenceEnd or //*/clipLabel/AONTV_AvailStart or //*/clipLabel/AONTV_AvailEnd">
							<xsl:element name="tns:Rights">
								<xsl:if test="//*/clipLabel/AONTV_ContractCode">
									<xsl:element name="tns:Contract">
										<xsl:element name="tns:Name">
											<xsl:value-of select="//*/clipLabel/AONTV_ContractCode" />
										</xsl:element>
									</xsl:element>
								</xsl:if>
								<xsl:if test="//*/clipLabel/AONTV_LicenceStart">
									<xsl:element name="tns:LicensingWindowStart">
										<xsl:value-of select="//*/clipLabel/AONTV_LicenceStart" />
									</xsl:element>
								</xsl:if>
								<xsl:if test="//*/clipLabel/AONTV_LicenceEnd">
									<xsl:element name="tns:LicensingWindowEnd">
										<xsl:value-of select="//*/clipLabel/AONTV_LicenceEnd" />
									</xsl:element>
								</xsl:if>
								<xsl:if test="//*/clipLabel/AONTV_AvailStart">
									<xsl:element name="tns:AvailabilityWindowStart">
										<xsl:value-of select="//*/clipLabel/AONTV_AvailStart" />
									</xsl:element>
								</xsl:if>
								<xsl:if test="//*/clipLabel/AONTV_AvailEnd">
									<xsl:element name="tns:AvailabilityWindowEnd">
										<xsl:value-of select="//*/clipLabel/AONTV_AvailEnd" />
									</xsl:element>
								</xsl:if>
							</xsl:element>
						</xsl:if>
						<xsl:if test="videoLabel/AONTV_Videofile">
							<xsl:element name="tns:Content">
								<xsl:element name="tns:Locator">
									<xsl:element name="tns:Uri">
										<xsl:value-of select="videoLabel/AONTV_Videofile" />
									</xsl:element>
								</xsl:element>
							</xsl:element>
						</xsl:if>
						<xsl:if test="videoLabel/AONTV_DRM">
							<xsl:element name="tns:Copyright">
								<xsl:element name="tns:CopyProtection">
									<xsl:if test="videoLabel/AONTV_DRM = 'yes'">true</xsl:if>
									<xsl:if test="videoLabel/AONTV_DRM = 'no'">false</xsl:if>
								</xsl:element>
							</xsl:element>
						</xsl:if>
						<xsl:if test="videoLabel/AONTV_AudioFormat">
							<xsl:element name="tns:Audio">
								<xsl:element name="tns:Type">
									<xsl:value-of select="videoLabel/AONTV_AudioFormat" />
								</xsl:element>
							</xsl:element>
						</xsl:if>
						<xsl:element name="tns:TTVId">
							<xsl:element name="tns:Id">
								<xsl:value-of select="-4"/>
							</xsl:element>
						</xsl:element>
					</xsl:element>
					<xsl:for-each select="//*/clipLabel">
						<xsl:if test="inTimeMsec and outTimeMsec">
							<xsl:element name="tns:Relation">
								<xsl:attribute name="type">PARENT_CHILD</xsl:attribute>
								<xsl:element name="tns:Target">
									<xsl:element name="tns:Id">
										<xsl:value-of select="-position() - 7 - count(//*/clipLabel)" />
									</xsl:element>
								</xsl:element>
							</xsl:element>
						</xsl:if>
					</xsl:for-each>
				</xsl:element>
			</xsl:if>

			<!-- AONDWEB Movie/Preview -->
			<xsl:if test="//*/clipLabel/AONDWEB_Available
							or //*/clipLabel/AONDWEB_Genre
							or //*/clipLabel/AONDWEB_SubGenre
							or //*/clipLabel/AONDWEB_Rubrics
							or //*/clipLabel/AONDWEB_Approved
							or //*/clipLabel/AONDWEB_AvailStart
							or //*/clipLabel/AONDWEB_AvailEnd
							or videoLabel/AONDWEB_Videofile
							or videoLabel/AONDWEB_DRM
							or videoLabel/AONDWEB_AudioFormat">
				<xsl:element name="tns:Group">
					<xsl:attribute name="type">
						<xsl:choose>
							<xsl:when test="clipList">MOVIE</xsl:when>
							<xsl:otherwise>PREVIEW</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
					<xsl:element name="tns:Fields">
						<xsl:apply-templates select="videoLabel" mode="providerAndProductInfo" />
						<xsl:element name="tns:CustomFields">
							<xsl:if test="//*/clipLabel/AONDWEB_Rubrics">
								<xsl:element name="tns:CustomField">
									<xsl:attribute name="name">AONDWEB_RUBRICS</xsl:attribute>
									<xsl:attribute name="value">
										<xsl:value-of select="//*/clipLabel/AONDWEB_Rubrics" />
									</xsl:attribute>
								</xsl:element>
							</xsl:if>
							<xsl:if test="//*/clipLabel/AONDWEB_Approved">
								<xsl:element name="tns:CustomField">
									<xsl:attribute name="name">QC_COMPLETE</xsl:attribute>
									<xsl:attribute name="value">
										<xsl:if test="//*/clipLabel/AONDWEB_Approved = 'yes'">true</xsl:if>
										<xsl:if test="//*/clipLabel/AONDWEB_Approved = 'no'">false</xsl:if>
									</xsl:attribute>
								</xsl:element>
							</xsl:if>
						</xsl:element>
						<xsl:if test="//*/clipLabel/AONDWEB_SubGenre or //*/clipLabel/AONDWEB_Rubrics">
							<xsl:element name="tns:Category">
								<xsl:element name="tns:Text">
									<xsl:value-of select="//*/clipLabel/AONDWEB_Genre" />/<xsl:value-of select="//*/clipLabel/AONDWEB_SubGenre" />
								</xsl:element>
							</xsl:element>
						</xsl:if>
						<xsl:if test="//*/clipLabel/AONDWEB_AvailStart or //*/clipLabel/AONDWEB_AvailEnd">
							<xsl:element name="tns:Rights">
								<xsl:if test="//*/clipLabel/AONDWEB_AvailStart">
									<xsl:element name="tns:AvailabilityWindowStart">
										<xsl:value-of select="//*/clipLabel/AONDWEB_AvailStart" />
									</xsl:element>
								</xsl:if>
								<xsl:if test="//*/clipLabel/AONDWEB_AvailEnd">
									<xsl:element name="tns:AvailabilityWindowEnd">
										<xsl:value-of select="//*/clipLabel/AONDWEB_AvailEnd" />
									</xsl:element>
								</xsl:if>
							</xsl:element>
						</xsl:if>
						<xsl:if test="videoLabel/AONDWEB_AudioFormat">
							<xsl:element name="tns:Audio">
								<xsl:element name="tns:Type">
									<xsl:value-of select="videoLabel/AONDWEB_AudioFormat" />
								</xsl:element>
							</xsl:element>
						</xsl:if>
						<xsl:if test="videoLabel/AONDWEB_Videofile">
							<xsl:element name="tns:Content">
								<xsl:element name="tns:Locator">
									<xsl:element name="tns:Uri">
										<xsl:value-of select="videoLabel/AONDWEB_Videofile" />
									</xsl:element>
								</xsl:element>
							</xsl:element>
						</xsl:if>
						<xsl:if test="videoLabel/AONDWEB_DRM">
							<xsl:element name="tns:Copyright">
								<xsl:element name="tns:CopyProtection">
									<xsl:if test="videoLabel/AONDWEB_DRM = 'yes'">true</xsl:if>
									<xsl:if test="videoLabel/AONDWEB_DRM = 'no'">false</xsl:if>
								</xsl:element>
							</xsl:element>
						</xsl:if>
						<xsl:element name="tns:TTVId">
							<xsl:element name="tns:Id">
								<xsl:value-of select="-5"/>
							</xsl:element>
						</xsl:element>
					</xsl:element>
					<xsl:for-each select="//*/clipLabel">
						<xsl:if test="inTimeMsec and outTimeMsec">
							<xsl:element name="tns:Relation">
								<xsl:attribute name="type">PARENT_CHILD</xsl:attribute>
								<xsl:element name="tns:Target">
									<xsl:element name="tns:Id">
										<xsl:value-of select="-position() - 7 - (count(//*/clipLabel) * 2)" />
									</xsl:element>
								</xsl:element>
							</xsl:element>
						</xsl:if>
					</xsl:for-each>
				</xsl:element>
			</xsl:if>

			<!-- Poster -->
			<xsl:if test="videoLabel/previewImage">
				<xsl:element name="tns:Item">
					<xsl:attribute name="type">POSTER</xsl:attribute>
					<xsl:element name="tns:Fields">
						<xsl:apply-templates select="videoLabel" mode="providerAndProductInfo" />
						<xsl:element name="tns:Content">
							<xsl:element name="tns:Locator">
								<xsl:element name="tns:Uri">
									<xsl:value-of select="videoLabel/previewImage" />
								</xsl:element>
							</xsl:element>
						</xsl:element>
						<xsl:element name="tns:TTVId">
							<xsl:element name="tns:Id">
								<xsl:value-of select="-6"/>
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:if>

			<!-- Encrypted -->
			<xsl:if test="videoLabel/BERT_DRM_Key">
				<xsl:element name="tns:Item">
					<xsl:attribute name="type">ENCRYPTED</xsl:attribute>
					<xsl:element name="tns:Fields">
						<xsl:apply-templates select="videoLabel" mode="providerAndProductInfo" />
						<xsl:element name="tns:Encryption">
							<xsl:element name="tns:KeyBlock">
								<xsl:value-of select="videoLabel/BERT_DRM_Key" />
							</xsl:element>
							<xsl:element name="tns:Type">nds</xsl:element>
						</xsl:element>
						<xsl:if test="videoLabel/BERT_Videofile">
							<xsl:element name="tns:Content">
								<xsl:element name="tns:Locator">
									<xsl:element name="tns:Uri">
										<xsl:value-of select="videoLabel/BERT_Videofile" />
									</xsl:element>
								</xsl:element>
							</xsl:element>
						</xsl:if>
						<xsl:element name="tns:Vendor">
							<xsl:element name="tns:Name">nds</xsl:element>
						</xsl:element>
						<xsl:element name="tns:TTVId">
							<xsl:element name="tns:Id">
								<xsl:value-of select="-7"/>
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:if>

			<!-- LogicalClips -->
			<xsl:for-each select="//*/clipLabel">
				<xsl:if test="inTimeMsec and outTimeMsec">
					<xsl:element name="tns:Item">
						<xsl:attribute name="type">LOGICALCLIP</xsl:attribute>
						<xsl:element name="tns:Fields">
							<xsl:apply-templates select="//*/videoLabel" mode="providerAndProductInfo" />
							<xsl:apply-templates select="." mode="logicalClip" />
							<xsl:element name="tns:TTVId">
								<xsl:element name="tns:Id">
									<xsl:value-of select="-position() - 7" />
								</xsl:element>
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:if>
				<xsl:if test="//*/clipLabel/AONTV_Available
								or //*/clipLabel/AONTV_Genre
								or //*/clipLabel/AONTV_SubGenre
								or //*/clipLabel/AONTV_Rubrics
								or //*/clipLabel/AONTV_Approved
								or //*/clipLabel/AONTV_AccessRights
								or //*/clipLabel/AONTV_ContractCode
								or //*/clipLabel/AONTV_LicenceStart
								or //*/clipLabel/AONTV_LicenceEnd
								or //*/videoLabel/AONTV_Videofile
								or //*/videoLabel/AONTV_DRM
								or //*/videoLabel/AONTV_AudioFormat">
					<xsl:if test="inTimeMsec and outTimeMsec">
						<xsl:element name="tns:Item">
							<xsl:attribute name="type">LOGICALCLIP</xsl:attribute>
							<xsl:element name="tns:Fields">
								<xsl:apply-templates select="//*/videoLabel" mode="providerAndProductInfo" />
								<xsl:apply-templates select="." mode="logicalClip" />
								<xsl:element name="tns:TTVId">
									<xsl:element name="tns:Id">
										<xsl:value-of select="-position() - 7 - count(//*/clipLabel)" />
									</xsl:element>
								</xsl:element>
							</xsl:element>
						</xsl:element>
					</xsl:if>
				</xsl:if>
				<xsl:if test="//*/clipLabel/AONDWEB_Available
								or //*/clipLabel/AONDWEB_Genre
								or //*/clipLabel/AONDWEB_SubGenre
								or //*/clipLabel/AONDWEB_Rubrics
								or //*/clipLabel/AONDWEB_Approved
								or //*/clipLabel/AONDWEB_AvailStart
								or //*/clipLabel/AONDWEB_AvailEnd
								or //*/videoLabel/AONDWEB_Videofile
								or //*/videoLabel/AONDWEB_DRM
								or //*/videoLabel/AONDWEB_AudioFormat">
					<xsl:if test="inTimeMsec and outTimeMsec">
						<xsl:element name="tns:Item">
							<xsl:attribute name="type">LOGICALCLIP</xsl:attribute>
							<xsl:element name="tns:Fields">
								<xsl:apply-templates select="//*/videoLabel" mode="providerAndProductInfo" />
								<xsl:apply-templates select="." mode="logicalClip" />
								<xsl:element name="tns:TTVId">
									<xsl:element name="tns:Id">
										<xsl:value-of select="-position() - 7 - (count(//*/clipLabel) * 2)" />
									</xsl:element>
								</xsl:element>
							</xsl:element>
						</xsl:element>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>

		</xsl:element>
	</xsl:template>

	<xsl:template match="videoLabel" mode="providerAndProductInfo">
		<xsl:if test="contentProvider | contentProviderID">
			<xsl:element name="tns:ProviderInfo">
				<xsl:if test="contentProvider">
					<xsl:element name="tns:Name">
						<xsl:value-of select="contentProvider" />
					</xsl:element>
				</xsl:if>
				<xsl:if test="contentProviderID">
					<xsl:element name="tns:Identifier">
						<xsl:element name="tns:Id">
							<xsl:value-of select="contentProviderID" />
						</xsl:element>
					</xsl:element>
				</xsl:if>
			</xsl:element>
		</xsl:if>
		<xsl:if test="Product">
			<xsl:element name="tns:ProductInfo">
				<xsl:element name="tns:Name">
					<xsl:value-of select="Product" />
				</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>

	<xsl:template match="clipLabel" mode="logicalClip">
		<xsl:if test="title">
			<xsl:element name="tns:Title">
				<xsl:element name="tns:DisplayTitle">
					<xsl:element name="tns:Value"><xsl:value-of select="title"/></xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:if>	
		<xsl:element name="tns:CustomFields">
			<xsl:element name="tns:CustomField">
				<xsl:attribute name="name">MarkIn</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="inTimeMsec" />
				</xsl:attribute>
			</xsl:element>
			<xsl:element name="tns:CustomField">
				<xsl:attribute name="name">MarkOut</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="outTimeMsec" />
				</xsl:attribute>
			</xsl:element>
		</xsl:element>
	</xsl:template>

</xsl:stylesheet>
