<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns fn">

<!-- Imports -->
<xsl:import href="from/common.xsl"/>
<xsl:import href="from/movie_preview_common.xsl"/>
<xsl:import href="from/preview_common.xsl"/>
<xsl:import href="from/logicalclip.xsl"/>
<xsl:import href="from/derived_original_asset.xsl"/>

<xsl:template name="previews">
	<xsl:for-each select="/tns:TTVSpec/tns:Group[@type = 'PREVIEW']">

	<xsl:variable name="app_name" select="tns:Fields/tns:ApplicationInfo/tns:Name" />

	<Asset>
		<Metadata>
			<xsl:choose>
			<!-- First preview. We always assume this is the original preview. -->
			<xsl:when test="position() = 1">
				<AMS xsl:use-attribute-sets="AmsAttributeSet" >
					<xsl:attribute name="Asset_Class">preview</xsl:attribute>
				</AMS>
			</xsl:when>
			<!-- 
			    Second+ preview. We assume these are derived previews. Alternate previews are not supported at this time.
			    Unlike alternate preview, derived preview has two extra fields: Source_Asset_ID and Source_Provider_ID.
			-->
			<xsl:otherwise>
				<AMS xsl:use-attribute-sets="AmsAttributeSet" >
					<xsl:attribute name="Asset_Class">encrypted</xsl:attribute>
				</AMS>
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Receiver_Type</xsl:attribute>
					<xsl:attribute name="Value">Unencrypted</xsl:attribute>
				</App_Data>
				<!-- Process reference to original asset -->
				<xsl:call-template name="derived_original_asset">
					<xsl:with-param name="type" select="'preview'" />
					<xsl:with-param name="app_name" select="$app_name" />
				</xsl:call-template>
			</xsl:otherwise>
			</xsl:choose>
			
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
				<xsl:attribute name="Name">Type</xsl:attribute>
				<xsl:attribute name="Value">preview</xsl:attribute>
			</App_Data>

			<!-- Common Movie and Preview metadata -->
			<xsl:call-template name="movie_preview_common">
				<xsl:with-param name="app_name" select="$app_name" />
				<xsl:with-param name="asset" select="." />
			</xsl:call-template>

			<!-- Common Preview metadata -->
			<xsl:call-template name="preview_common">
				<xsl:with-param name="app_name" select="$app_name" />
				<xsl:with-param name="asset" select="." />
			</xsl:call-template>

			<!-- HD Content -->
			<xsl:if test="tns:Fields/tns:Video/tns:HDContent">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">HDContent</xsl:attribute>
					<xsl:attribute name="Value">
						<xsl:choose>
							<xsl:when test="fn:lower-case(tns:Fields/tns:Video/tns:HDContent) = 'true'">Y</xsl:when>
							<xsl:otherwise>N</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</App_Data>
			</xsl:if>
			
			<!-- Bit Rate -->
			<xsl:if test="tns:Fields/tns:Video/tns:BitRate">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Bit_Rate</xsl:attribute>
					<xsl:attribute name="Value"><xsl:value-of select="tns:Fields/tns:Video/tns:BitRate/@value" /></xsl:attribute>
				</App_Data>
			</xsl:if>
		
			<!-- File Size -->
			<xsl:if test="tns:Fields/tns:Content/tns:Size/tns:length">
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
				<xsl:attribute name="Name">Content_FileSize</xsl:attribute>
				<xsl:attribute name="Value"><xsl:value-of select="tns:Fields/tns:Content/tns:Size/tns:length" /></xsl:attribute>
			</App_Data>
			</xsl:if>
		
			<!-- Checksum -->
			<xsl:if test="tns:Fields/tns:Content/tns:Checksum">
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
				<xsl:attribute name="Name">Content_CheckSum</xsl:attribute>
				<xsl:attribute name="Value"><xsl:value-of select="tns:Fields/tns:Content/tns:Checksum" /></xsl:attribute>
			</App_Data>
			</xsl:if>

			<!-- Resolution -->
			<xsl:if test="tns:Fields/tns:Content/tns:Resolution">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Resolution</xsl:attribute>
					<xsl:attribute name="Value"><xsl:value-of select="tns:Fields/tns:Content/tns:Resolution" /></xsl:attribute>
				</App_Data>
			</xsl:if>

			<!-- Mark In and Mark Out from Logical clips -->
			<xsl:for-each select="tns:Relation">
				<!-- Select first logical clip only -->
				<xsl:if test="position() = 1">
					<xsl:call-template name="logicalclip" >
						<xsl:with-param name="app_name" select="$app_name" />
						<xsl:with-param name="clip_id" select="tns:Target/tns:Id"/>
					</xsl:call-template>
				</xsl:if>				
			</xsl:for-each>
			
			<!--  Custom Field -->
			<xsl:apply-templates select="tns:Fields/tns:CustomFields"/>
			<xsl:apply-templates select="tns:Fields/tns:CustomFields-CL1_1"/>
		</Metadata>
		
		<Content xsl:use-attribute-sets="ContentAttributeSet" />
	</Asset>
	
</xsl:for-each>
</xsl:template>

</xsl:stylesheet>
