#!/bin/bash
# VCS Status Check
VCSBIN="/opt/VRTSvcs/bin"

# 1 = Green
# 2 = Yellow
# 3 = Red

# A (VCS Status)
    # RUNNING
    # FAULTED
    # EXITED

# B (Service Status)
    # ONLINE
    # OFFLINE
    # PARTIAL
    # PARTIAL|FAULTED
    # OFFLINE|FAULTED

#$VCSBIN/hastatus -sum

#get all systems in the cluster
SYSTEMS_ARRAY=(`$VCSBIN/hastatus -sum | grep "A  " | awk '{ print $2 }'`)
for VAR in ${SYSTEMS_ARRAY[@]}
do
    if   [[ -n `$VCSBIN/hastatus -sum | grep "A  " | grep ${VAR} | grep "FAULTED"` ]]
    then
       echo 3,${VAR},"Faulted",`grep $VAR /etc/hosts | awk '{ if ($1 !~ /#/) print $1 }'`
    elif [[ -n `$VCSBIN/hastatus -sum | grep "A  " | grep ${VAR} | grep "EXITED"` ]]
    then
       echo 3,${VAR},"Stopped",`grep $VAR /etc/hosts | awk '{ if ($1 !~ /#/) print $1 }'`
    elif [[ -n `$VCSBIN/hastatus -sum | grep "A  " | grep ${VAR} | grep "RUNNING"` ]]
    then
        if [[ -n `$VCSBIN/hastatus -sum | grep "B  " | grep ${VAR} | grep "FAULTED" | grep "CMSApp_Cluster"` ]]
        then
            echo 3,${VAR},"Faulted",`grep $VAR /etc/hosts | awk '{ if ($1 !~ /#/) print $1 }'`
        elif [[ -n `$VCSBIN/hastatus -sum | grep "B  " | grep ${VAR} | grep "PARTIAL" | grep "CMSApp_Cluster"` ]]
        then
            echo 2,${VAR},"Partial",`grep $VAR /etc/hosts | awk '{ if ($1 !~ /#/) print $1 }'`
        elif [[ -n `$VCSBIN/hastatus -sum | grep "B  " | grep ${VAR} | grep "OFFLINE" | grep "CMSApp_Cluster"` ]]
        then
            echo 2,${VAR},"Standby",`grep $VAR /etc/hosts | awk '{ if ($1 !~ /#/) print $1 }'`
        elif [[ -n `$VCSBIN/hastatus -sum | grep "B  " | grep ${VAR} | grep "ONLINE" | grep "CMSApp_Cluster"` ]]
        then
            echo 1,${VAR},"Primary",`grep $VAR /etc/hosts | awk '{ if ($1 !~ /#/) print $1 }'`
        else
            #echo "Oops! We missed something in the B Loop."
            echo ""
        fi
    else
        #echo "Oops! We missed something in the A Loop."
        echo ""
    fi
done

if [[ -n `$VCSBIN/hares -display Virtual_IP -attribute State | grep "ONLINE"` ]] ; then
    echo 1,"Virtual IP","Active",`$VCSBIN/hares -value Virtual_IP Address`
else
    echo 3,"Virtual IP","Stopped","Not Available"
fi

if [[ -n `$VCSBIN/hares -display vcsnotifier -attribute State 2>/dev/null | grep "ONLINE"` ]] ; then
    NOTIFIER=`hares -display vcsnotifier -attribute State | grep "ONLINE" | awk '{print $3}'`
    echo 1,"Notifier","Active",`grep $NOTIFIER /etc/hosts | awk '{print $1}'`
elif [[ -n `$VCSBIN/hares -display vcsnotifier -attribute State 2>/dev/null | grep "OFFLINE"` ]] ; then
    echo 3,"Notifier","Stopped","Not Available"
else 
    test $VCSBIN
fi
