#!/bin/bash
#
# This script takes one argument, the second manager's host name,
# and it configures VCS on both managers
# To Do: more checks

APP_GROUP_NAME="CMSApp_Cluster"
CONSOLEOUT="%-50s"

default_hostname1() {
HOSTNAME1=`hostname -s`
}

default_interface1() {
INTERFACE1=`/sbin/ifconfig | grep Ethernet | awk 'BEGIN {FS = "[: ]"} {print $1}' | uniq | sed -n 1p`
}

default_interface2() {
INTERFACE2=`/sbin/ifconfig | grep Ethernet | awk 'BEGIN {FS = "[: ]"} {print $1}' | uniq | sed -n 2p`
}

default_dbservername() {
    DBSERVERNAME="dbcluster-scan"
}

default_dbinstance() {
    DBINSTANCE="ttv"
}

#Set Defaults
default_hostname1
default_interface1
default_interface2
default_dbservername
default_dbinstance

while [[ $CORRECT != "y" ]]
do
    printf "$CONSOLEOUT" "Enter Primary Hostname [$HOSTNAME1]"
    read HOSTNAME1
    if [[ -z $HOSTNAME1 ]] ; then 
        default_hostname1
    fi

    printf "$CONSOLEOUT" "Enter Secondary Hostname [$HOSTNAME2]"
    read HOSTNAME2
    while [[ -z $HOSTNAME2 ]]
    do
        printf "$CONSOLEOUT" "Invalid Hostname, Enter Secondary Hostname"
        read HOSTNAME2
    done
    
    printf "$CONSOLEOUT \n" "Enter the Interface Name to be used for"
    printf "$CONSOLEOUT \n" "  the Management Network on the Systems"
    printf "$CONSOLEOUT" "  $HOSTNAME1 and $HOSTNAME2 [$INTERFACE1]"
    read INTERFACE1
    if [[ -z $INTERFACE1 ]] ; then 
        default_interface1
    fi
    
    printf "$CONSOLEOUT \n" "Enter the Interface Name to be used for the"
    printf "$CONSOLEOUT \n" "  Clusters Heartbeat Monitor on the Systems"
    printf "$CONSOLEOUT" "  $HOSTNAME1 and $HOSTNAME2 [$INTERFACE2]"
    read INTERFACE2
    if [[ -z $INTERFACE2 ]] ; then 
        default_interface2
    fi
    
    printf "$CONSOLEOUT" "Enter Virtual IP for the Cluster [$VIRTUALIP]"
    while [[ -z $VIRTUALIP ]]
    do
    read VIRTUALIP
    if [[ -z $VIRTUALIP ]] ; then 
        printf "$CONSOLEOUT" "Invalid IP, Enter Virtual IP for the Cluster"
    elif [[ -z `echo $VIRTUALIP | awk -F"." '$1 <=255 && $2 <= 255 && $3 <= 255 && $4 <= 255'` ]] ; then
        VIRTUALIP=""
        printf "$CONSOLEOUT" "Invalid IP, Enter Virtual IP for the Cluster"
    else
        VIRTUALIP=$VIRTUALIP
    fi
    done
    
    printf "$CONSOLEOUT" "Enter the Subnet Mask for the Virtual IP [$VIRTUALMASK]"
    while [[ -z $VIRTUALMASK ]]
    do
    read VIRTUALMASK
    if [[ -z $VIRTUALMASK ]] ; then 
        printf "$CONSOLEOUT" "Invalid IP, Enter the Subnet Mask for the Virtual IP"
    elif [[ -z `echo $VIRTUALMASK | awk -F"." '$1 <=255 && $2 <= 255 && $3 <= 255 && $4 <= 255'` ]] ; then
        VIRTUALMASK=""
        printf "$CONSOLEOUT" "Invalid IP, Enter the Subnet Mask for the Virtual IP"
    else
        VIRTUALMASK=$VIRTUALMASK
    fi
    
    printf "$CONSOLEOUT" "Enter Database Servername/Host Alias [$DBSERVERNAME]"
    read DBSERVERNAME
    if [[ -z $DBSERVERNAME ]] ; then 
        default_dbservername
    fi

    printf "$CONSOLEOUT" "Enter Database Instance Name [$DBINSTANCE]"
    read DBINSTANCE
    if [[ -z $DBINSTANCE ]] ; then 
        default_dbinstance
    fi

    done

    echo ""
    echo "Attempting to collect additional information"    

    HOSTNAME1IP=`hostname -i`
    HOSTNAME1MAC1=`ifconfig $INTERFACE1 | grep HWaddr | awk '{print $5}'`
    HOSTNAME1MAC2=`ifconfig $INTERFACE2 | grep HWaddr | awk '{print $5}'`

    HOSTNAME2IP=`ssh -l root $HOSTNAME2 hostname -i`
    HOSTNAME2MAC1=`ssh -l root $HOSTNAME2 ifconfig $INTERFACE1 | grep HWaddr | awk '{print $5}'` 
    HOSTNAME2MAC2=`ssh -l root $HOSTNAME2 ifconfig $INTERFACE2 | grep HWaddr | awk '{print $5}'`

    CLUSTERID=`echo $VIRTUALIP | awk -F"." '{print $4}'`

    echo ""
    printf "$CONSOLEOUT $CONSOLEOUT\n" "Primary Host Name" $HOSTNAME1
    printf "$CONSOLEOUT $CONSOLEOUT\n" "Primary Host IP" $HOSTNAME1IP
    printf "$CONSOLEOUT $CONSOLEOUT\n" "   $INTERFACE1 HWaddr" $HOSTNAME1MAC1
    printf "$CONSOLEOUT $CONSOLEOUT\n" "   $INTERFACE2 HWaddr" $HOSTNAME1MAC2
    echo ""
    printf "$CONSOLEOUT $CONSOLEOUT\n" "Secondary Host Name" $HOSTNAME2
    printf "$CONSOLEOUT $CONSOLEOUT\n" "Secondary Host IP" $HOSTNAME2IP
    printf "$CONSOLEOUT $CONSOLEOUT\n" "   $INTERFACE1 HWaddr" $HOSTNAME2MAC1
    printf "$CONSOLEOUT $CONSOLEOUT\n" "   $INTERFACE2 HWaddr" $HOSTNAME2MAC2
    echo ""
    printf "$CONSOLEOUT $CONSOLEOUT\n" "Virtual IP" $VIRTUALIP
    printf "$CONSOLEOUT $CONSOLEOUT\n" "Subnet Mask for Virtual IP" $VIRTUALMASK
    printf "$CONSOLEOUT $CONSOLEOUT\n" "Cluser ID" $CLUSTERID
    echo ""
    printf "$CONSOLEOUT $CONSOLEOUT\n" "Database Servername/Host Alias" $DBSERVERNAME
    printf "$CONSOLEOUT $CONSOLEOUT\n" "Database Instance Name" $DBINSTANCE
    echo ""
    printf "$CONSOLEOUT " "Is this correct? [y/n]"
    read CORRECT
done

VCSBIN="/opt/VRTSvcs/bin"
CHKCONFIG="/sbin/chkconfig"
CLUSTER_NAME="CMSApp_Cluster"

echo "Enabling service to start by default on $HOSTNAME1"
    chkconfig --add amf
    chkconfig --add gab
    chkconfig --add llt
    chkconfig --add vcs
    chkconfig --add vxatd
    chkconfig --add vxfen

echo "Enabling service to start by default on $HOSTNAME2"
    ssh -l root $HOSTNAME2 chkconfig --add amf
    ssh -l root $HOSTNAME2 chkconfig --add gab
    ssh -l root $HOSTNAME2 chkconfig --add llt
    ssh -l root $HOSTNAME2 chkconfig --add vcs
    ssh -l root $HOSTNAME2 chkconfig --add vxatd
    ssh -l root $HOSTNAME2 chkconfig --add vxfen

echo "Turning off the vcs components on $HOSTNAME1"
    /etc/init.d/vcs stop
    /etc/init.d/gab stop
    /etc/init.d/llt stop

echo "Turning off the vcs components on $HOSTNAME2"
    ssh -l root $HOSTNAME2 /etc/init.d/vcs stop
    ssh -l root $HOSTNAME2 /etc/init.d/gab stop
    ssh -l root $HOSTNAME2 /etc/init.d/llt stop

echo "Creating /etc/llttab file for $HOSTNAME1"
echo "set-node $HOSTNAME1"                             >  /etc/llttab
echo "set-cluster $CLUSTERID"                          >> /etc/llttab
echo "link $INTERFACE1 eth-$HOSTNAME1MAC1 - ether - -" >> /etc/llttab
echo "link $INTERFACE2 eth-$HOSTNAME1MAC2 - ether - -" >> /etc/llttab
#cat /etc/llttab

echo "Creating /etc/llttab file for $HOSTNAME2"
echo "set-node $HOSTNAME2"                             >  /tmp/llttab_$HOSTNAME2
echo "set-cluster $CLUSTERID"                          >> /tmp/llttab_$HOSTNAME2
echo "link $INTERFACE1 eth-$HOSTNAME2MAC1 - ether - -" >> /tmp/llttab_$HOSTNAME2
echo "link $INTERFACE2 eth-$HOSTNAME2MAC2 - ether - -" >> /tmp/llttab_$HOSTNAME2
#cat /tmp/llttab_$HOSTNAME2
    scp /tmp/llttab_$HOSTNAME2 $HOSTNAME2:/etc/llttab

echo "Creating /etc/llthosts file for $HOSTNAME1"
echo "0 $HOSTNAME1" >  /etc/llthosts
echo "1 $HOSTNAME2" >> /etc/llthosts
echo "Creating /etc/llthosts file for $HOSTNAME2"
    scp /etc/llthosts $HOSTNAME2:/etc/llthosts

echo "Creating /etc/gabtab file for $HOSTNAME1"
echo "/sbin/gabconfig -c -n1" > /etc/gabtab
echo "Creating /etc/gabtab file for $HOSTNAME2"
    scp /etc/gabtab $HOSTNAME2:/etc/gabtab

sleep 5

/opt/VRTSvcs/bin/uuidconfig.pl -clus -configure $HOSTNAME1 $HOSTNAME2

/etc/init.d/llt start
$CHKCONFIG --level 35 llt on
ssh -l root $HOSTNAME2 /etc/init.d/llt start
ssh -l root $HOSTNAME2 $CHKCONFIG --level 35 llt on

/etc/init.d/gab start
$CHKCONFIG --level 35 gab on
ssh -l root $HOSTNAME2 /etc/init.d/gab start
ssh -l root $HOSTNAME2 $CHKCONFIG --level 35 gab on

/etc/init.d/vcs start
$CHKCONFIG --level 35 vcs on
ssh -l root $HOSTNAME2 /etc/init.d/vcs start
ssh -l root $HOSTNAME2 $CHKCONFIG --level 35 vcs on

sleep 3
echo "Restarting VCS on $HOSTNAME1"
    $VCSBIN/hastart
echo "Restarting VCS on $HOSTNAME2"
    ssh $HOSTNAME2 $VCSBIN/hastart
sleep 5
echo "Current Status:"
    $VCSBIN/hastatus -sum

   
$VCSBIN/haconf -makerw

# Define the group(s) in the Cluster
echo "Defining the cluster group: $APP_GROUP_NAME"
$VCSBIN/haclus -modify  PrintMsg 0
$VCSBIN/haclus -modify  UserNames admin cJKcJEjGKfKKiSKeJH nobody Gn
$VCSBIN/haclus -modify  ClusterAddress "127.0.0.1"
$VCSBIN/haclus -modify  Administrators admin nobody
$VCSBIN/haclus -modify  SourceFile "./main.cf"
$VCSBIN/haclus -modify  ClusterName CMSApp

# Add defined systems to the group
echo "Adding the hosts to the cluster group"
$VCSBIN/hasys -add $HOSTNAME1
$VCSBIN/hasys -modify $HOSTNAME1 SourceFile "./main.cf"
$VCSBIN/hasys -add $HOSTNAME2
$VCSBIN/hasys -modify $HOSTNAME2 SourceFile "./main.cf"

# Create The Manager_Cluster Group
echo "Creating the cluster group: $APP_GROUP_NAME"
$VCSBIN/hagrp -add $APP_GROUP_NAME
$VCSBIN/hagrp -modify $APP_GROUP_NAME SystemList  $HOSTNAME1 0 $HOSTNAME2 1
$VCSBIN/hagrp -modify $APP_GROUP_NAME VCSi3Info  "" "" -sys $HOSTNAME1
$VCSBIN/hagrp -modify $APP_GROUP_NAME AutoStartList  $HOSTNAME1 $HOSTNAME2
$VCSBIN/hagrp -modify $APP_GROUP_NAME SourceFile "./main.cf"

# Create Hardware NIC Resource
echo "Adding the network card to the cluster group: $APP_GROUP_NAME"
$VCSBIN/hares -add Network_Card NIC $APP_GROUP_NAME
$VCSBIN/hares -local Network_Card Device
$VCSBIN/hares -modify Network_Card Device $INTERFACE1 -sys $HOSTNAME1
$VCSBIN/hares -modify Network_Card Device $INTERFACE1 -sys $HOSTNAME2
$VCSBIN/hares -modify Network_Card PingOptimize 1
$VCSBIN/hares -modify Network_Card Mii 1 #Lookup
$VCSBIN/hares -modify Network_Card Enabled 1

# Create Virtual IP Resource
echo "Adding the virtual ip resource to the cluster group: $APP_GROUP_NAME"
$VCSBIN/hares -add Virtual_IP IP $APP_GROUP_NAME
$VCSBIN/hares -local Virtual_IP Device
$VCSBIN/hares -modify Virtual_IP Device $INTERFACE1 -sys $HOSTNAME1
$VCSBIN/hares -modify Virtual_IP Device $INTERFACE1 -sys $HOSTNAME2
$VCSBIN/hares -modify Virtual_IP Address $VIRTUALIP
$VCSBIN/hares -modify Virtual_IP NetMask $VIRTUALMASK
$VCSBIN/hares -modify Virtual_IP ArpDelay 1
$VCSBIN/hares -modify Virtual_IP Enabled 1

$VCSBIN/haconf -dump -makero

echo "Configuring Database Strings for HA"
bash /usr/sbin/sysprep/sysprep.UpdateDBStrings.sh --HA $DBSERVERNAME $DBINSTANCE
ssh -l root $HOSTNAME2 bash /usr/sbin/sysprep/sysprep.UpdateDBStrings.sh --HA $DBSERVERNAME $DBINSTANCE

echo "Configuring Database Mounts"
/usr/sbin/sysprep/sysprep.NFSSetup.sh $DBSERVERNAME
ssh -l root $HOSTNAME2 /usr/sbin/sysprep/sysprep.NFSSetup.sh $DBSERVERNAME

echo -n "Would you like the configure the E-mail Notifer Service now? (y/n) " 
read SETUPEMAIL
if [[ $SETUPEMAIL == "y" ]] ; then 
    bash /opt/tandbergtv/cms/scripts/veritas/create_email_alert.sh
else
    echo "You can configure the E-mail Notifer Service later by running create_email_alert.sh"
fi
