#!/bin/bash

NTFR_GROUP_NAME="CMSApp_Notifier"
VCSBIN="/opt/VRTSvcs/bin"
HA_CURRENT_SYSTEM=`hostname -s`
HA_ALT_SYSTEM=(`$VCSBIN/hastatus -sum | grep "A  " | awk '{ print $2 }' | grep -v $HA_CURRENT_SYSTEM`)
HOSTNAME1=$HA_CURRENT_SYSTEM
HOSTNAME2=$HA_ALT_SYSTEM
CONSOLEOUT="%-50s"

while [[ $CORRECT != "y" ]]
do
    printf "$CONSOLEOUT" "Enter SMTP Mail Server Name or IP "
    read SMTP_SERVER

    printf "$CONSOLEOUT" "Enter Senders \"From\" Name"
    read SMTP_FROM
     
    # Begin Multi Email Loop
    # i=0
    # while [[ $CONTINUE != "n" ]]
    # do

    printf "$CONSOLEOUT" "Enter Recipient E-mail Address"
    RECIP_EMAIL=""
    while [[ -z $RECIP_EMAIL ]]
    do
    read RECIP_EMAIL
    if [[ -z `echo $RECIP_EMAIL | awk 'BEGIN { RS = "[.@]*[^-0-9A-Za-z_.@]+[.@]*" } /@/' ` ]] ; then
        RECIP_EMAIL="" #Clear String
        printf "$CONSOLEOUT" "Invalid E-mail Address, Enter Again"
    fi
    done
        
        # echo "Number in array"  $i # Debug
        # echo "Content in array" ${ESTRING[$i]} # Debug
        
        #Reporting Level Loop
        # echo "Level of Reporting"
        # echo "    1 or Information: Important events that exhibit normal behavior; Information is the lowest severity level. "
        # echo "    2 or Warning:     Deviations from normal behavior"
        # echo "    3 or Error:       Faults (Recomended)"
        # echo "    4 or SevereError: Critical errors that can lead to data loss or corruption; SevereError is the highest severity level."
        # printf "$CONSOLEOUT" "Enter Level of Reporting"
        # LEVEL="" #Clear String
        # while [[ $LEVEL == "" ]]
        # do
        # read LEVEL
        # case "$LEVEL" in
            # 1|[iI]nfo*) 
                # LEVEL="Information"
                # LSTRING[$i]=$LEVEL
            # ;;
            # 2|[[wW]arn*)
                # LEVEL="Warning"
                # LSTRING[$i]=$LEVEL
            # ;;
            # 3|[eE]rror)
                # LEVEL="Error"
                # LSTRING[$i]=$LEVEL
            # ;;
            # 4|[sS]ever*)
                # LEVEL="SevereError"
                # LSTRING[$i]=$LEVEL
            # ;;
            # *)
            # printf "$CONSOLEOUT" "Invalid Enter Level of Reporting"
            # LEVEL="" #Clear String
        # esac
        # done
        
        # echo "Number in array"  $i # Debug
        # echo "Content in array" ${LSTRING[$i]} # Debug  
        
    # printf "$CONSOLEOUT" "Do you want to add another SMTP recipient?? [y/n]"
    # i=`expr $i + 1`
    # read CONTINUE
    # done

    echo ""
    printf "$CONSOLEOUT$CONSOLEOUT\n" "SMTP Mail Server Name is" $SMTP_SERVER
    printf "$CONSOLEOUT$CONSOLEOUT\n" "Senders Name" $SMTP_FROM
    printf "$CONSOLEOUT$CONSOLEOUT\n" "Recipient E-mail Address" $RECIP_EMAIL

    #List Array of Emails and Levels 
    # for i in "${!ESTRING[@]}"
    # do
        # echo "key  : $i"
        # echo "value:" ${ESTRING[$i]} ${LSTRING[$i]}
    # done   

    printf "$CONSOLEOUT" "Is this correct? [y/n]"
    read CORRECT
done
#Example of multiple recipients and different alerting levels  
# $VCSBIN/haconf -makerw
# $VCSBIN/hares -add vcsnotifier NotifierMngr CMSApp_Notifier
# $VCSBIN/hares -modify vcsnotifier SmtpServer <xxx.xxx.xxx.xxx>
# $VCSBIN/hares -modify vcsnotifier SmtpFromPath <name you want to see in e-mail>
# $VCSBIN/hares -modify vcsnotifier SmtpRecipients <yyy@yyy.yyy> <Error> <zzz@zzz.zzz> <Warning>
# $VCSBIN/hares -modify vcsnotifier SmtpServerVrfyOff 1
# $VCSBIN/hares -modify vcsnotifier Enabled 1
# $VCSBIN/haconf -dump -makero


$VCSBIN/haconf -makerw

echo "Removing previous Group and Resource if it exists."
$VCSBIN/hares -delete vcsnotifier
$VCSBIN/hagrp -delete $NTFR_GROUP_NAME

echo "Defining the group: $NTFR_GROUP_NAME"
$VCSBIN/hagrp -add $NTFR_GROUP_NAME
$VCSBIN/hagrp -modify $NTFR_GROUP_NAME SystemList  $HOSTNAME1 0 $HOSTNAME2 1
$VCSBIN/hagrp -modify $NTFR_GROUP_NAME VCSi3Info  "" "" -sys $HOSTNAME1
$VCSBIN/hagrp -modify $NTFR_GROUP_NAME AutoStartList  $HOSTNAME1 $HOSTNAME2
$VCSBIN/hagrp -modify $NTFR_GROUP_NAME SourceFile "./main.cf"

echo "   Adding vcsnotifier as a Resource to $NTFR_GROUP_NAME"
$VCSBIN/hares -add vcsnotifier NotifierMngr $NTFR_GROUP_NAME
$VCSBIN/hares -modify vcsnotifier SmtpServer $SMTP_SERVER
$VCSBIN/hares -modify vcsnotifier SmtpFromPath $SMTP_FROM
$VCSBIN/hares -modify vcsnotifier SmtpRecipients $RECIP_EMAIL Error
$VCSBIN/hares -modify vcsnotifier SmtpServerVrfyOff 1
$VCSBIN/hares -modify vcsnotifier Enabled 1

$VCSBIN/haconf -dump -makero

echo "VCS needs to be restarted for the e-mail setting to take effect."