#!/bin/bash

CLUSTER_NAME="CMSApp_Cluster"
VCSBIN="/opt/VRTSvcs/bin"
HA_CURRENT_SYSTEM=`hostname -s`
HA_ALT_SYSTEM=(`$VCSBIN/hastatus -sum | grep "A  " | awk '{ print $2 }' | grep -v $HA_CURRENT_SYSTEM`)

# echo $HA_CURRENT_SYSTEM
# echo $HA_ALT_SYSTEM

### Where all the Magic Begins ###

# chkconfig --add tomcat
# chkconfig --add alerts
# chkconfig --add cms
# chkconfig --add xporttomcat
# chkconfig --add xportmanager
# chkconfig --add RCSSchedulerService

# chkconfig --del tomcat
# chkconfig --del alerts
# chkconfig --del cms
# chkconfig --del xporttomcat
# chkconfig --del xportmanager
# chkconfig --del RCSSchedulerService

# ssh -l root $HOSTNAME2 <cmd>


usage() {
    echo ""
    echo "Usage: $0 [--add] or [--remove] [service]"
    echo "   Services Available:"
    echo "      alerts"
    echo "      cms"
    echo "      tomcat"
    echo "      xporttomcat"
    echo "      xportmanager"
    echo "      RCSSchedulerService"
    echo "      autorsync"
    echo "      all (includes all aforementioned services)"
    echo ""
}

make_readwrite_resource() {
echo "   Making $CLUSTER_NAME Writable"
    $VCSBIN/haconf -makerw
}

make_readonly_resource() {
echo "   Making $CLUSTER_NAME Read-only"
    $VCSBIN/haconf -dump -makero
}

add_alerts_resource() {
echo "   Adding Alerts as a Resource to $CLUSTER_NAME"
    $VCSBIN/hares -add alerts Application $CLUSTER_NAME
    $VCSBIN/hares -modify alerts StartProgram "/etc/init.d/alerts start --VCSOverride"
    $VCSBIN/hares -modify alerts StopProgram "/etc/init.d/alerts stop --VCSOverride"
    $VCSBIN/hares -modify alerts PidFiles "/etc/init.d/alerts.pid" "/etc/init.d/alerts-nameservice.pid" "/etc/init.d/alerts-settingserver.pid"
    $VCSBIN/hares -modify alerts User root
    $VCSBIN/hares -modify alerts UseSUDash 0
    $VCSBIN/hares -modify alerts Enabled 1
}

add_alerts-vip_link_resource() {
    echo "   Adding Alerts Resource as Dependency of the Virtual IP Resource in $CLUSTER_NAME"
    $VCSBIN/hares -link alerts Virtual_IP
}

remove_alerts_resource() {
echo "   Removing Alerts as a Resource from $CLUSTER_NAME"
    $VCSBIN/hares -delete alerts
}

add_alerts_service() {
echo "   Enabeling Alerts to automatically start up upon reboot on $HA_CURRENT_SYSTEM"
    chkconfig --add alerts
echo "   Enabeling Alerts to automatically start up upon reboot on $HA_ALT_SYSTEM"
    ssh -l root $HA_ALT_SYSTEM chkconfig --add alerts
}

remove_alerts_service() {
echo "   Disabling Alerts from starting up automatically upon reboot on $HA_CURRENT_SYSTEM"
    chkconfig --del alerts
echo "   Disabling Alerts from starting up automatically upon reboot on $HA_ALT_SYSTEM"
    ssh -l root $HA_ALT_SYSTEM chkconfig --del alerts
}

add_cms_resource() {
    echo "   Adding CMS as a Resource to $CLUSTER_NAME"
    $VCSBIN/hares -add cms Application $CLUSTER_NAME
    $VCSBIN/hares -modify cms StartProgram "/etc/init.d/cms start --VCSOverride"
    $VCSBIN/hares -modify cms StopProgram "/etc/init.d/cms stop --VCSOverride"
    $VCSBIN/hares -modify cms PidFiles "/etc/init.d/cms.pid" "/etc/init.d/cms-adinameservice.pid"
    $VCSBIN/hares -modify cms User root
    $VCSBIN/hares -modify cms UseSUDash 0
    $VCSBIN/hares -modify cms Enabled 1
}

add_cms-alerts_link_resource() {
    echo "   Adding CMS Resource as Dependency of Alerts Resource in $CLUSTER_NAME"
    $VCSBIN/hares -link cms alerts
}

add_cms_service() {
echo "   Enabeling CMS to automatically start up upon reboot on $HA_CURRENT_SYSTEM"
    chkconfig --add cms
echo "   Enabeling CMS to automatically start up upon reboot on $HA_ALT_SYSTEM"
    ssh -l root $HA_ALT_SYSTEM chkconfig --add cms
}

remove_cms_service() {
echo "   Disabling CMS from starting up automatically upon reboot on $HA_CURRENT_SYSTEM"
    chkconfig --del cms
echo "   Disabling CMS from starting up automatically upon reboot on $HA_ALT_SYSTEM"
    ssh -l root $HA_ALT_SYSTEM chkconfig --del cms
}

remove_cms-alerts_link_resource() {
    echo "   Removing CMS Resource as Dependency of Alerts Resource in $CLUSTER_NAME"
    $VCSBIN/hares -unlink cms alerts
}

remove_cms_resource() {
echo "   Removing CMS as a Resource from $CLUSTER_NAME"
    $VCSBIN/hares -delete cms
}

add_tomcat_resource() {
    echo "   Adding Tomcat as a Resource to $CLUSTER_NAME"
    $VCSBIN/hares -add tomcat Application $CLUSTER_NAME
    $VCSBIN/hares -modify tomcat StartProgram "/etc/init.d/tomcat start --VCSOverride"
    $VCSBIN/hares -modify tomcat StopProgram "/etc/init.d/tomcat stop --VCSOverride"
    $VCSBIN/hares -modify tomcat PidFiles "/etc/init.d/tomcat.pid"
    $VCSBIN/hares -modify tomcat User root
    $VCSBIN/hares -modify tomcat UseSUDash 0
    $VCSBIN/hares -modify tomcat Enabled 1
}

add_tomcat-vip_link_resource() {
    echo "   Adding Tomcat Resource as Dependency of the Virtual IP Resource in $CLUSTER_NAME"
    $VCSBIN/hares -link tomcat Virtual_IP
}

remove_tomcat_resource() {
echo "   Removing Tomcat as a Resource from $CLUSTER_NAME"
    $VCSBIN/hares -delete tomcat
}

add_tomcat_service() {
echo "   Enabeling Tomcat to automatically start up upon reboot on $HA_CURRENT_SYSTEM"
    chkconfig --add tomcat
echo "   Enabeling Tomcat to automatically start up upon reboot on $HA_ALT_SYSTEM"
    ssh -l root $HA_ALT_SYSTEM chkconfig --add tomcat
}

remove_tomcat_service() {
echo "   Disabling Tomcat from starting up automatically upon reboot on $HA_CURRENT_SYSTEM"
    chkconfig --del tomcat
echo "   Disabling Tomcat from starting up automatically upon reboot on $HA_ALT_SYSTEM"
    ssh -l root $HA_ALT_SYSTEM chkconfig --del tomcat
}

add_xporttomcat_resource() {
    echo "   Adding xPortTomcat as a Resource to $CLUSTER_NAME"
    $VCSBIN/hares -add xporttomcat Application $CLUSTER_NAME
    $VCSBIN/hares -modify xporttomcat StartProgram "/etc/init.d/xporttomcat start --VCSOverride"
    $VCSBIN/hares -modify xporttomcat StopProgram "/etc/init.d/xporttomcat stop --VCSOverride"
    $VCSBIN/hares -modify xporttomcat PidFiles "/etc/init.d/xporttomcat.pid"
    $VCSBIN/hares -modify xporttomcat User root
    $VCSBIN/hares -modify xporttomcat UseSUDash 0
    $VCSBIN/hares -modify xporttomcat Enabled 1
}

add_xporttomcat-vip_link_resource() {
    echo "   Adding xPortTomcat Resource as Dependency of the Virtual IP Resource in $CLUSTER_NAME"
    $VCSBIN/hares -link xporttomcat Virtual_IP
}

remove_xporttomcat_resource() {
echo "   Removing xPortTomcat as a Resource from $CLUSTER_NAME"
    $VCSBIN/hares -delete xporttomcat
}

add_xporttomcat_service() {
echo "   Enabeling xPortTomcat to automatically start up upon reboot on $HA_CURRENT_SYSTEM"
    chkconfig --add xporttomcat
echo "   Enabeling xPortTomcat to automatically start up upon reboot on $HA_ALT_SYSTEM"
    ssh -l root $HA_ALT_SYSTEM chkconfig --add xporttomcat
}

remove_xporttomcat_service() {
echo "   Disabling xPortTomcat from starting up automatically upon reboot on $HA_CURRENT_SYSTEM"
    chkconfig --del xporttomcat
echo "   Disabling xPortTomcat from starting up automatically upon reboot on $HA_ALT_SYSTEM"
    ssh -l root $HA_ALT_SYSTEM chkconfig --del xporttomcat
}

add_xportmanager_resource() {
    echo "   Adding xPortManager as a Resource to $CLUSTER_NAME"
    $VCSBIN/hares -add xportmanager Application $CLUSTER_NAME
    $VCSBIN/hares -modify xportmanager StartProgram "/etc/init.d/xportmanager start --VCSOverride"
    $VCSBIN/hares -modify xportmanager StopProgram "/etc/init.d/xportmanager stop --VCSOverride"
    $VCSBIN/hares -modify xportmanager PidFiles "/etc/init.d/xportmanager.pid"
    $VCSBIN/hares -modify xportmanager User root
    $VCSBIN/hares -modify xportmanager UseSUDash 0
    $VCSBIN/hares -modify xportmanager Enabled 1
}

add_xportmanager-vip_link_resource() {
    echo "   Adding xPortManager Resource as Dependency of the Virtual IP Resource in $CLUSTER_NAME"
    $VCSBIN/hares -link xportmanager Virtual_IP
}

remove_xportmanager_resource() {
echo "   Removing xPortManager as a Resource from $CLUSTER_NAME"
    $VCSBIN/hares -delete xportmanager
}

add_xportmanager_service() {
echo "   Enabeling xPortManager to automatically start up upon reboot on $HA_CURRENT_SYSTEM"
    chkconfig --add xportmanager
echo "   Enabeling xPortManager to automatically start up upon reboot on $HA_ALT_SYSTEM"
    ssh -l root $HA_ALT_SYSTEM chkconfig --add xportmanager
}

remove_xportmanager_service() {
echo "   Disabling xPortManager from starting up automatically upon reboot on $HA_CURRENT_SYSTEM"
    chkconfig --del xportmanager
echo "   Disabling xPortManager from starting up automatically upon reboot on $HA_ALT_SYSTEM"
    ssh -l root $HA_ALT_SYSTEM chkconfig --del xportmanager
}

add_RCSSchedulerService_resource() {
    echo "   Adding RCSScheduler as a Resource to $CLUSTER_NAME"
    $VCSBIN/hares -add RCSSchedulerService Application $CLUSTER_NAME
    $VCSBIN/hares -modify RCSSchedulerService StartProgram "/etc/init.d/RCSSchedulerService start --VCSOverride"
    $VCSBIN/hares -modify RCSSchedulerService StopProgram "/etc/init.d/RCSSchedulerService stop --VCSOverride"
    $VCSBIN/hares -modify RCSSchedulerService PidFiles "/usr/local/tstv/RCSScheduler/config/rcsScheduler.pid"
    $VCSBIN/hares -modify RCSSchedulerService User root
    $VCSBIN/hares -modify RCSSchedulerService UseSUDash 0
    $VCSBIN/hares -modify RCSSchedulerService Enabled 1
}

add_RCSSchedulerService-vip_link_resource() {
    echo "   Adding RCSSchedulerService Resource as Dependency of the Virtual IP Resource in $CLUSTER_NAME"
    $VCSBIN/hares -link RCSSchedulerService Virtual_IP
}

remove_RCSSchedulerService_resource() {
echo "   Removing RCSScheduler as a Resource from $CLUSTER_NAME"
    $VCSBIN/hares -delete RCSSchedulerService
}

add_RCSSchedulerService_service() {
echo "   Enabeling RCSScheduler to automatically start up upon reboot on $HA_CURRENT_SYSTEM"
    chkconfig --add RCSSchedulerService
echo "   Enabeling RCSScheduler to automatically start up upon reboot on $HA_ALT_SYSTEM"
    ssh -l root $HA_ALT_SYSTEM chkconfig --add RCSSchedulerService
}

remove_RCSSchedulerService_service() {
echo "   Disabling RCSScheduler from starting up automatically upon reboot on $HA_CURRENT_SYSTEM"
    chkconfig --del RCSSchedulerService
echo "   Disabling RCSScheduler from starting up automatically upon reboot on $HA_ALT_SYSTEM"
    ssh -l root $HA_ALT_SYSTEM chkconfig --del RCSSchedulerService
}

add_autorsync_resource() {
    echo "   Adding Autorsync as a Resource to $CLUSTER_NAME"
    $VCSBIN/hares -add autorsync Application $CLUSTER_NAME
    $VCSBIN/hares -modify autorsync StartProgram "/etc/init.d/autorsync start --VCSOverride"
    $VCSBIN/hares -modify autorsync StopProgram "/etc/init.d/autorsync stop --VCSOverride"
    $VCSBIN/hares -modify autorsync PidFiles "/etc/init.d/autorsync.pid"
    $VCSBIN/hares -modify autorsync User root
    $VCSBIN/hares -modify autorsync UseSUDash 0
    $VCSBIN/hares -modify autorsync Enabled 1
}

add_autorsync-vip_link_resource() {
    echo "   Adding Autorsync Resource as Dependency of the Virtual IP Resource in $CLUSTER_NAME"
    $VCSBIN/hares -link autorsync Virtual_IP
}

remove_autorsync_resource() {
echo "   Removing Autorsync as a Resource from $CLUSTER_NAME"
    $VCSBIN/hares -delete autorsync
}

if [[ "$1" == "--add" ]]
then
    case "$2" in
    alerts)
        make_readwrite_resource
        add_alerts_resource
        add_alerts-vip_link_resource
        make_readonly_resource
        remove_alerts_service ;;
    cms)
        make_readwrite_resource
        add_cms_resource
        add_cms-alerts_link_resource
        make_readonly_resource 
        remove_cms_service ;;
    tomcat)
        make_readwrite_resource
        add_tomcat_resource
        add_tomcat-vip_link_resource
        make_readonly_resource 
        remove_tomcat_service ;;
    xporttomcat)
        make_readwrite_resource
        add_xporttomcat_resource
        add_xporttomcat-vip_link_resource
        make_readonly_resource 
        remove_xporttomcat_service ;;
    xportmanager)
        make_readwrite_resource
        add_xportmanager-vip_link_resource
        make_readonly_resource 
        remove_xportmanager_service ;;
    RCSSchedulerService)
        make_readwrite_resource
        add_RCSSchedulerService_resource 
        add_RCSSchedulerService-vip_link_resource
        make_readonly_resource 
        remove_RCSSchedulerService_service ;;
    autorsync)
        make_readwrite_resource
        add_autorsync_resource
        add_autorsync-vip_link_resource
        make_readonly_resource ;;
    all)
        remove_alerts_service
        remove_cms_service
        remove_tomcat_service
        remove_xporttomcat_service
        remove_xportmanager_service
        remove_RCSSchedulerService_service
        make_readwrite_resource
        add_alerts_resource
        add_alerts-vip_link_resource
        add_cms_resource
        add_cms-alerts_link_resource
        add_tomcat_resource
        add_tomcat-vip_link_resource
        add_xporttomcat_resource
        add_xporttomcat-vip_link_resource
        add_xportmanager_resource
        add_xportmanager-vip_link_resource
        #add_RCSSchedulerService_resource
        #add_RCSSchedulerService-vip_link_resource
        add_autorsync_resource
        add_autorsync-vip_link_resource
        make_readonly_resource ;;
    *)
        usage
    esac
elif [[ "$1" == "--remove" ]]
then
    case "$2" in
    alerts)
        make_readwrite_resource
        remove_alerts_resource
        make_readonly_resource
        add_alerts_service;;
    cms)
        make_readwrite_resource
        remove_cms_resource 
        remove_cms-alerts_link_resource
        make_readonly_resource
        add_cms_service ;;
    tomcat)
        make_readwrite_resource
        remove_tomcat_resource
        make_readonly_resource
        add_tomcat_service ;;
    xporttomcat)
        make_readwrite_resource
        remove_xporttomcat_resource
        make_readonly_resource
        add_xporttomcat_service ;;
    xportmanager)
        make_readwrite_resource
        remove_xportmanager_resource
        make_readonly_resource
        add_xportmanager_service ;;
    RCSSchedulerService)
        make_readwrite_resource
        remove_RCSSchedulerService_resource 
        make_readonly_resource
        add_RCSSchedulerService_service ;;
    autorsync)
        make_readwrite_resource
        remove_autorsync_resource
        make_readonly_resource ;;
    all)
        make_readwrite_resource
        remove_alerts_resource
        remove_cms_resource
        remove_tomcat_resource
        remove_xporttomcat_resource
        remove_xportmanager_resource
        remove_RCSSchedulerService_resource
        remove_autorsync_resource
        make_readonly_resource 
        add_alerts_service
        add_cms_service
        add_tomcat_service
        add_xporttomcat_service
        add_xportmanager_service
        add_RCSSchedulerService_service ;;
    *)
        usage
    esac
else
    usage
fi
