#!/bin/bash
#
HA_CURRENT_SYSTEM=$1
HA_ALT_SYSTEM=$2
SLEEPINT=$3
#rSync Array of run commands.
SYNCARRAY=( \
"rsync -vzaRpXog --delete -e ssh /opt/tandbergtv/ --exclude=cms/jboss/bin/ --exclude=cms/jboss/server/standard/data/tx-object-store --exclude=cms/jboss/server/standard/log --exclude=cms/jboss/server/standard/tmp --exclude=cms/jboss/server/standard/work --exclude=cms/log --exclude=cms/workflow/history --exclude=cms/workflow/mq  --exclude=cms/workflow/stats --exclude=tools/helix/Logs --exclude=watchpoint/log --exclude=xport/tomcat/logs --exclude=xport/tomcat/work root@$HA_ALT_SYSTEM:/"
"rsync -vzaRpXog --delete -e ssh /usr/local/acsserver/scripts/ root@$HA_ALT_SYSTEM:/" \
"rsync -vzaRpXog --delete -e ssh /usr/local/n2bb/alerts/conf/ root@$HA_ALT_SYSTEM:/" \
"rsync -vzaRpXog --delete -e ssh /usr/local/n2bb/conf/ root@$HA_ALT_SYSTEM:/" \
"rsync -vzaRpXog --delete -e ssh /usr/local/platform/backup/conf/cms/ root@$HA_ALT_SYSTEM:/" \
"rsync -vzaRpXog --delete -e ssh /usr/local/tstv/ --exclude=RCSScheduler/bin/log --exclude=RCSSnmpSubAgent/logs --exclude=EpgDownload/processed/log root@$HA_ALT_SYSTEM:/" \
)

VCSBIN="/opt/VRTSvcs/bin"
TEMPLOG="/tmp/autorsync.tmp"
LOGDATE=`date +"%Y%m%d"`
AUTORSYNCLOG="/opt/tandbergtv/cms/log/autorsync.$LOGDATE.log"
SERVICE="autorsync"

#Create log file
if [[ ! -d "$TEMPLOG" ]]; then
    touch $TEMPLOG
fi

if [[ -z $HA_CURRENT_SYSTEM || -z $HA_ALT_SYSTEM || -z $SLEEPINT ]]
then
    echo "Start via the autosync service"
else
    #Run Once Starting Message
    echo ""
    echo "################################################################" >> $AUTORSYNCLOG
    echo `date +"%Y-%m-%d %H:%M:%S %Z"` >> $AUTORSYNCLOG
    echo "STARTING: Syncing files from $HA_CURRENT_SYSTEM to $HA_ALT_SYSTEM" >> $AUTORSYNCLOG
    echo "################################################################" >> $AUTORSYNCLOG
    while :
    do
        #Abort if VCS is not running or if current system is offline
        if [[ -z `/etc/init.d/vcs status | grep running...` || -n `$VCSBIN/hastatus -sum | grep "B  " | grep $HA_CURRENT_SYSTEM | grep "OFFLINE" | grep CMSApp_Cluster` ]]
        then
            pid=$(ps axww | grep "rsyncloop.sh" | grep -v grep | sed -e 's/^\s*//' | cut -d' ' -f1 | head -n1)
            if [ ! -z "${pid}" ]
            then
                echo ""
                echo "################################################################" >> $AUTORSYNCLOG
                echo `date +"%Y-%m-%d %H:%M:%S %Z"` >> $AUTORSYNCLOG
                echo "STOPPING: rSync loop aborted because system in no longer primary" >> $AUTORSYNCLOG
                echo "################################################################" >> $AUTORSYNCLOG
                kill -9 $pid # PURE MASSACRE
            fi
        fi

        #Update Logname for new rsync loop if diffrent date.
        if [[ `date +"%Y%m%d"` != "$LOGDATE" ]]
        then
            LOGDATE=`date +"%Y%m%d"`
            AUTORSYNCLOG="/opt/tandbergtv/cms/log/autorsync.$LOGDATE.log"
        fi

        #If there is another active rsync process sleep
        if [[ -n `ps aux | grep "rsync " | grep -v grep` ]]
        then
            sleep $SLEEPINT
        #Else run the rsync process between the active to the standby systems.
        else
            for (( i = 0 ; i < ${#SYNCARRAY[@]} ; i++ )) do
            ${SYNCARRAY[$i]} > $TEMPLOG
            #If the log file is greater then 4 lines, cat it out into the log file.
            if [[ `cat $TEMPLOG | wc -l` -gt "4" ]]
            then
                echo "" >> $AUTORSYNCLOG
                echo "################################################################" >> $AUTORSYNCLOG
                echo `date +"%Y-%m-%d %H:%M:%S %Z"` >> $AUTORSYNCLOG
                echo "EVENT: Syncing files from $HA_CURRENT_SYSTEM to $HA_ALT_SYSTEM"  >> $AUTORSYNCLOG
                echo "RUNTIME COMMAND: ${SYNCARRAY[$i]}" >> $AUTORSYNCLOG
                echo "################################################################" >> $AUTORSYNCLOG
                cat $TEMPLOG >> $AUTORSYNCLOG
            fi
            done
        fi
    sleep $SLEEPINT
    done
fi
