#!/bin/bash
# VCS Status Check
VCSBIN="/opt/VRTSvcs/bin"
vip=`$VCSBIN/hares -value Virtual_IP Address`
CONSOLEOUT="%-50s"

default_dbservername() {
    DBSERVERNAME="dbcluster-scan"
}

default_dbinstance() {
    DBINSTANCE="ttv"
}

#Set Defaults
default_dbservername
default_dbinstance

while [[ $CORRECT != "y" ]]
do
    printf "$CONSOLEOUT" "Enter Database Servername/Host Alias [$DBSERVERNAME]"
    read DBSERVERNAME
    if [[ -z $DBSERVERNAME ]] ; then 
        default_dbservername
    fi

    printf "$CONSOLEOUT" "Enter Database Instance Name [$DBINSTANCE]"
    read DBINSTANCE
    if [[ -z $DBINSTANCE ]] ; then 
        default_dbinstance
    fi

    echo ""
    printf "$CONSOLEOUT $CONSOLEOUT\n" "Database Servername/Host Alias" $DBSERVERNAME
    printf "$CONSOLEOUT $CONSOLEOUT\n" "Database Instance Name" $DBINSTANCE
    echo ""
    printf "$CONSOLEOUT " "Is this correct? [y/n]"
    read CORRECT
done

check_cms() {
printf "\nWaiting for CMS Service to Start "
n=1
timeout=600
while [ $n -le "$timeout" ] ; do
    CURL_OUT=`curl -k -s --head --connect-timeout 1 https://$vip:8443/portal/ | head -n 1 | awk -F" " '{print $2}'`
    if [[ -z "$CURL_OUT" ]] ; then 
        if [[ $n -ge $timeout ]] ; then
            printf "\nFailed to Start RCSSchedulerService after $n Seconds. Verify that CMS Service is running correctly\n" 
            exit 1
        else
            printf "."
            sleep 1  
        fi
    else
        if [[ "$CURL_OUT" == "200" ]] ; then 
            printf "\nDone [Start Up Duration $n Seconds]\n"
            n=$timeout
        else
            printf "\nUnkown exit code\n"
            printf "`curl -k -s --head --connect-timeout 1 https://$vip:8443/portal/`"
            n=$timeout
        fi
    fi
    n=$(( $n +1 ))
done
}

# Wait for CMS to start
check_cms
# Update RCSSchedulerService DB Connection Strings
printf "\nUpdating RCSSchedulerService RAC Database Connection Strings...\n"
curl -k -X PUT -H "Accept: application/json" -H "Content-Type: application/json" -d '{"RecReqQueueSystem.ConnectionPool.serverName":"'$DBSERVERNAME'","RecReqQueueSystem.ConnectionPool.dbName":"'$DBINSTANCE'"}' -u services:'I@wanT$In!1234' http://$vip:8080/cms/services/settings/com.ericsson.cms.tstv.RcsReqQueueSystem
curl -k -X PUT -H "Accept: application/json" -H "Content-Type: application/json" -d '{"RcsSystem.ConnectionPool.serverName":"'$DBSERVERNAME'","RcsSystem.ConnectionPool.dbName":"'$DBINSTANCE'"}'                 -u services:'I@wanT$In!1234' http://$vip:8080/cms/services/settings/com.ericsson.cms.tstv.Snmp
curl -k -X PUT -H "Accept: application/json" -H "Content-Type: application/json" -d '{"EPG_FTP_HOST":"'$DBSERVERNAME'"}'                                                                                          -u services:'I@wanT$In!1234' http://$vip:8080/cms/services/settings/com.ericsson.cms.tstv.rcsweb
printf "\nUpdating EPG Management RAC Database Connection Strings...\n"
curl -k -X PUT -H "Accept: application/json" -H "Content-Type: application/json" -d '{"dbserver":"'$DBSERVERNAME'"}'                                                                                              -u services:'I@wanT$In!1234' http://$vip:8080/cms/services/settings/com.ericsson.cms.epgmgmt.configuration

# Adding RCSSchedulerService as an HA Resource
printf "\nAdding RCSSchedulerService as an HA Resource...\n"
bash /opt/tandbergtv/cms/scripts/veritas/create_resources.sh --add RCSSchedulerService
sleep 2

# Starting RCSSchedulerService Service
printf "\Starting RCSSchedulerService Service...\n"
service RCSSchedulerService start
