#/bin/bash
# VCS Status Check
VCSBIN="/opt/VRTSvcs/bin"

#Returns
# 0 = VCS Disabled          = NOT SHOWN
# 1 = VCS OK                = GREEN
# 2 = AutoFailOver Disabled
#        STOPPING, STARTING = YELLOW
# 3 = VCS FAULTED, PARTIAL
#         EXITED            = RED
# 4 = Unknown ERROR         = RED

#Check to see if the service is running
if [[ -n `/etc/init.d/vcs status | grep running...` ]]
    then
    if   [[ -n `$VCSBIN/hastatus -sum | grep "A  " | grep "FAULTED"` ]]
    then
       echo 3
    elif [[ -n `$VCSBIN/hastatus -sum | grep "A  " | grep "EXITED"` ]]
    then
       echo 3
    elif [[ -n `$VCSBIN/hagrp -display -attribute AutoFailOver | grep 0` ]]
        then
        if [[ -n `$VCSBIN/hagrp -display -attribute State | grep FAULTED` ]]
            then
            echo 3  # RED
        #Check to see if any system is PARTIAL state
        elif [[ -n `$VCSBIN/hagrp -display -attribute State | grep PARTIAL` ]]
            then
            echo 2  # YELLOW
        #Check to see if any system has EXITED state
        elif [[ -n `$VCSBIN/hastatus -sum | grep EXITED` ]]
            then
            echo 3  # RED
        #Check to see if any system is STOPPING state
        elif [[ -n `$VCSBIN/hagrp -display -attribute State | grep STOPPING` ]]
            then
            echo 2  # YELLOW
        #Check to see if any system is STARTING state
        elif [[ -n `$VCSBIN/hagrp -display -attribute State | grep STARTING` ]]
            then
            echo 2  # YELLOW
        elif [[ -n `$VCSBIN/hagrp -display -attribute State | grep OFFLINE` ]]
            then
            if [[ -n `$VCSBIN/hagrp -display -attribute State | grep ONLINE` ]]
            then
                echo 2  # YELLOW (Becuse it is not set up to fail over automaticly)
            else
                echo 4  # RED
            fi
        else
            echo 4  # RED
        fi
    #Check to see if AutoFailOver is Enabled
    elif [[ -n `$VCSBIN/hagrp -display -attribute AutoFailOver | grep 1` ]]
        then
        if [[ -n `$VCSBIN/hagrp -display -attribute State | grep FAULTED` ]]
            then
            echo 3  # RED
        #Check to see if any system is PARTIAL state
        elif [[ -n `$VCSBIN/hagrp -display -attribute State | grep PARTIAL` ]]
            then
            echo 1  # GREEN
        #Check to see if any system has EXITED state
        elif [[ -n `$VCSBIN/hastatus -sum | grep EXITED` ]]
            then
            echo 3  # RED
        #Check to see if any system is STOPPING state
        elif [[ -n `$VCSBIN/hagrp -display -attribute State | grep STOPPING` ]]
            then
            echo 2  # YELLOW
        #Check to see if any system is STARTING state
        elif [[ -n `$VCSBIN/hagrp -display -attribute State | grep STARTING` ]]
            then
            echo 2  # YELLOW
        elif [[ -n `$VCSBIN/hagrp -display -attribute State | grep OFFLINE` ]]
            then
            if [[ -n `$VCSBIN/hagrp -display -attribute State | grep ONLINE` ]]
            then
                echo 1  # GREEN
            else
                echo 4  # RED
            fi
        else
            echo 4  # RED
        fi
    else
        echo 4  # RED
    fi
else
    echo 0  # NOT SHOWN
fi