/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.specimpl.cl3_0;

import com.ericsson.metadatamanager.specimpl.cl3_0.CL3_0_Identifier;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.specimpl.SingleTitleSpecHandler;
import java.util.HashMap;
import java.util.Map;

public class CL3_0SpecHandler
extends SingleTitleSpecHandler {
    private static final String ADI_ROOTELEMENT_NAME = "ADI3";

    public CL3_0SpecHandler() {
        this.alias = "CL3_0";
        this.rootElementName = ADI_ROOTELEMENT_NAME;
    }

    public IIdentifier extractId(Asset asset) {
        CL3_0_Identifier id = new CL3_0_Identifier();
        id.setSearchService(this.getSearchService());
        id.setMappingResourceUrl(this.getMappingResourceUrl());
        Map<String, String> idXPaths = id.getTTVPaths();
        HashMap<String, String> idValues = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : idXPaths.entrySet()) {
            Field f = asset.getFirstField(entry.getValue());
            if (f == null) continue;
            idValues.put(entry.getKey(), f.getValue());
        }
        id.setSpecIdentifiers(idValues);
        return id;
    }

    public IdentifierBase getIdentifier() {
        CL3_0_Identifier identifier = new CL3_0_Identifier();
        identifier.setSearchService(this.searchService);
        identifier.setMappingResourceUrl(this.mappingResourceUrl);
        return identifier;
    }

    protected boolean isXPathPartOfSpec(String assetType, String ttvXPath) {
        boolean supperResult = super.isXPathPartOfSpec(assetType, ttvXPath);
        if (!supperResult && ttvXPath != null && ttvXPath.contains("tns:CustomField")) {
            return true;
        }
        return supperResult;
    }
}

