/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.specimpl.itv;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.util.MappingFileParser;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ITVIdentifier
extends IdentifierBase {
    private static final long serialVersionUID = -8112844616094249184L;
    private static String UID_XPATH = "itv/uid/id[@type='2']/@id";
    private static String MOVIE_UID_XPATH = "itv/uid/id[@type='3']/@id";
    private String uid;

    public String getUid() {
        return this.uid;
    }

    public Map<String, String> getSpecIdentifiers() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(UID_XPATH, this.uid);
        map.put(MOVIE_UID_XPATH, this.uid);
        return map;
    }

    public Map<String, String> getTTVPaths() {
        HashMap<String, String> ttvPaths = new HashMap<String, String>();
        String offerUriXpath = MappingFileParser.getMapping((URL)this.getMappingResourceUrl(), (String)UID_XPATH);
        if (offerUriXpath.trim().length() == 0) {
            throw new RuntimeException("Identifying field: " + UID_XPATH + " cannot be mapped to TTV xpath.");
        }
        ttvPaths.put(UID_XPATH, offerUriXpath);
        return ttvPaths;
    }

    public Map<String, String> getTTVPaths(Asset asset) {
        HashMap<String, String> ttvPaths = new HashMap<String, String>();
        String assetType = asset.getAssetType();
        if (assetType.equals(Group.GroupType.PACKAGE.name()) || assetType.equals(Item.ItemType.TITLE.name())) {
            String offerUriXpath = MappingFileParser.getMapping((URL)this.getMappingResourceUrl(), (String)UID_XPATH);
            if (offerUriXpath.trim().length() == 0) {
                throw new RuntimeException("Identifying field: " + UID_XPATH + " cannot be mapped to TTV xpath.");
            }
            ttvPaths.put(UID_XPATH, offerUriXpath);
        } else if (assetType.equals(Group.GroupType.MOVIE.name())) {
            String offerUriXpath = MappingFileParser.getMapping((URL)this.getMappingResourceUrl(), (String)MOVIE_UID_XPATH);
            if (offerUriXpath.trim().length() == 0) {
                throw new RuntimeException("Identifying field: " + MOVIE_UID_XPATH + " cannot be mapped to TTV xpath.");
            }
            ttvPaths.put(MOVIE_UID_XPATH, offerUriXpath);
        }
        return ttvPaths;
    }

    public boolean isValidIdentifier() {
        return this.uid != null && !this.uid.equals("");
    }

    public void setUid(String offerUri) {
        this.uid = offerUri;
    }

    public void setSpecIdentifiers(Map<String, String> identifiers) {
        if (identifiers.containsKey(UID_XPATH)) {
            this.setUid(identifiers.get(UID_XPATH));
        } else if (identifiers.containsKey(MOVIE_UID_XPATH)) {
            this.setUid(identifiers.get(MOVIE_UID_XPATH));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ITVIdentifier)) {
            return false;
        }
        ITVIdentifier another = (ITVIdentifier)((Object)o);
        return this.isEqual(this.uid, another.uid);
    }

    private boolean isEqual(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public int hashCode() {
        int h1 = this.uid != null ? this.uid.hashCode() : 0;
        return (h1 + 7) * 13;
    }

    public String toString() {
        return this.uid;
    }
}

