/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.specimpl.itv;

import com.ericsson.metadatamanager.specimpl.itv.ITVIdentifier;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.specimpl.SingleTitleSpecHandler;
import java.util.HashMap;
import java.util.Map;

public class ITVSpecHandler
extends SingleTitleSpecHandler {
    private static final String ITV_ROOTELEMENT_NAME = "itv";

    public ITVSpecHandler() {
        this.alias = "ITV";
        this.rootElementName = ITV_ROOTELEMENT_NAME;
    }

    public IIdentifier extractId(Asset asset) {
        String assetType = asset.getAssetType();
        ITVIdentifier id = new ITVIdentifier();
        id.setSearchService(this.getSearchService());
        id.setMappingResourceUrl(this.getMappingResourceUrl());
        Map<String, String> idXPaths = id.getTTVPaths(asset);
        HashMap<String, String> idValues = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : idXPaths.entrySet()) {
            Field f = asset.getFirstField(entry.getValue());
            if (f == null) continue;
            String value = f.getValue();
            if (assetType.equals(Item.ItemType.TITLE.name())) {
                value = "Title_" + value;
            }
            idValues.put(entry.getKey(), value);
        }
        id.setSpecIdentifiers(idValues);
        return id;
    }

    public IdentifierBase getIdentifier() {
        ITVIdentifier identifier = new ITVIdentifier();
        identifier.setSearchService(this.searchService);
        identifier.setMappingResourceUrl(this.mappingResourceUrl);
        return identifier;
    }

    protected boolean isXPathPartOfSpec(String assetType, String ttvXPath) {
        boolean supperResult = super.isXPathPartOfSpec(assetType, ttvXPath);
        if (!supperResult && ttvXPath != null && ttvXPath.contains("tns:CustomField")) {
            return true;
        }
        return supperResult;
    }

    protected boolean requireSpecSpecificMerging(String assetType) {
        if (assetType.equals(Group.GroupType.MOVIE.name())) {
            return true;
        }
        return super.requireSpecSpecificMerging(assetType);
    }

    protected void specSpecificMergingNoSave(Asset oldAsset, Relation newRelation, Asset targetAsset) {
        if (!targetAsset.getType().equals(Group.GroupType.MOVIE.name())) {
            super.specSpecificMergingNoSave(oldAsset, newRelation, targetAsset);
            return;
        }
        Asset oldTargetAsset = this.findAsset(targetAsset, oldAsset.getImmediateChildren());
        if (oldTargetAsset != null) {
            this.mergeRecursively(oldTargetAsset, targetAsset);
        } else {
            oldAsset.addChild(this.copyAssetTree(targetAsset));
        }
    }
}

