<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:vod30="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns" version="2.0">

	<xsl:import href="from/offer.xsl"/>
	<xsl:import href="from/title.xsl"/>
	<xsl:import href="from/poster.xsl"/>
	<xsl:import href="from/movie.xsl"/>
	<xsl:import href="from/boxcover.xsl"/>
	<xsl:import href="from/preview.xsl"/>
	<xsl:import href="from/barker.xsl"/>
	<xsl:import href="from/trick.xsl"/>
	<xsl:import href="from/encrypted.xsl"/>
		
	<xsl:output method="xml" indent="yes"/>
	
 	<xsl:variable name="Package" select="/tns:TTVSpec/tns:Group[@type = 'PACKAGE']"/>
	<xsl:variable name="PackageProviderId" select="$Package/tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id"/>
	<xsl:variable name="PackageAssetId" select="$Package/tns:Fields/tns:Identifier/tns:Id"/>
	<xsl:variable name="Title" select="/tns:TTVSpec/tns:Item[@type = 'TITLE']"/>
	<xsl:variable name="Movie" select="/tns:TTVSpec/tns:Group[@type = 'MOVIE']"/>
	<xsl:variable name="Preview" select="/tns:TTVSpec/tns:Group[@type = 'PREVIEW']"/>
	<xsl:variable name="Poster" select="/tns:TTVSpec/tns:Item[@type = 'POSTER']"/>
	<xsl:variable name="Boxcover" select="/tns:TTVSpec/tns:Item[@type = 'BOXCOVER']"/>
	<xsl:variable name="Barker" select="/tns:TTVSpec/tns:Item[@type = 'BARKER']"/>
	<xsl:variable name="Trick" select="/tns:TTVSpec/tns:Item[@type = 'TRICK']"/>
	<xsl:variable name="Encrypted" select="/tns:TTVSpec/tns:Item[@type = 'ENCRYPTED']"/>
	<xsl:variable name="TitleProviderId" select="$Title/tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id"/>
	<xsl:variable name="TitleAssetId" select="$Title/tns:Fields/tns:Identifier/tns:Id"/>
	<xsl:variable name="TermsUriId" select="concat($TitleProviderId, '/Terms/', $TitleAssetId )"/>
	<xsl:variable name="TitleUriId" select="concat($TitleProviderId, '/Title/', $TitleAssetId )"/>
	<xsl:variable name="ContentGroupUriId" select="concat($TitleProviderId, '/ContentGroup/', $TitleAssetId )"/>

	<xsl:variable name="TitleProviderVersionNum" select="$Title/tns:Fields/tns:Version/tns:Major"/>
	<xsl:variable name="TitleInternalVersionNum" select="$Title/tns:Fields/tns:Version/tns:Minor"/>
	
	<xsl:variable name="TitleCreationDateTime">
		<xsl:choose>
			<xsl:when test="string-length($Title/tns:Fields/tns:CreationInfo/tns:CreateDate) = 10">
				<xsl:value-of select="concat($Title/tns:Fields/tns:CreationInfo/tns:CreateDate,'T00:00:00Z')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$Title/tns:Fields/tns:CreationInfo/tns:CreateDate"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>	

	<xsl:template match="/">
		<ADI3 
			xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1"  
			xmlns:vod30="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
			xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
			xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
			xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
			xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
			xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1"  
			xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
			xsi:schemaLocation="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1 MD-SP-VODContainer-I01.xsd">
			
			<xsl:apply-templates select="tns:TTVSpec/tns:Group[@type = 'PACKAGE']" />
			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'TITLE']" />
			<xsl:apply-templates select="tns:TTVSpec/tns:Group[@type = 'MOVIE']" />
			<xsl:apply-templates select="tns:TTVSpec/tns:Group[@type = 'PREVIEW']" />
			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'POSTER']" />
			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'BOXCOVER']" />
			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'BARKER']" />
			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'TRICK']" />
			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'ENCRYPTED']" />

		</ADI3>
	</xsl:template>

</xsl:stylesheet>