<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:vod30="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	exclude-result-prefixes="tns"  version="2.0">

	<xsl:import href="from/common.xsl"/>

	<xsl:template match="tns:TTVSpec/tns:Group[@type = 'PACKAGE']">
		<Offer>
			<xsl:attribute name="uriId"><xsl:value-of select="concat( $PackageProviderId, '/Offer/', $PackageAssetId )"/></xsl:attribute>
			<xsl:call-template name="AMS_1" />
			<xsl:call-template name="AMS_2" />
			
			<xsl:for-each select="$Title/tns:Fields/tns:Category/tns:Text">
				<offer:Presentation>
					<offer:CategoryRef>
						<xsl:attribute name="uriId"><xsl:value-of select="concat( $PackageProviderId, '/Category/',. )"/></xsl:attribute>
					</offer:CategoryRef>
					<xsl:if test="$Title/tns:Fields/tns:Rights/tns:DisplayAsLastChance">
						<offer:DisplayAsNew>
							<xsl:value-of select="concat('P',$Title/tns:Fields/tns:Rights/tns:DisplayAsLastChance,'D')"/>
						</offer:DisplayAsNew>
					</xsl:if>
					<xsl:if test="$Title/tns:Fields/tns:Rights/tns:NewReleaseWindow">
						<offer:DisplayAsLastChance>
							<xsl:value-of select="concat('P',$Title/tns:Fields/tns:Rights/tns:NewReleaseWindow,'D')"/>
						</offer:DisplayAsLastChance>
					</xsl:if>
				</offer:Presentation>
			</xsl:for-each>

			<offer:PromotionalContentGroupRef uriId="{$ContentGroupUriId}"/>

			<xsl:for-each select="$Package/tns:Fields/tns:ProviderContentTier/tns:Value ">
				<offer:ProviderContentTier>
					<xsl:value-of select="."/>
				</offer:ProviderContentTier>
			</xsl:for-each>
			<!-- 
			<xsl:if test="$Package/tns:Fields/tns:MetadataSpecVersion">
				<offer:SourceMetadataSpecVersion deprecated="true">
					<xsl:value-of select="$Package/tns:Fields/tns:MetadataSpecVersion"/>
				</offer:SourceMetadataSpecVersion>
			</xsl:if>
 			-->

 			<offer:BillingId>
				<xsl:choose>
					<xsl:when test="$Title/tns:Fields/tns:BillingInfo/tns:Identifier/tns:Id">
						<xsl:value-of select="$Title/tns:Fields/tns:BillingInfo/tns:Identifier/tns:Id"/>
					</xsl:when>
					<xsl:otherwise>00000</xsl:otherwise>
				</xsl:choose>
			</offer:BillingId>

			<offer:TermsRef uriId="{$TermsUriId}"/>
			<offer:ContentGroupRef uriId="{$ContentGroupUriId}"/>
		</Offer>
	</xsl:template>

	<!-- Templates to convert trial use fields -->
	<xsl:template match="tns:Fields/tns:CustomFields/tns:CustomField[../../../@type='PACKAGE']">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$Package/tns:Fields/tns:ProductInfo/tns:Name"/></xsl:attribute>
			<xsl:attribute name="Name"><xsl:value-of select="@name"/></xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="@value"/></xsl:attribute>
		</App_Data>
	</xsl:template>

</xsl:stylesheet>