<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:tns="http://www.tandbergtv.com/TTVSchema" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" version="1.0">

	<xsl:output method="xml" indent="yes"/>
	
	<!-- assetPackage -->
	<xsl:template name="version">
		<xsl:element name="tns:Version">
			<xsl:element name="tns:Major">
				<xsl:value-of select="$itv/version/Version_Major"/>
			</xsl:element>
			<xsl:element name="tns:Minor">
				<xsl:value-of select="$itv/version/Version_Minor"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>

	<xsl:template name="provider">
		<xsl:if test="ProviderId or Provider">
			<xsl:element name="tns:ProviderInfo">
				<xsl:if test="ProviderId">
					<xsl:element name="tns:Identifier">
						<xsl:element name="tns:Id">
							<xsl:value-of select="ProviderId"/>
						</xsl:element>
					</xsl:element>
				</xsl:if>
				<xsl:if test="Provider">
					<xsl:element name="tns:Name">
						<xsl:value-of select="Provider"/>
					</xsl:element>
				</xsl:if>					
			</xsl:element>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="metadata" mode="package_provider">
		<xsl:call-template name="provider" />
	</xsl:template>
	
	<xsl:template name="FormatDate">

    	<xsl:param name="DateTime" />

	    <!-- old date format:2006-01-14 08:55:22
	    new date format 2006-01-14T08:55:22 -->
	    <xsl:variable name="date">
	      <xsl:value-of select="substring($DateTime,1,10)" />
	    </xsl:variable>
	    
	    <xsl:variable name="time">
	      <xsl:value-of select="substring($DateTime,12)" />
	    </xsl:variable>
	
	    <xsl:value-of select="$date"/>
	    <xsl:value-of select="'T'"/>
	    <xsl:value-of select="$time"/>
	</xsl:template>

	<xsl:template name="convert_time_from_minutes">
		
		<xsl:param name="time_in_minutes"/>

		<xsl:variable name="minutes" select="if (number($time_in_minutes) &lt; 1) then 0 else (number($time_in_minutes) mod 60)"/>
		<xsl:variable name="hours" select="if (number($time_in_minutes) &lt; 1) then 0 else ((number($time_in_minutes) - $minutes) div 60)"/>

		<xsl:element name="tns:Duration"> 
			<xsl:choose>
				<xsl:when test="$hours &lt; 10">
					<xsl:choose>
						<xsl:when test="$minutes &lt; 10">
							<xsl:value-of select="concat('0', $hours, ':0', $minutes, ':00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat('0', $hours, ':', $minutes, ':00')"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="$minutes &lt; 10">
							<xsl:value-of select="concat($hours, ':0', $minutes, ':00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat($hours, ':', $minutes, ':00')"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>

	</xsl:template>

	<xsl:template name="convert_duration_from_minutes">
		<xsl:param name="time_in_minutes"/>
		<xsl:variable name="minutes" select="if (number($time_in_minutes) &lt; 1) then 0 else (number($time_in_minutes) mod 60)"/>
		<xsl:variable name="hours" select="if (number($time_in_minutes) &lt; 1) then 0 else ((number($time_in_minutes) - $minutes) div 60)"/>

		<xsl:element name="tns:Duration">
	
			<xsl:element name="tns:Duration"> 
				<xsl:choose>
					<xsl:when test="$hours &lt; 10">
						<xsl:choose>
							<xsl:when test="$minutes &lt; 10">
								<xsl:value-of select="concat('0', $hours, ':0', $minutes, ':00')"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="concat('0', $hours, ':', $minutes, ':00')"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$minutes &lt; 10">
								<xsl:value-of select="concat($hours, ':0', $minutes, ':00')"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="concat($hours, ':', $minutes, ':00')"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>

			<xsl:element name="tns:DisplayDuration"> 
				<xsl:choose>
					<xsl:when test="$hours &lt; 10">
						<xsl:choose>
							<xsl:when test="$minutes &lt; 10">
								<xsl:value-of select="concat('0', $hours, ':0', $minutes)"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="concat('0', $hours, ':', $minutes)"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$minutes &lt; 10">
								<xsl:value-of select="concat($hours, ':0', $minutes)"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="concat($hours, ':', $minutes)"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</xsl:element>

	</xsl:template>

	<xsl:template name="movie_or_poster_metadata_from_package">
		<xsl:param name="packageId" />
		<xsl:param name="movie_or_poster_Id" />
		
		<xsl:element name="tns:Video">
			<xsl:element name="tns:HDContent">
				<xsl:if test="$itv/metadata[@id=$packageId]/HDContent = 'Yes'">true</xsl:if>
				<xsl:if test="$itv/metadata[@id=$packageId]/HDContent != 'Yes'">false</xsl:if>
			</xsl:element>
			<xsl:element name="tns:ScreenFormat">
				<xsl:value-of select="$itv/metadata[@id=$packageId]/ScreenFormat" />
			</xsl:element>
			<xsl:element name="tns:AspectRatio">
				<xsl:value-of select="$itv/metadata[@id=$movie_or_poster_Id]/ImageAspectRatio" />
			</xsl:element>
		</xsl:element>
		
	</xsl:template>

	<xsl:template match="metadata" mode="movie_or_poster_metadata_from_movie">

		<xsl:element name="tns:Identifier">
			<xsl:element name="tns:Id">
				<xsl:value-of select="@id"/>								
			</xsl:element>
		</xsl:element>

		<xsl:element name="tns:AssetName">
			<xsl:value-of select="@id"/>	
		</xsl:element>
				
		<xsl:element name="tns:Description">
			<xsl:element name="tns:Text">
				<xsl:value-of select="Description"/>
			</xsl:element>
		</xsl:element>

		<xsl:element name="tns:Content">
			<xsl:element name="tns:Checksum"><xsl:value-of select="ContentCheckSum" /></xsl:element>
			<xsl:element name="tns:Locator">
				<xsl:element name="tns:Uri"><xsl:value-of select="FileName" /></xsl:element>
				<xsl:element name="tns:Path"><xsl:value-of select="FilePath" />\<xsl:value-of select="FileName" /></xsl:element>
			</xsl:element>
		</xsl:element>

		<!-- Unmapped trial use fields -->
		<xsl:element name="tns:CustomFields">

			<xsl:element name="tns:CustomField">
				<xsl:attribute name="name">ReleaseDate</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:call-template name="FormatDate">
				          <xsl:with-param name="DateTime" select="ReleaseDate"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:element>

			<xsl:element name="tns:CustomField">
				<xsl:attribute name="name">UploadDate</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:call-template name="FormatDate">
				          <xsl:with-param name="DateTime" select="UploadDate"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:element>

			<xsl:element name="tns:CustomField">
				<xsl:attribute name="name">DeleteDate</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:call-template name="FormatDate">
				          <xsl:with-param name="DateTime" select="DeleteDate"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:element>

			<xsl:element name="tns:CustomField">
				<xsl:attribute name="name">HDMIOnly</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:if test="HDMIOnly = 'Yes'">true</xsl:if>
					<xsl:if test="HDMIOnly != 'Yes'">false</xsl:if>					
				</xsl:attribute>
			</xsl:element>

			<xsl:element name="tns:CustomField">
				<xsl:attribute name="name">MPEGFormat</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="MPEGFormat" />
				</xsl:attribute>
			</xsl:element>

			<xsl:element name="tns:CustomField">
				<xsl:attribute name="name">CRID</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="CRID" />
				</xsl:attribute>
			</xsl:element>

			<xsl:element name="tns:CustomField">
				<xsl:attribute name="name">ISAN</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="ISAN" />
				</xsl:attribute>
			</xsl:element>

			<xsl:element name="tns:CustomField">
				<xsl:attribute name="name">TribuneID</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="TribuneID" />
				</xsl:attribute>
			</xsl:element>

			<xsl:element name="tns:CustomField">
				<xsl:attribute name="name">Avail</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="Avail" />
				</xsl:attribute>
			</xsl:element>
			
			<xsl:element name="tns:CustomField">
				<xsl:attribute name="name">OriginalId</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="@id" />
				</xsl:attribute>
			</xsl:element>

		</xsl:element>
	</xsl:template>
	
	<xsl:template match="metadata" mode="movie_or_poster_metadata_from_title">

		<xsl:for-each select="Language">
			<xsl:element name="tns:Language">
				<xsl:attribute name="value">
					<xsl:value-of select="." />
				</xsl:attribute>
			</xsl:element>
		</xsl:for-each>
		<xsl:for-each select="SubtitleLanguage">
			<xsl:element name="tns:SubTitleLanguage">
				<xsl:attribute name="value">
					<xsl:value-of select="." />
				</xsl:attribute>
			</xsl:element>
		</xsl:for-each>
		<xsl:for-each select="DubbedLanguage">
			<xsl:element name="tns:DubbedLanguage">
				<xsl:attribute name="value">
					<xsl:value-of select="." />
				</xsl:attribute>
			</xsl:element>
		</xsl:for-each>

		<xsl:element name="tns:Audio">
			<xsl:element name="tns:Type">
				<xsl:value-of select="AudioType"/>
			</xsl:element>
		</xsl:element>
		
		<xsl:element name="tns:Encryption">
			<xsl:element name="tns:Value">
				<xsl:if test="Scrambled = 'Yes'">true</xsl:if>
				<xsl:if test="Scrambled != 'Yes'">false</xsl:if>
			</xsl:element>
		</xsl:element>
		<xsl:call-template name="provider"/>

	</xsl:template>

</xsl:stylesheet>
