<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:tns="http://www.tandbergtv.com/TTVSchema" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" version="1.0">

	<xsl:import href="to/common.xsl"/>
	<xsl:output method="xml" indent="yes"/>

	<xsl:template name="Movie">
		<xsl:param name="assetId" />
		<xsl:param name="packageId" />
		<xsl:param name="movieId" />

		<xsl:element name="tns:Group">
			<xsl:attribute name="type">MOVIE</xsl:attribute>
			<xsl:element name="tns:Fields">
				<xsl:element name="tns:TTVId">
					<xsl:element name="tns:Id">
						<xsl:value-of select="$assetId"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name="tns:AssetClass">movie</xsl:element>

				<xsl:call-template name="version" />
				<xsl:call-template name="movie_or_poster_metadata_from_package">
					<xsl:with-param name="packageId" select="$packageId" />
					<xsl:with-param name="movie_or_poster_Id" select="$movieId" />
				</xsl:call-template>

				<xsl:apply-templates select="$itv/metadata[@id=$packageId]" mode="movie_or_poster_metadata_from_title" />
				<xsl:apply-templates select="$itv/metadata[@id=$movieId]" mode="movie_or_poster_metadata_from_movie" />

			</xsl:element>
		</xsl:element>
	</xsl:template>

</xsl:stylesheet>