<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:tns="http://www.tandbergtv.com/TTVSchema" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" version="1.0">

	<xsl:import href="to/common.xsl"/>
	
	<xsl:output method="xml" indent="yes"/>
	
	<xsl:template name="Package">
		<xsl:param name="id" />

		<xsl:element name="tns:Group">
			<xsl:attribute name="type">PACKAGE</xsl:attribute>
			<xsl:element name="tns:Fields">
				<xsl:element name="tns:TTVId">
					<xsl:element name="tns:Id">
						<xsl:value-of select="-1"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name="tns:AssetClass">package</xsl:element>
				<xsl:element name="tns:Identifier">
					<xsl:element name="tns:Id">
						<xsl:value-of select="$id"/>								
					</xsl:element>
				</xsl:element>
				<xsl:element name="tns:AssetName">
					<xsl:value-of select="@id"/>	
				</xsl:element>

				<xsl:call-template name="version" />
				
				<xsl:element name="tns:CustomFields">
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">OriginalId</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:value-of select="@id" />
						</xsl:attribute>
					</xsl:element>
				</xsl:element>
			</xsl:element>
			
			<xsl:apply-templates select="$itv/metadata[@id=$id]" mode="package_provider" />
			
			<!-- Title Link -->
			<xsl:element name="tns:Relation">
				<xsl:attribute name="type">PARENT_CHILD</xsl:attribute>
				<xsl:element name="tns:Target">
					<xsl:element name="tns:Id">
						<xsl:value-of select="-2" />
					</xsl:element>
				</xsl:element>
			</xsl:element>

			<xsl:for-each select="//ContentClass">
				<xsl:variable name="movie_or_poster_Id" select="./../@id" />
				<xsl:variable name="assetId" select="(position()+2)*-1" />

				<xsl:if test=". = 'Movie' or . = 'Poster'">
					<xsl:element name="tns:Relation">
						<xsl:attribute name="type">PARENT_CHILD</xsl:attribute>
						<xsl:element name="tns:Target">
							<xsl:element name="tns:Id">
								<xsl:value-of select="$assetId" />
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:if>
			</xsl:for-each>
		</xsl:element>

	</xsl:template>

</xsl:stylesheet>
