<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:tns="http://www.tandbergtv.com/TTVSchema" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" version="1.0">

	<xsl:import href="to/common.xsl"/>
	<xsl:output method="xml" indent="yes"/>
	
	<!-- assetPackage -->
	<xsl:template match="metadata" mode="Title">

		<!-- Title Item -->
		<xsl:element name="tns:Item">
			<xsl:attribute name="type">TITLE</xsl:attribute>
			<xsl:element name="tns:Fields">
				<xsl:element name="tns:TTVId">
					<xsl:element name="tns:Id">
						<xsl:value-of select="-2"/>
					</xsl:element>
				</xsl:element>
				<xsl:element name="tns:AssetClass">title</xsl:element>
				<xsl:element name="tns:Identifier">
					<xsl:element name="tns:Id">
						<xsl:value-of select="concat('Title', '_', @id)"/>								
					</xsl:element>
				</xsl:element>
				<xsl:element name="tns:AssetName">
					<xsl:value-of select="concat('Title', '_', @id)"/>	
				</xsl:element>

				<xsl:if test="Title">
					<xsl:element name="tns:Title">
						<xsl:element name="tns:DisplayTitle">
							<xsl:element name="tns:Value">
								<xsl:value-of select="LongDescription"/>
							</xsl:element>
						</xsl:element>
						<xsl:element name="tns:ShortTitle">
							<xsl:element name="tns:Value">
								<xsl:value-of select="Title"/>
							</xsl:element>
						</xsl:element>	
						<xsl:element name="tns:SortTitle">
							<xsl:element name="tns:Value">
								<xsl:value-of select="TitleSortName"/>
							</xsl:element>
						</xsl:element>	
					</xsl:element>
				</xsl:if>

				<xsl:call-template name="version" />
				<xsl:element name="tns:Summary">
					<xsl:element name="tns:MediumSummary">
						<xsl:element name="tns:Value">
							<xsl:value-of select="SummaryMedium"/>
						</xsl:element>
					</xsl:element>
					<xsl:element name="tns:DisplaySummary">
						<xsl:element name="tns:Value">
							<xsl:value-of select="SummaryLong"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>
				
				<xsl:call-template name="provider"/>

				<xsl:element name="tns:Description">
					<xsl:element name="tns:Text">
						<xsl:value-of select="Description"/>
					</xsl:element>
				</xsl:element>

				<xsl:element name="tns:Rights">
					<xsl:element name="tns:LicensingWindowStart">
						<xsl:call-template name="FormatDate">
					          <xsl:with-param name="DateTime" select="ActivateTime"/>
					    </xsl:call-template>
					</xsl:element>
					<xsl:element name="tns:LicensingWindowEnd">
						<xsl:call-template name="FormatDate">
					          <xsl:with-param name="DateTime" select="DeactivateTime"/>
					    </xsl:call-template>
					</xsl:element>
					<xsl:element name="tns:PreviewPeriod">
						<xsl:call-template name="convert_time_from_minutes">
							<xsl:with-param name="time_in_minutes" select="PreviewPeriod" />
						</xsl:call-template>
					</xsl:element>
					<xsl:element name="tns:MaxViewingLimit">
						<xsl:value-of select="ViewingTime"/>
					</xsl:element>
				</xsl:element>

				<xsl:call-template name="convert_duration_from_minutes">
					<xsl:with-param name="time_in_minutes" select="Length" />
				</xsl:call-template>

				<xsl:for-each select="Genre">
					<xsl:element name="tns:Genre">
						<xsl:element name="tns:Value">
							<xsl:value-of select="."/>								
						</xsl:element>
					</xsl:element>
				</xsl:for-each>

				<xsl:element name="tns:Distributor">
					<xsl:element name="tns:Name">
						<xsl:value-of select="Distributor"/>
					</xsl:element>
				</xsl:element>

				<xsl:element name="tns:CreationInfo">
					<xsl:element name="tns:CreateDate">
						<xsl:call-template name="FormatDate">
					          <xsl:with-param name="DateTime" select="Publication_Date"/>
					    </xsl:call-template>
					</xsl:element>
					<xsl:element name="tns:PublicationDate">
						<xsl:value-of select="YearOfRelease"/>
					</xsl:element>
					<xsl:element name="tns:Studio">
						<xsl:element name="tns:Name">
							<xsl:value-of select="Studio"/>
						</xsl:element>
					</xsl:element>
					<xsl:element name="tns:Place">
						<xsl:element name="tns:Country">
							<xsl:value-of select="CountryOfOrigin"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>
				
				<xsl:element name="PropagationPriority">
					<xsl:value-of select="Priority"/>
				</xsl:element>
				
				<xsl:element name="tns:BillingInfo">
					<xsl:element name="tns:Identifier">
						<xsl:element name="tns:Id">
							<xsl:value-of select="BillingId"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>
				
				<xsl:for-each select="Actors">
					<xsl:element name="tns:Source">
						<xsl:element name="tns:Role">
							<xsl:element name="tns:Name">ACTOR</xsl:element>
						</xsl:element>
						<xsl:element name="tns:Contact">
							<xsl:element name="tns:DisplayName"><xsl:value-of select="."/></xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:for-each>

				<xsl:for-each select="Directors">
					<xsl:element name="tns:Source">
						<xsl:element name="tns:Role">
							<xsl:element name="tns:Name">DIRECTOR</xsl:element>
						</xsl:element>
						<xsl:element name="tns:Contact">
							<xsl:element name="tns:DisplayName"><xsl:value-of select="."/></xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:for-each>

				<xsl:element name="tns:Rating">
					<xsl:element name="tns:Value">
						<xsl:value-of select="Rating"/>								
					</xsl:element>
				</xsl:element>

			<xsl:element name="tns:Caption">
				<xsl:element name="tns:Value">
					<xsl:if test="ClosedCaption = 'Yes'">true</xsl:if>
					<xsl:if test="ClosedCaption != 'Yes'">false</xsl:if>					
				</xsl:element>
			</xsl:element>

				<!-- Unmapped trial use fields -->
				<xsl:element name="tns:CustomFields">

					<xsl:for-each select="UILocation">
						<xsl:element name="tns:CustomField">
							<xsl:attribute name="name">UILocation</xsl:attribute>
							<xsl:attribute name="value">
								<xsl:value-of select="." />
							</xsl:attribute>
						</xsl:element>
					</xsl:for-each>

					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">ApplicationActivateDate</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:call-template name="FormatDate">
						          <xsl:with-param name="DateTime" select="ApplicationActivateDate"/>
						    </xsl:call-template>
						</xsl:attribute>
					</xsl:element>
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">ApplicationDeactivateDate</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:call-template name="FormatDate">
						          <xsl:with-param name="DateTime" select="ApplicationDeactivateDate"/>
						    </xsl:call-template>
						</xsl:attribute>
					</xsl:element>
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">DeleteTime</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:call-template name="FormatDate">
						          <xsl:with-param name="DateTime" select="DeleteTime"/>
						    </xsl:call-template>
						</xsl:attribute>
					</xsl:element>
					<xsl:if test="ReportingClass">
						<xsl:element name="tns:CustomField">
							<xsl:attribute name="name">ReportingClass</xsl:attribute>
							<xsl:attribute name="value">
								<xsl:value-of select="ReportingClass" />
							</xsl:attribute>
						</xsl:element>
					</xsl:if>
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">AnalogCopy</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:value-of select="AnalogCopy" />
						</xsl:attribute>
					</xsl:element>
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">ProviderAssetId</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:value-of select="ProviderAssetId" />
						</xsl:attribute>
					</xsl:element>
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">BlockedHours</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:value-of select="BlockedHours" />
						</xsl:attribute>
					</xsl:element>
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">ServiceCode</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:value-of select="ServiceCode" />
						</xsl:attribute>
					</xsl:element>
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">LocationClass</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:value-of select="LocationClass" />
						</xsl:attribute>
					</xsl:element>
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">HDMIOnly</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:if test="HDMIOnly = 'Yes'">true</xsl:if>
							<xsl:if test="HDMIOnly != 'Yes'">false</xsl:if>					
						</xsl:attribute>
					</xsl:element>
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">VCRCommandsAllowed</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:if test="VCRCommandsAllowed = 'Yes'">true</xsl:if>
							<xsl:if test="VCRCommandsAllowed != 'Yes'">false</xsl:if>					
						</xsl:attribute>
					</xsl:element>
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">SignLanguage</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:if test="SignLanguage = 'Yes'">true</xsl:if>
							<xsl:if test="SignLanguage != 'Yes'">false</xsl:if>					
						</xsl:attribute>
					</xsl:element>
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">BillingName</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:value-of select="BillingName" />
						</xsl:attribute>
					</xsl:element>
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">RentalType</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:value-of select="RentalType" />
						</xsl:attribute>
					</xsl:element>
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">RentalTime</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:value-of select="RentalTime" />
						</xsl:attribute>
					</xsl:element>
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">CanBeSuspended</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:if test="CanBeSuspended = 'Yes'">true</xsl:if>
							<xsl:if test="CanBeSuspended != 'Yes'">false</xsl:if>
						</xsl:attribute>
					</xsl:element>
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">AudioDescription</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:if test="AudioDescription = 'Yes'">true</xsl:if>
							<xsl:if test="AudioDescription != 'Yes'">false</xsl:if>
						</xsl:attribute>
					</xsl:element>
					<xsl:if test="AdEnabled">
						<xsl:element name="tns:CustomField">
							<xsl:attribute name="name">AdEnabled</xsl:attribute>
							<xsl:attribute name="value">
								<xsl:if test="AdEnabled = 'Yes'">true</xsl:if>
								<xsl:if test="AdEnabled != 'Yes'">false</xsl:if>					
							</xsl:attribute>
						</xsl:element>
					</xsl:if>
					<xsl:if test="SplicingEnabled">
						<xsl:element name="tns:CustomField">
							<xsl:attribute name="name">SplicingEnabled</xsl:attribute>
							<xsl:attribute name="value">
								<xsl:if test="SplicingEnabled = 'Yes'">true</xsl:if>
								<xsl:if test="SplicingEnabled != 'Yes'">false</xsl:if>					
							</xsl:attribute>
						</xsl:element>
					</xsl:if>
					<xsl:element name="tns:CustomField">
						<xsl:attribute name="name">ViewingType</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:value-of select="ViewingType" />
						</xsl:attribute>
					</xsl:element>

					<xsl:if test="MovieType">
						<xsl:element name="tns:CustomField">
							<xsl:attribute name="name">MovieType</xsl:attribute>
							<xsl:attribute name="value">
								<xsl:value-of select="MovieType" />
							</xsl:attribute>
						</xsl:element>
					</xsl:if>

					<xsl:if test="AdProductCode">
						<xsl:element name="tns:CustomField">
							<xsl:attribute name="name">AdProductCode</xsl:attribute>
							<xsl:attribute name="value">
								<xsl:value-of select="AdProductCode" />
							</xsl:attribute>
						</xsl:element>
					</xsl:if>

					<xsl:if test="AdSpotId">
						<xsl:element name="tns:CustomField">
							<xsl:attribute name="name">AdSpotId</xsl:attribute>
							<xsl:attribute name="value">
								<xsl:value-of select="AdSpotId" />
							</xsl:attribute>
						</xsl:element>
					</xsl:if>

					<xsl:if test="AdSpotIdNamespace">
						<xsl:element name="tns:CustomField">
							<xsl:attribute name="name">AdSpotIdNamespace</xsl:attribute>
							<xsl:attribute name="value">
								<xsl:value-of select="AdSpotIdNamespace" />
							</xsl:attribute>
						</xsl:element>
					</xsl:if>
				</xsl:element>

			</xsl:element>
		</xsl:element>

	</xsl:template>

</xsl:stylesheet>
