<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:tns="http://www.tandbergtv.com/TTVSchema" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" version="1.0">

	<xsl:import href="to/package.xsl"/>
	<xsl:import href="to/title.xsl"/>
	<xsl:import href="to/movie.xsl"/>
	<xsl:import href="to/poster.xsl"/>
	
	<xsl:output method="xml" indent="yes"/>
	
	<xsl:variable name="itv" select="/itv"/>
	<xsl:variable name="version" select="$itv/version"/>
	<xsl:variable name="uid" select="$itv/uid"/>
	
	<xsl:template match="/itv">
		<xsl:element name="tns:TTVSpec">
			<xsl:for-each select="uid/id[@type = '2'] ">
				<xsl:variable name="idValue" select="@id"/>
				<xsl:if test="count($itv/component/id[@flag = '4' and @id = $idValue]) = 0">
					<xsl:call-template name="Package">
						<xsl:with-param name="id" select="$idValue"/>
					</xsl:call-template>
					<xsl:apply-templates select="$itv/metadata[@id=$idValue]" mode="Title" />

					<xsl:for-each select="//ContentClass">
						<xsl:variable name="movie_or_poster_Id" select="./../@id" />
						<xsl:variable name="assetId" select="(position()+2)*-1" />
						<xsl:if test=". = 'Movie'">
							<xsl:call-template name="Movie">
								<xsl:with-param name="assetId" select="$assetId" />
								<xsl:with-param name="packageId" select="$idValue"/>
								<xsl:with-param name="movieId" select="$movie_or_poster_Id"/>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test=". = 'Poster'">
							<xsl:call-template name="Poster">
								<xsl:with-param name="assetId" select="$assetId" />
								<xsl:with-param name="packageId" select="$idValue"/>
								<xsl:with-param name="posterId" select="$movie_or_poster_Id"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:for-each>

				</xsl:if> 				
			</xsl:for-each>

		</xsl:element>
	</xsl:template>

</xsl:stylesheet>
