/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.specimpl.osvod;

import com.ericsson.metadatamanager.specimpl.osvod.OpenStreamVODIdentifier;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListElementMetadata;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListManager;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.specimpl.SingleTitleSpecHandler;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OpenStreamVODSpecHandler
extends SingleTitleSpecHandler {
    private static final String DUMMY_ROOTELEMENT_NAME = "VOD";
    private static final String FIELDS_VOD_PLAYLIST_ID = "/Fields/VodPlaylistId";
    private static final String PROVIDER_ID_XPATH = "/Fields/ProviderInfo/Identifier/Id";
    private static final String ASSET_ID_XPATH = "/Fields/Identifier/Id";
    private static final String ASSETLIST_MANAGER_SERVICE = "cms/AssetListManager/local";

    public OpenStreamVODSpecHandler() {
        this.alias = "OpenStreamVOD";
        this.rootElementName = DUMMY_ROOTELEMENT_NAME;
    }

    public IIdentifier extractId(Asset asset) {
        OpenStreamVODIdentifier id = new OpenStreamVODIdentifier();
        id.setSearchService(this.getSearchService());
        id.setMappingResourceUrl(this.getMappingResourceUrl());
        Map<String, String> idXPaths = id.getTTVPaths();
        HashMap<String, String> idValues = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : idXPaths.entrySet()) {
            Field f = asset.getFirstField(entry.getValue());
            if (f == null) continue;
            idValues.put(entry.getKey(), f.getValue());
        }
        id.setSpecIdentifiers(idValues);
        return id;
    }

    public IdentifierBase getIdentifier() {
        OpenStreamVODIdentifier identifier = new OpenStreamVODIdentifier();
        identifier.setSearchService(this.searchService);
        identifier.setMappingResourceUrl(this.mappingResourceUrl);
        return identifier;
    }

    protected boolean isXPathPartOfSpec(String assetType, String ttvXPath) {
        boolean supperResult = super.isXPathPartOfSpec(assetType, ttvXPath);
        if (!supperResult && ttvXPath != null && ttvXPath.contains("CustomField")) {
            return true;
        }
        return supperResult;
    }

    public String getSpecDisplayName() {
        return "OpenStreamVOD";
    }

    public Document convertAssetToXMLDocument(Asset rootAsset) throws TranslationException {
        Document doc = super.convertAssetToXMLDocument(rootAsset);
        ArrayList<String> titleListIds = new ArrayList<String>();
        List assets = rootAsset.getAllAssets(false);
        for (Asset asset : assets) {
            Field field = asset.getFirstField(FIELDS_VOD_PLAYLIST_ID);
            if (field == null) continue;
            titleListIds.add(field.getValue());
        }
        ArrayList<AssetList> assetLists = new ArrayList<AssetList>();
        for (String idStr : titleListIds) {
            long id = 0L;
            try {
                id = Long.parseLong(idStr);
            }
            catch (NumberFormatException nfe) {
                continue;
            }
            assetLists.add(this.getAssetListManagerService().get(id));
        }
        XPathFactory xfactory = XPathFactory.newInstance();
        XPath xpath = xfactory.newXPath();
        NodeList segmentNodes = null;
        try {
            XPathExpression expr = xpath.compile("//ADI/Asset/Asset/Metadata/App_Data[@Name='Segment']");
            segmentNodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException se) {
            throw new TranslationException(se.getLocalizedMessage(), (Throwable)se);
        }
        for (int i = 0; i < segmentNodes.getLength(); ++i) {
            Node appDataNode = segmentNodes.item(i);
            String idStr = appDataNode.getAttributes().getNamedItem("Value").getTextContent();
            String appStr = appDataNode.getAttributes().getNamedItem("App").getTextContent();
            Node parent = appDataNode.getParentNode();
            parent.removeChild(appDataNode);
            long id = Long.parseLong(idStr);
            AssetList list = null;
            for (AssetList al : assetLists) {
                if (id != al.getId()) continue;
                list = al;
            }
            if (list == null) continue;
            int position = 1;
            List listAssets = list.getAssetsMap();
            for (AssetListAssetMap alam : listAssets) {
                AssetListElementMetadata contentRestricted;
                AssetListElementMetadata rollsRestricted;
                AssetListElementMetadata segmentName;
                AssetListElementMetadata displayRestricted;
                AssetListElementMetadata trickModeRestricted;
                AssetListElementMetadata usage;
                AssetListElementMetadata endNpt;
                Element newAppData = doc.createElement("App_Data");
                newAppData.setAttribute("App", appStr);
                newAppData.setAttribute("Name", "Segment");
                newAppData.setAttribute("Value", "Patience");
                parent.appendChild(newAppData);
                long assetId = alam.getAssetId();
                Asset asset = alam.getTitle().getAsset(assetId);
                String assetType = asset.getAssetType();
                ArrayList<String> assetTypeList = new ArrayList<String>();
                assetTypeList.add(assetType);
                List providerIdList = asset.getAllFieldsForXpath(assetTypeList, PROVIDER_ID_XPATH);
                String providerIdValue = "";
                if (providerIdList != null && providerIdList.size() != 0) {
                    providerIdValue = ((Field)providerIdList.get(0)).getValue();
                }
                List assetIdList = asset.getAllFieldsForXpath(assetTypeList, ASSET_ID_XPATH);
                String assetIdValue = "";
                if (assetIdList != null && assetIdList.size() != 0) {
                    assetIdValue = ((Field)assetIdList.get(0)).getValue();
                }
                Element segment = doc.createElement("segment");
                segment.setAttribute("segmentID", alam.getId() + "");
                segment.setAttribute("providerID", providerIdValue);
                segment.setAttribute("assetID", assetIdValue);
                segment.setAttribute("position", Integer.toString(position));
                ++position;
                AssetListElementMetadata startNpt = alam.getAssetListElementMetadata("startNPT");
                if (startNpt != null && startNpt.getIntegerValue() != null) {
                    segment.setAttribute("startNPT", startNpt.getIntegerValue() + "");
                }
                if ((endNpt = alam.getAssetListElementMetadata("endNPT")) != null && endNpt.getIntegerValue() != null) {
                    segment.setAttribute("endNPT", endNpt.getIntegerValue() + "");
                }
                if ((usage = alam.getAssetListElementMetadata("usage")) != null && usage.getStringValue() != null && !usage.getStringValue().equals("")) {
                    segment.setAttribute("usage", usage.getStringValue());
                }
                if ((trickModeRestricted = alam.getAssetListElementMetadata("trickModeRestricted")) != null && trickModeRestricted.getStringValue() != null && !trickModeRestricted.getStringValue().equals("")) {
                    segment.setAttribute("trickModeRestricted", trickModeRestricted.getStringValue());
                }
                if ((displayRestricted = alam.getAssetListElementMetadata("displayRestricted")) != null && displayRestricted.getStringValue() != null && !displayRestricted.getStringValue().equals("")) {
                    segment.setAttribute("displayRestricted", displayRestricted.getStringValue());
                }
                if ((segmentName = alam.getAssetListElementMetadata("segmentName")) != null && segmentName.getStringValue() != null && !segmentName.getStringValue().equals("")) {
                    segment.setAttribute("segmentName", segmentName.getStringValue());
                }
                if ((rollsRestricted = alam.getAssetListElementMetadata("rollsRestricted")) != null && rollsRestricted.getStringValue() != null && !rollsRestricted.getStringValue().equals("")) {
                    segment.setAttribute("rollsRestricted", rollsRestricted.getStringValue());
                }
                if ((contentRestricted = alam.getAssetListElementMetadata("contentRestricted")) != null && contentRestricted.getStringValue() != null && !contentRestricted.getStringValue().equals("")) {
                    segment.setAttribute("contentRestricted", contentRestricted.getStringValue());
                }
                StringWriter buffer = new StringWriter();
                try {
                    TransformerFactory transFactory = TransformerFactory.newInstance();
                    Transformer transformer = transFactory.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.transform(new DOMSource(segment), new StreamResult(buffer));
                }
                catch (TransformerConfigurationException se) {
                    throw new TranslationException(se.getLocalizedMessage(), (Throwable)se);
                }
                catch (TransformerException se) {
                    throw new TranslationException(se.getLocalizedMessage(), (Throwable)se);
                }
                String str = buffer.toString();
                newAppData.setAttribute("Value", str);
            }
        }
        return doc;
    }

    private IAssetListManager getAssetListManagerService() {
        IAssetListManager service = null;
        try {
            service = (IAssetListManager)InitialContext.doLookup(ASSETLIST_MANAGER_SERVICE);
        }
        catch (NamingException e) {
            String msg = "Failed to lookup the Asset List Manager service(cms/AssetListManager/local).";
            throw new RuntimeException(msg);
        }
        return service;
    }
}

