<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:fn="http://www.w3.org/2005/xpath-functions"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns fn">
<xsl:import href="from/common.xsl"/>

<xsl:template match="tns:TTVSpec/tns:Item[@type = 'BARKER']">
	<Asset>
		<Metadata>
			<AMS xsl:use-attribute-sets="AmsAttributeSet" >
				<xsl:attribute name="Asset_Class">
					<xsl:choose>
							<xsl:when test="fn:normalize-space(tns:Fields/tns:AssetClass) = ''">barker</xsl:when>
							<xsl:otherwise><xsl:value-of select="tns:Fields/tns:AssetClass" /></xsl:otherwise>
						</xsl:choose>
				</xsl:attribute>
			</AMS>
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
				<xsl:attribute name="Name">Type</xsl:attribute>
				<xsl:attribute name="Value">barker</xsl:attribute>
			</App_Data>
			<xsl:for-each select="tns:Fields/tns:Audio">
				<App_Data>
					<xsl:attribute name="App">
						<xsl:value-of select="../tns:ApplicationInfo/tns:Name" />
					</xsl:attribute>
					<xsl:attribute name="Name">Audio_Type</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Type" />
					</xsl:attribute>
				</App_Data>
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:Language">
				<App_Data>
					<xsl:attribute name="App">
						<xsl:value-of select="../tns:ApplicationInfo/tns:Name" />
					</xsl:attribute>
					<xsl:attribute name="Name">Languages</xsl:attribute>
					<xsl:attribute name="Value">
				    	<xsl:value-of select="@value" />
					</xsl:attribute>
				</App_Data>
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:SubTitleLanguage">
				<App_Data>
					<xsl:attribute name="App">
						<xsl:value-of select="../tns:ApplicationInfo/tns:Name" />
					</xsl:attribute>
					<xsl:attribute name="Name">Subtitle_Languages</xsl:attribute>
					<xsl:attribute name="Value">
				    	<xsl:value-of select="@value" />
					</xsl:attribute>
				</App_Data>
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:DubbedLanguage">
				<App_Data>
					<xsl:attribute name="App">
						<xsl:value-of select="../tns:ApplicationInfo/tns:Name" />
					</xsl:attribute>
					<xsl:attribute name="Name">Dubbed_Languages</xsl:attribute>
					<xsl:attribute name="Value">
				    	<xsl:value-of select="@value" />
					</xsl:attribute>
				</App_Data>
			</xsl:for-each>
			
			<!-- Frame Rate -->
			<xsl:if test="tns:Fields/tns:Content/tns:FrameRate">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Frame_Rate</xsl:attribute>
					<xsl:attribute name="Value"><xsl:value-of select="tns:Fields/tns:Content/tns:FrameRate" /></xsl:attribute>
				</App_Data>
			</xsl:if>

			<!-- Codec -->
			<xsl:if test="tns:Fields/tns:Content/tns:Codec">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentCodecAttribute" />
			</xsl:if>
			
			<!-- Resolution -->
			<xsl:if test="tns:Fields/tns:Content/tns:Resolution">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Resolution</xsl:attribute>
					<xsl:attribute name="Value"><xsl:value-of select="tns:Fields/tns:Content/tns:Resolution" /></xsl:attribute>
				</App_Data>
			</xsl:if>
			
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentFileSizeAttribute" />
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentChecksumAttribute" />
			<!--  Custom Field -->
			<xsl:apply-templates select="tns:Fields/tns:CustomFields"/>
			<xsl:apply-templates select="tns:Fields/tns:CustomFields-CL1_1"/>
		</Metadata>
		<Content xsl:use-attribute-sets="ContentAttributeSet" />
	</Asset>
</xsl:template>


</xsl:stylesheet>