<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	exclude-result-prefixes="tns fn xs">

<xsl:import href="from/common.xsl"/>

<xsl:template name="logicalclip">
<xsl:param name="app_name" />
<xsl:param name="clip_id" />

<xsl:for-each select ="/tns:TTVSpec/tns:Item[@type = 'LOGICALCLIP' and tns:Fields/tns:TTVId/tns:Id = $clip_id]">
<!-- Id should be unique, but let's do extra validation -->
<xsl:if test="position()=1">
	<App_Data>
		<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
		<xsl:attribute name="Name">NPT_Start</xsl:attribute>
		<xsl:attribute name="Value"><xsl:call-template name="timeInMilliseconds">
				<xsl:with-param name="timeValue"><xsl:value-of select="tns:Fields/tns:Mark/tns:In"/></xsl:with-param>
			</xsl:call-template></xsl:attribute>
	</App_Data>
	<App_Data>
		<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
		<xsl:attribute name="Name">NPT_End</xsl:attribute>
		<xsl:attribute name="Value"><xsl:call-template name="timeInMilliseconds">
				<xsl:with-param name="timeValue"><xsl:value-of select="tns:Fields/tns:Mark/tns:Out"/></xsl:with-param>
			</xsl:call-template></xsl:attribute>
	</App_Data>
</xsl:if>
</xsl:for-each>

</xsl:template>

<!-- Template to convert time value (HH:mm:ss) into milliseconds -->
<xsl:template name="timeInMilliseconds">
	<xsl:param name="timeValue" />
	<xsl:choose>
		<xsl:when test="not(string(substring-before($timeValue, ':')) castable as xs:integer)
							or not(string(substring-before(substring-after($timeValue, ':'), ':')) castable as xs:integer)
							or not(string(substring-after(substring-after($timeValue, ':'), ':')) castable as xs:integer)">
			<xsl:value-of select="$timeValue"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="format-number(1000 * (number(substring-before($timeValue, ':')) * 3600 
				+ number(substring-before(substring-after($timeValue, ':'), ':')) * 60
				+ number(substring-after(substring-after($timeValue, ':'), ':'))), 0) "/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
</xsl:stylesheet>
