<?xml version="1.0" encoding="UTF-8"?>
	<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns fn">

<!--
	Fields for MOVIE asset that must be copied over to the ENCRYPTED asset as well.
 -->

<!-- Imports -->
<xsl:import href="from/common.xsl"/>
<xsl:import href="from/movie_preview_common.xsl"/>

<!-- 
	Template 'movie_common': Translates common metadata for the selected movie asset that is also 
		copied over to an encrypted asset created from the movie asset. 
-->
<xsl:template name="movie_common">
<xsl:param name="app_name" />
<xsl:param name="asset" />

	<!-- Common metadata between movie / preview assets that must be copied to encrypted asset -->
	<xsl:call-template name="movie_preview_common">
		<xsl:with-param name="app_name" select="$app_name" />
		<xsl:with-param name="asset" select="$asset" />
	</xsl:call-template>

	<!-- Encryption -->
	<xsl:if test="$asset/tns:Fields/tns:Encryption/tns:Value">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Encryption</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:choose>
					<xsl:when test="fn:lower-case($asset/tns:Fields/tns:Encryption/tns:Value) = 'true'">Y</xsl:when>
					<xsl:otherwise>N</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Encryption Mode indicator -->	
	<xsl:if test="$asset/tns:Fields/tns:Copyright/tns:EncryptionModeIndicator">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Encryption_Mode_Indicator</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:value-of select="$asset/tns:Fields/tns:Copyright/tns:EncryptionModeIndicator" />
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Copy Protection -->
	<xsl:if test="$asset/tns:Fields/tns:Copyright/tns:CopyProtection">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Copy_Protection</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:choose>
					<xsl:when test="fn:lower-case($asset/tns:Fields/tns:Copyright/tns:CopyProtection) = 'true'">Y</xsl:when>
					<xsl:otherwise>N</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	
	<!-- Copy Protection Verbose -->
	<xsl:if test="$asset/tns:Fields/tns:Copyright/tns:CopyProtectionVerbose">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Copy_Protection_Verbose</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:choose>
					<xsl:when test="fn:lower-case($asset/tns:Fields/tns:Copyright/tns:CopyProtectionVerbose) = 'true'">Y</xsl:when>
					<xsl:otherwise>N</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	
	<!-- Analog Protection System -->
	<xsl:if test="$asset/tns:Fields/tns:Copyright/tns:AnalogProtectionSystem">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Analog_Protection_System</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:value-of select="$asset/tns:Fields/tns:Copyright/tns:AnalogProtectionSystem" />
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Constrained Image Trigger -->
	<xsl:if test="$asset/tns:Fields/tns:Copyright/tns:ConstrainedImageTrigger">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Constrained_Image_Trigger</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:value-of select="$asset/tns:Fields/tns:Copyright/tns:ConstrainedImageTrigger" />
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	
	<!-- CGMS A -->
	<xsl:if test="$asset/tns:Fields/tns:Copyright/tns:CGMSA">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">CGMS_A</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:value-of select="$asset/tns:Fields/tns:Copyright/tns:CGMSA" />
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	
	<!-- View Can be Resumed -->
	<xsl:if test="$asset/tns:Fields/tns:Rights/tns:ViewingCanBeResumed">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Viewing_Can_Be_Resumed</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:choose>
					<xsl:when test="fn:lower-case($asset/tns:Fields/tns:Rights/tns:ViewingCanBeResumed) = 'true'">Y</xsl:when>
					<xsl:otherwise>N</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</App_Data>
	</xsl:if>
</xsl:template>
</xsl:stylesheet>
