<?xml version="1.0" encoding="UTF-8"?>
	<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns fn">

<!--
	Common fields for MOVIE and PREVIEW assets that must be copied over to the ENCRYPTED asset as well.
 -->

<!-- Imports -->
<xsl:import href="from/common.xsl"/>


<!-- 
	Template 'movie_preview_common': Translates metadata for the selected movie / preview asset 
		that is also copied over to an encrypted asset created from the movie / preview asset. 
-->
<xsl:template name="movie_preview_common">
<xsl:param name="app_name" />
<xsl:param name="asset" />

	<!-- Audio Type -->
	<xsl:for-each select="$asset/tns:Fields/tns:Audio">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Audio_Type</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="tns:Type" /></xsl:attribute>
		</App_Data>
	</xsl:for-each>

	<!-- Screen Format -->
	<xsl:if test="$asset/tns:Fields/tns:Video/tns:ScreenFormat">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Screen_Format</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="$asset/tns:Fields/tns:Video/tns:ScreenFormat" /></xsl:attribute>
		</App_Data>
	</xsl:if>
	
	<!-- Language -->
	<xsl:for-each select="$asset/tns:Fields/tns:Language">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Languages</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="@value" /></xsl:attribute>
		</App_Data>
	</xsl:for-each>
	<xsl:for-each select="$asset/tns:Fields/tns:SubTitleLanguage">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Subtitle_Languages</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="@value" /></xsl:attribute>
		</App_Data>
	</xsl:for-each>
	<xsl:for-each select="$asset/tns:Fields/tns:DubbedLanguage">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Dubbed_Languages</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="@value" /></xsl:attribute>
		</App_Data>
	</xsl:for-each>
	
	<!-- Trick Modes Restricted -->
	<xsl:for-each select="$asset/tns:Fields/tns:Video/tns:TrickModesRestricted">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">trickModesRestricted</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="." /></xsl:attribute>
		</App_Data>
	</xsl:for-each>

	<!-- Avail -->
	<xsl:for-each select="$asset/tns:Fields/tns:Avail">
		<xsl:if test="tns:TimeCodeOne or
					  tns:TimeCodeTwo or
					  tns:TimeCodeThree or
					  tns:TimeCodeFour or
					  tns:Id or
					  tns:Scope or
					  tns:Type or
					  tns:Position">
			<App_Data>
				<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
				<xsl:attribute name="Name">Avail</xsl:attribute>
				<xsl:attribute name="Value">
					<xsl:choose>
						<xsl:when test="tns:TimeCodeOne">
							<xsl:value-of select="tns:TimeCodeOne" />
						</xsl:when>
						<xsl:otherwise>00:00:00:00</xsl:otherwise>
					</xsl:choose>,<xsl:choose>
						<xsl:when test="tns:TimeCodeTwo">
							<xsl:value-of select="tns:TimeCodeTwo" />
						</xsl:when>
						<xsl:otherwise>00:00:00:00</xsl:otherwise>
					</xsl:choose>,<xsl:choose>
						<xsl:when test="tns:TimeCodeThree">
							<xsl:value-of select="tns:TimeCodeThree" />
						</xsl:when>
						<xsl:otherwise>00:00:00:00</xsl:otherwise>
					</xsl:choose>,<xsl:choose>
						<xsl:when test="tns:TimeCodeFour">
							<xsl:value-of select="tns:TimeCodeFour" />
						</xsl:when>
						<xsl:otherwise>00:00:00:00</xsl:otherwise>
					</xsl:choose>,<xsl:if test="tns:Id">
						<xsl:value-of select="tns:Id" /></xsl:if>,<xsl:value-of select="tns:Scope" />
				</xsl:attribute>
			</App_Data>
		</xsl:if>
	</xsl:for-each>

	<!-- Rolls Restricted -->
	<xsl:if test="$asset/tns:Fields/tns:Restriction/tns:Roll">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Rolls_Restricted</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="$asset/tns:Fields/tns:Restriction/tns:Roll" /></xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Content Restricted -->
	<xsl:if test="$asset/tns:Fields/tns:Restriction/tns:Content">
		<App_Data>
			<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
			<xsl:attribute name="Name">Content_Restricted</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="$asset/tns:Fields/tns:Restriction/tns:Content" /></xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Source Asset ID -->
	<xsl:if test="$asset/tns:Fields/tns:Derived/tns:SourceAssetId">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Source_Asset_ID</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="$asset/tns:Fields/tns:Derived/tns:SourceAssetId" /></xsl:attribute>
		</App_Data>
	</xsl:if>

	<!-- Source Provider ID -->
	<xsl:if test="$asset/tns:Fields/tns:Derived/tns:SourceProviderId">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Source_Provider_ID</xsl:attribute>
			<xsl:attribute name="Value"><xsl:value-of select="$asset/tns:Fields/tns:Derived/tns:SourceProviderId" /></xsl:attribute>
		</App_Data>
	</xsl:if>
</xsl:template>
</xsl:stylesheet>
