<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns fn">

<!-- Imports -->
<xsl:import href="from/common.xsl"/>
<xsl:import href="from/movie_common.xsl"/>
<xsl:import href="from/preview_common.xsl"/>


<xsl:template match="tns:TTVSpec/tns:Item[@type = 'ENCRYPTED']">
	<Asset>
		<Metadata>
			<AMS xsl:use-attribute-sets="AmsAttributeSet" >
				<xsl:attribute name="Asset_Class">encrypted</xsl:attribute>
			</AMS>

			<!-- Asset_Encrypted -->
			<xsl:if test="tns:Fields/tns:Encryption/tns:Asset/tns:Identifier/tns:Id">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet" >
					<xsl:attribute name="Name">Asset_Encrypted</xsl:attribute>
					<xsl:attribute name="Value">
						<xsl:value-of select="tns:Fields/tns:Encryption/tns:Asset/tns:Identifier/tns:Id" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>

			<!-- Vendor Name -->
			<xsl:if test="tns:Fields/tns:Vendor/tns:Name">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet" >
					<xsl:attribute name="Name">Vendor_Name</xsl:attribute>
					<xsl:attribute name="Value"><xsl:value-of select="tns:Fields/tns:Vendor/tns:Name" /></xsl:attribute>
				</App_Data>
			</xsl:if>

			<!-- Receiver Type -->			
			<xsl:if test="tns:Fields/tns:Receiver/tns:Type">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Receiver_Type</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Receiver/tns:Type" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>

			<!-- Receiver Version -->			
			<xsl:if test="tns:Fields/tns:Receiver/tns:Version/tns:Value">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Receiver_Version</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="fn:floor(tns:Fields/tns:Receiver/tns:Version/tns:Value)" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>

			<!--  Encryption Type -->
			<xsl:if test="tns:Fields/tns:Encryption/tns:Type">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encryption_Type</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:Type" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>

			<!--  Encryption Algorithm -->
			<xsl:if test="tns:Fields/tns:Encryption/tns:Algorithm">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encryption_Algorithm</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:Algorithm" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>

			<!--  Encryption Date -->
			<xsl:if test="tns:Fields/tns:Encryption/tns:Date">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encryption_Date</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:Date" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>

			<!--  Encryption Time -->
			<xsl:if test="tns:Fields/tns:Encryption/tns:Time">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encryption_Time</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:Time" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>

			<!--  Encryption System Info -->
			<xsl:if test="tns:Fields/tns:Encryption/tns:SystemInfo">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encrypting_System_Info</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:SystemInfo" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>

			<!--  Encryption Key Block -->
			<xsl:if test="tns:Fields/tns:Encryption/tns:KeyBlock">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Encryption_Key_Block</xsl:attribute>
					<xsl:attribute name="Value">
					    <xsl:value-of select="tns:Fields/tns:Encryption/tns:KeyBlock" />
					</xsl:attribute>
				</App_Data>
			</xsl:if>

			<!-- Metadata repeated for Movie / Preview / Encrypted assets -->
			<xsl:call-template name="movie_preview_encrypted_common">
				<xsl:with-param name="app_name" select="tns:Fields/tns:ApplicationInfo/tns:Name" />
				<xsl:with-param name="asset" select="." />
			</xsl:call-template>

			<!-- Copy over fields from the asset that is encrypted (if the asset is a movie or preview) -->
			<xsl:if test="fn:string-length(fn:normalize-space(tns:Fields/tns:Encryption/tns:Asset/tns:Identifier/tns:Id)) > 0">
				<xsl:variable name="sourceAssetId" select="tns:Fields/tns:Encryption/tns:Asset/tns:Identifier/tns:Id" />
				<!-- Find the referenced asset -->
				<xsl:for-each select="/tns:TTVSpec/*[(fn:local-name() = 'Group' or fn:local-name() = 'Item') and tns:Fields/tns:Identifier/tns:Id = $sourceAssetId][1]">
					<xsl:variable name="sourceAssetType" select="@type" />
					<xsl:variable name="sourceAppName" select="tns:Fields/tns:ApplicationInfo/tns:Name" />
					<xsl:choose>
						<xsl:when test="$sourceAssetType = 'MOVIE'">
							<xsl:call-template name="movie_common">
								<xsl:with-param name="app_name" select="$sourceAppName" />
								<xsl:with-param name="asset" select="." />
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$sourceAssetType = 'PREVIEW'">
							<xsl:call-template name="preview_common">
								<xsl:with-param name="app_name" select="$sourceAppName" />
								<xsl:with-param name="asset" select="." />
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
			</xsl:if>

			<!--  Custom Field -->
			<xsl:apply-templates select="tns:Fields/tns:CustomFields"/>
			<xsl:apply-templates select="tns:Fields/tns:CustomFields-CL1_1"/>
		</Metadata>
		<Content xsl:use-attribute-sets="ContentAttributeSet" />
	</Asset>
</xsl:template>


</xsl:stylesheet>