<?xml version="1.0" encoding="UTF-8"?>
	<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns fn">

<!-- Imports -->
<xsl:import href="from/common.xsl"/>

<xsl:template name="previewsegmentgroups" >
	<xsl:for-each select="/tns:TTVSpec/tns:Item[@type = 'PREVIEWSEGMENTGROUP']">
	
	<xsl:variable name="app_name" select="tns:Fields/tns:ApplicationInfo/tns:Name" />
	
	<Asset>
		<Metadata>
			<AMS xsl:use-attribute-sets="AmsAttributeSet" >
				<xsl:attribute name="Asset_Class">preview segment group</xsl:attribute>
			</AMS>
			
			<!-- Type -->
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
				<xsl:attribute name="Name">Type</xsl:attribute>
				<xsl:attribute name="Value">preview segment group</xsl:attribute>
			</App_Data>

			<!-- SGU -->
			<xsl:if test="tns:Fields/tns:SegmentGroupUsage">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Segment_Group_Usage</xsl:attribute>
					<xsl:attribute name="Value"><xsl:value-of select="tns:Fields/tns:SegmentGroupUsage" /></xsl:attribute>
				</App_Data>
			</xsl:if>

			<!-- Segment -->
			<xsl:if test="tns:Fields/tns:VodPlaylistId">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
					<xsl:attribute name="Name">Segment</xsl:attribute>
					<xsl:attribute name="Value"><xsl:value-of select="tns:Fields/tns:VodPlaylistId" /></xsl:attribute>
				</App_Data>
			</xsl:if>

			<xsl:for-each select="tns:Fields/tns:EquipCapabilityProfile">
				<App_Data>
					<xsl:attribute name="App"><xsl:value-of select="$app_name" /></xsl:attribute>
					<xsl:attribute name="Name">Equip_Capability_Profile</xsl:attribute>
					<xsl:attribute name="Value"><xsl:value-of select="." /></xsl:attribute>
				</App_Data>
			</xsl:for-each>

			<!--  Custom Field -->
			<xsl:apply-templates select="tns:Fields/tns:CustomFields"/>
			<xsl:apply-templates select="tns:Fields/tns:CustomFields-CL1_1"/>
		</Metadata>
	</Asset>
	
</xsl:for-each>
</xsl:template>

</xsl:stylesheet>
