/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.tar.n2;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.tools.tar.n2.TarBuffer;
import org.apache.tools.tar.n2.TarEntry;
import org.apache.tools.tar.n2.TarUtils;

public class TarInputStream
extends FilterInputStream {
    private static final int SMALL_BUFFER_SIZE = 256;
    private static final int BUFFER_SIZE = 8192;
    private static final int LARGE_BUFFER_SIZE = 32768;
    private static final int BYTE_MASK = 255;
    private static final Logger log = Logger.getLogger(TarInputStream.class);
    protected boolean debug;
    protected boolean hasHitEOF;
    protected boolean fastScan = true;
    protected long entrySize;
    protected long entryOffset;
    protected byte[] readBuf;
    protected int readBufLen = 0;
    protected TarBuffer buffer;
    protected TarEntry currEntry;
    protected byte[] oneBuf;

    public TarInputStream(InputStream is) {
        this(is, 10240, 512);
    }

    public TarInputStream(InputStream is, int blockSize) {
        this(is, blockSize, 512);
    }

    public TarInputStream(InputStream is, int blockSize, int recordSize) {
        super(is);
        this.buffer = new TarBuffer(is, blockSize, recordSize);
        this.readBuf = null;
        this.readBufLen = 0;
        this.oneBuf = new byte[1];
        this.debug = false;
        this.hasHitEOF = false;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        TarUtils.setDebug(debug);
        TarBuffer.setDebug(debug);
        TarEntry.setDebug(debug);
    }

    public void setFastScan(boolean mode) {
        this.fastScan = mode;
    }

    public void close() throws IOException {
        this.buffer.close();
    }

    public int getRecordSize() {
        return this.buffer.getRecordSize();
    }

    public int available() throws IOException {
        if (this.entrySize - this.entryOffset > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)(this.entrySize - this.entryOffset);
    }

    public long skip(long numToSkip) throws IOException {
        int realSkip;
        long skip;
        int numRead;
        if (this.fastScan) {
            return this.leap(numToSkip);
        }
        byte[] skipBuf = new byte[8192];
        for (skip = numToSkip; skip > 0L && (numRead = this.read(skipBuf, 0, realSkip = (int)(skip > (long)skipBuf.length ? (long)skipBuf.length : skip))) != -1; skip -= (long)numRead) {
        }
        return numToSkip - skip;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int markLimit) {
    }

    public void reset() {
    }

    private String odbc(byte[] b) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < b.length; i += 16) {
            result.append(String.format("%010o:", i));
            for (int j = 0; j < 16 && i + j < b.length; ++j) {
                byte v = b[i + j];
                if (v >= 32 && v < 128) {
                    result.append(String.format("   %c", v));
                    continue;
                }
                result.append(String.format("\\%03d", v));
            }
            result.append("\n");
        }
        return result.toString().replaceFirst("\\n$", "");
    }

    public TarEntry getNextEntry() throws IOException {
        byte[] headerBuf;
        if (this.hasHitEOF) {
            return null;
        }
        if (this.currEntry != null) {
            long numToSkip = this.entrySize - this.entryOffset;
            this.debug("TarInputStream: SKIP currENTRY '" + this.currEntry.getName() + "' SZ " + this.entrySize + " OFF " + this.entryOffset + "  skipping " + numToSkip + " bytes");
            if (numToSkip > 0L) {
                this.skip(numToSkip);
            }
            this.readBuf = new byte[this.buffer.getRecordSize()];
            this.readBufLen = 0;
        }
        if ((headerBuf = this.buffer.readRecord()) == null) {
            this.debug("READ NULL RECORD");
            this.hasHitEOF = true;
        } else if (this.buffer.isEOFRecord(headerBuf)) {
            this.debug("READ EOF RECORD");
            this.hasHitEOF = true;
        }
        if (this.hasHitEOF) {
            this.currEntry = null;
        } else {
            this.currEntry = new TarEntry(headerBuf);
            this.debug("TarInputStream: SET CURRENTRY '" + this.currEntry.getName() + "' size = " + this.currEntry.getSize());
            this.entryOffset = 0L;
            this.entrySize = this.currEntry.getSize();
        }
        if (this.currEntry != null && this.currEntry.isGNULongNameEntry()) {
            StringBuffer longName = new StringBuffer();
            byte[] buf = new byte[256];
            int length = 0;
            while ((length = this.read(buf)) >= 0) {
                longName.append(new String(buf, 0, length));
            }
            this.getNextEntry();
            if (this.currEntry == null) {
                return null;
            }
            if (longName.length() > 0 && longName.charAt(longName.length() - 1) == '\u0000') {
                longName.deleteCharAt(longName.length() - 1);
            }
            this.currEntry.setName(longName.toString());
        }
        return this.currEntry;
    }

    public int read() throws IOException {
        int num = this.read(this.oneBuf, 0, 1);
        return num == -1 ? -1 : this.oneBuf[0] & 0xFF;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int numToRead) throws IOException {
        if (this.fastScan) {
            return this.fastread(buf, offset, numToRead);
        }
        int totalRead = 0;
        if (this.entryOffset >= this.entrySize) {
            return -1;
        }
        if ((long)numToRead + this.entryOffset > this.entrySize) {
            numToRead = (int)(this.entrySize - this.entryOffset);
        }
        if (this.readBuf != null) {
            int sz = numToRead > this.readBufLen ? this.readBufLen : numToRead;
            System.arraycopy(this.readBuf, 0, buf, offset, sz);
            if (sz >= this.readBuf.length) {
                this.readBuf = null;
                this.readBufLen = 0;
            } else {
                int newLen = this.readBuf.length - sz;
                byte[] newBuf = new byte[newLen];
                System.arraycopy(this.readBuf, sz, newBuf, 0, newLen);
                this.readBuf = newBuf;
                this.readBufLen = newLen;
            }
            totalRead += sz;
            numToRead -= sz;
            offset += sz;
        }
        while (numToRead > 0) {
            byte[] rec = this.buffer.readRecord();
            if (rec == null) {
                throw new IOException("unexpected EOF with " + numToRead + " bytes unread");
            }
            int recLen = rec.length;
            int sz = numToRead;
            if (recLen > sz) {
                System.arraycopy(rec, 0, buf, offset, sz);
                this.readBuf = new byte[recLen - sz];
                this.readBufLen = recLen - sz;
                System.arraycopy(rec, sz, this.readBuf, 0, recLen - sz);
            } else {
                sz = recLen;
                System.arraycopy(rec, 0, buf, offset, recLen);
            }
            totalRead += sz;
            numToRead -= sz;
            offset += sz;
        }
        this.entryOffset += (long)totalRead;
        return totalRead;
    }

    private void shift(byte[] array, int incr) {
        block3: {
            block4: {
                int l;
                block2: {
                    l = array.length;
                    if (incr < l && -incr < l) break block2;
                    Arrays.fill(array, (byte)0);
                    break block3;
                }
                if (incr <= 0) break block4;
                for (int i = incr - 1; i > -1; --i) {
                    array[l - incr + i] = array[l - incr + i - incr];
                    array[0 + i] = 0;
                }
                break block3;
            }
            if (incr >= 0) break block3;
            for (int i = 0; i < incr; ++i) {
                array[i] = array[i + incr + 1];
                array[l - i] = 0;
            }
        }
    }

    public int fastread(byte[] buf, int offset, int numToRead) throws IOException {
        int totalRead = 0;
        if (this.entryOffset >= this.entrySize) {
            return -1;
        }
        if ((long)numToRead + this.entryOffset > this.entrySize) {
            numToRead = (int)(this.entrySize - this.entryOffset);
        }
        if (numToRead + offset > buf.length) {
            numToRead = buf.length - offset;
        }
        if (this.readBuf == null || this.readBuf.length < this.buffer.getRecordSize()) {
            byte[] b = new byte[this.buffer.getRecordSize()];
            if (this.readBuf != null && this.readBufLen > 0) {
                System.arraycopy(this.readBuf, 0, b, 0, this.readBufLen);
            }
            this.readBuf = b;
        }
        while (numToRead > 0) {
            if (this.readBufLen < 1) {
                if (!this.buffer.readRecord(this.readBuf)) {
                    throw new IOException("unexpected EOF with " + numToRead + " bytes unread");
                }
                this.readBufLen = this.getRecordSize();
            }
            int sz = numToRead > this.readBufLen ? this.readBufLen : numToRead;
            System.arraycopy(this.readBuf, 0, buf, offset + totalRead, sz);
            this.shift(this.readBuf, -sz);
            this.readBufLen -= sz;
            totalRead += sz;
            numToRead -= sz;
        }
        this.entryOffset += (long)totalRead;
        if (this.entryOffset >= this.entrySize) {
            this.readBufLen = 0;
        }
        return totalRead;
    }

    public long leap(long numToSkip) throws IOException {
        long skipped = 0L;
        if (this.entryOffset >= this.entrySize) {
            return -1L;
        }
        if (numToSkip + this.entryOffset > this.entrySize) {
            numToSkip = (int)(this.entrySize - this.entryOffset);
        }
        if (this.readBuf != null && numToSkip >= (long)this.readBufLen) {
            skipped = this.readBufLen;
            this.readBuf = null;
            this.readBufLen = 0;
        }
        try {
        }
        catch (EOFException e) {
            return -1L;
        }
        return skipped += this.buffer.skip(numToSkip);
    }

    public void copyEntryContents(OutputStream out) throws IOException {
        this.copyEntryContents(out, 32768);
    }

    public void copyEntryContents(OutputStream out, int bufsize) throws IOException {
        int numRead;
        byte[] buf = new byte[bufsize];
        while ((numRead = this.read(buf, 0, buf.length)) != -1) {
            out.write(buf, 0, numRead);
        }
    }

    private static String tstamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("H:m:s.S");
        return sdf.format(new Date(System.currentTimeMillis()));
    }

    private void debug(String s) {
        if (this.debug) {
            log.debug((Object)String.format("[%s] %s", TarInputStream.tstamp(), s));
        }
    }
}

