/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message;

import com.tandbergtv.workflow.message.IMessageAttachment;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPAttachment
implements IMessageAttachment {
    private Object content;
    private Map<String, String> headers;
    private String contentType;

    public HTTPAttachment() {
        this.headers = new HashMap<String, String>();
    }

    public HTTPAttachment(Object content, String contentType) {
        this.content = content;
        this.contentType = contentType;
    }

    @Override
    public Object getContent() {
        return this.content;
    }

    @Override
    public void setContent(Object content) {
        this.content = content;
    }

    @Override
    public void addMimeHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public Map<String, String> getMimeHeaders() {
        return this.headers;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int contentLength = this.content.toString().length();
        if (contentLength > 300) {
            contentLength = 300;
        }
        buf.append("[ContentType = ").append(this.contentType).append("], Content=").append(this.content.toString().substring(0, contentLength)).append("]");
        return buf.toString();
    }
}

