/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.util;

import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.IDevice;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.comm.TCPDevice;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.AbstractTree;
import com.tandbergtv.workflow.message.util.MarshalException;
import com.tandbergtv.workflow.message.util.Scalar;
import com.tandbergtv.workflow.message.util.Tree;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Marshaller {
    private static final Logger logger = Logger.getLogger(Marshaller.class);

    private Marshaller() {
    }

    public static Marshaller newMarshaller() {
        return new Marshaller();
    }

    public Document marshal(WorkflowMessage message) throws MarshalException {
        Document document = null;
        String type = message.getType().toString();
        String uid = message.getMessageUID().getUID();
        String requestKey = new String();
        if (message.getKey() != null) {
            requestKey = message.getKey().toString();
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            document = factory.newDocumentBuilder().newDocument();
            Element root = this.createRootElement(document, uid, type, requestKey);
            document.appendChild(root);
            this.marshalProperties(document, message);
            if (message.getCommand() != null) {
                this.marshalCommand(message.getCommand(), document);
            }
            if (message.getPayload() != null) {
                WorkflowPayload payload = message.getPayload();
                this.marshalPayload(root, payload);
            }
        }
        catch (Exception e) {
            throw new MarshalException("Failed to marshal the document", e);
        }
        return document;
    }

    private Element createRootElement(Document document, String uid, String type, String requestKey) {
        Element root = this.createElement(document, "WFSMessage");
        root.setAttribute("UID", uid);
        root.setAttribute("Type", type);
        root.setAttribute("RequestKey", requestKey);
        Element body = this.createElement(document, "MessageBody");
        Element params = this.createElement(document, "ParameterList");
        body.appendChild(params);
        root.appendChild(body);
        return root;
    }

    private void marshalPayload(Element root, WorkflowPayload payload) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node parameterList = (Node)xpath.evaluate("//MessageBody/ParameterList", root, XPathConstants.NODE);
        for (AbstractTree absTree : ((Tree)payload.getPayload()).getTreeList()) {
            if (!(absTree instanceof Tree)) continue;
            this.marshalTree(parameterList, (Tree)absTree);
        }
    }

    private void marshalTree(Node element, Tree tree) {
        Document document = element.getOwnerDocument();
        String key = tree.getKey();
        List<AbstractTree> treeList = tree.getTreeList();
        if (treeList == null) {
            return;
        }
        if (treeList.size() > 1 || treeList.size() == 1 && !(treeList.get(0) instanceof Scalar)) {
            Element listParam = this.createElement(document, "List");
            listParam.setAttribute("Name", key);
            element.appendChild(listParam);
            for (AbstractTree absTree : treeList) {
                if (!(absTree instanceof Tree)) continue;
                Tree listItemTree = (Tree)absTree;
                String listItemKey = listItemTree.getKey();
                Element listItemParam = this.createElement(document, "ListItem");
                listItemParam.setAttribute("Name", listItemKey);
                listParam.appendChild(listItemParam);
                for (AbstractTree absSubTree : listItemTree.getTreeList()) {
                    if (absSubTree instanceof Scalar) {
                        this.marshalScalar(listItemParam, key, ((Scalar)absSubTree).getValue());
                        continue;
                    }
                    this.marshalTree(listItemParam, (Tree)absSubTree);
                }
            }
        } else if (treeList.size() == 1 && treeList.get(0) instanceof Scalar) {
            this.marshalScalar(element, key, ((Scalar)treeList.get(0)).getValue());
        }
    }

    private void marshalScalar(Node element, String key, String value) {
        Document document = element.getOwnerDocument();
        Element param = this.createElement(document, "Parameter");
        param.setAttribute("DataType", "String");
        param.setAttribute("Name", key);
        Element e = this.createElement(document, "Value");
        if (value != null && value.indexOf(60) >= 0 && value.indexOf(62) >= 0) {
            e.appendChild(document.createCDATASection(value));
        } else {
            e.setTextContent(value);
        }
        param.appendChild(e);
        element.appendChild(param);
    }

    private Element createElement(Document document, String name) {
        return document.createElement(name);
    }

    private void marshalProperties(Document doc, WorkflowMessage wfsMessage) {
        Element sourceElement = this.createSourceElement(doc, wfsMessage.getSource());
        if (sourceElement != null) {
            doc.getDocumentElement().appendChild(sourceElement);
        } else {
            logger.debug((Object)"No source element present");
        }
        Element responseDestinationElement = this.createResponseDestinationElement(doc, wfsMessage.getResponseDestination());
        if (responseDestinationElement != null) {
            doc.getDocumentElement().appendChild(responseDestinationElement);
        } else {
            logger.debug((Object)"No response destination present");
        }
    }

    public Element createSourceElement(Document doc, ISource source) {
        Element deviceInfoElement;
        Element sourceElement = null;
        if (source != null && (deviceInfoElement = this.createDeviceElement(doc, source)) != null) {
            sourceElement = this.createElement(doc, "Source");
            sourceElement.setAttribute("Name", source.getName());
            sourceElement.appendChild(deviceInfoElement);
        }
        return sourceElement;
    }

    public Element createResponseDestinationElement(Document doc, IDestination responseDestination) {
        Element deviceInfoElement;
        Element responseDestinationElement = null;
        if (responseDestination != null && (deviceInfoElement = this.createDeviceElement(doc, responseDestination)) != null) {
            responseDestinationElement = this.createElement(doc, "ResponseDestination");
            responseDestinationElement.appendChild(deviceInfoElement);
        }
        return responseDestinationElement;
    }

    private Element createDeviceElement(Document doc, IDevice device) {
        Element deviceInfoElement = null;
        if (device instanceof HTTPDevice) {
            Element sourceUrlElement = this.createElement(doc, "URL");
            String url = ((HTTPDevice)device).getUrl();
            sourceUrlElement.setTextContent(url);
            deviceInfoElement = sourceUrlElement;
        } else if (device instanceof TCPDevice) {
            Element sourceHostElement = this.createElement(doc, "Host");
            String ip = ((TCPDevice)device).getIP();
            int port = ((TCPDevice)device).getPort();
            sourceHostElement.setAttribute("IP", ip);
            sourceHostElement.setAttribute("Port", Integer.toString(port));
            deviceInfoElement = sourceHostElement;
        }
        return deviceInfoElement;
    }

    private void marshalCommand(WPCLCommand command, Document document) {
        Element e = document.createElement("Command");
        e.setAttribute("Name", command.getName());
        for (String key : command.getParameters().keySet()) {
            Element parameter = document.createElement("CommandParameter");
            parameter.setAttribute("Name", key);
            parameter.setAttribute("Value", command.getParameterValue(key));
            e.appendChild(parameter);
        }
        document.getDocumentElement().appendChild(e);
    }
}

