/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.standardInterceptors;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.CodeSet;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;

public class CodeSetInfoInterceptor
extends LocalObject
implements IORInterceptor,
Configurable {
    private TaggedComponent tagc = null;
    private Logger logger = null;

    public CodeSetInfoInterceptor(ORB oRB) {
        try {
            this.configure(oRB.getConfiguration());
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        CodeSetComponentInfo codeSetComponentInfo = new CodeSetComponentInfo();
        codeSetComponentInfo.ForCharData = new CodeSetComponent(CodeSet.getTCSDefault(), new int[]{CodeSet.getConversionDefault()});
        codeSetComponentInfo.ForWcharData = new CodeSetComponent(CodeSet.getTCSWDefault(), new int[]{0x5010001});
        CDROutputStream cDROutputStream = new CDROutputStream(oRB);
        cDROutputStream.beginEncapsulatedArray();
        CodeSetComponentInfoHelper.write(cDROutputStream, codeSetComponentInfo);
        this.tagc = new TaggedComponent(1, cDROutputStream.getBufferCopy());
        cDROutputStream.close();
        cDROutputStream = null;
        codeSetComponentInfo = null;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        org.jacorb.config.Configuration configuration2 = (org.jacorb.config.Configuration)configuration;
        this.logger = configuration2.getNamedLogger("org.jacorb.interceptors.ior_init");
        String string = configuration.getAttribute("jacorb.native_char_codeset", "ISO-8859-1");
        String string2 = configuration.getAttribute("jacorb.native_wchar_codeset", "UTF-16");
        if (CodeSet.setNCSC(string) == -1 && this.logger.isErrorEnabled()) {
            this.logger.error("Cannot set default NCSC to " + string);
        }
        if (CodeSet.setNCSW(string2) == -1 && this.logger.isErrorEnabled()) {
            this.logger.error("Cannot set default NCSW to " + string2);
        }
    }

    public String name() {
        return "CodeSetInfoComponentCreator";
    }

    public void destroy() {
    }

    public void establish_components(IORInfo iORInfo, int[] nArray) {
        if (nArray == null) {
            iORInfo.add_ior_component_to_profile(this.tagc, 1);
            iORInfo.add_ior_component_to_profile(this.tagc, 0);
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                iORInfo.add_ior_component_to_profile(this.tagc, nArray[i]);
            }
        }
    }

    public void establish_components(IORInfo iORInfo) {
        iORInfo.add_ior_component_to_profile(this.tagc, 1);
        iORInfo.add_ior_component_to_profile(this.tagc, 0);
    }
}

