/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.LoggerModule;

import com.n2bb.LoggerModule.MessageQueue;
import com.n2bb.LoggerModule.UDPListener;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class CentralLogger {
    private static final String CONFIG_FILE = "/usr/local/n2bb/logger/conf/CentralLogger.xml";
    private static Logger logger;
    private static Logger isalog;
    private MessageQueue mq;
    private Thread listener;
    private Thread processor;

    public CentralLogger(int listenPort, int rcvBufferSize) throws Exception {
        DOMConfigurator.configureAndWatch((String)CONFIG_FILE, (long)30000L);
        logger = Logger.getLogger(CentralLogger.class);
        logger.info((Object)("CentralLogger starting - UDP receive port... " + listenPort));
        isalog = Logger.getLogger((String)"isalog");
        this.mq = new MessageQueue();
        this.listener = new UDPListener(listenPort, this.mq, rcvBufferSize);
        this.processor = new MsgProcessor();
        this.listener.start();
        this.processor.start();
    }

    public static void usage() throws Exception {
        System.out.println("Usage:  CentralLogger listenPort rcvBufferSize [nameServiceCorbaloc]");
        System.out.println("  The nameServiceCorbaloc is only needed if using the AlertsAppender.");
    }

    public static void main(String[] args) throws Exception {
        int rcvBufferSize;
        int listenPort;
        if (args.length < 2) {
            CentralLogger.usage();
            return;
        }
        String nameService = null;
        try {
            listenPort = Integer.parseInt(args[0]);
            rcvBufferSize = Integer.parseInt(args[1]);
            if (args.length >= 3) {
                nameService = args[2];
                System.setProperty("NameService", nameService);
            }
        }
        catch (Exception e) {
            CentralLogger.usage();
            throw e;
        }
        new CentralLogger(listenPort, rcvBufferSize);
    }

    private class MsgProcessor
    extends Thread {
        private MsgProcessor() {
        }

        public void run() {
            logger.info((Object)"MsgProcessor thread running");
            while (true) {
                byte[] b = (byte[])CentralLogger.this.mq.getMessage();
                try {
                    isalog.debug((Object)new String(b, 0, b.length, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Error processing UTF-8 log message! " + e.getMessage(), e);
                }
            }
        }
    }
}

