/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.CharData;
import oracle.xml.parser.v2.NodeReference;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNSNode;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.InfosetWriter;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;
import oracle.xml.util.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XMLText
extends CharData
implements Text,
Externalizable {
    static QxName CLASS_QNAME = QxNameHash.create("", "#text", "", "#text");
    static final int WHITESPACE_NODE = 65536;
    static final int CHAR_ARRAY_VALUE = 131072;
    static final int LAZY_TEXT = 262144;
    static final int LARGE_TEXT = 4096;
    private static final int TEXT_PARENT = 0;
    private static final int TEXT_VALUE = 1;
    private static final int TEXT_NEXTNODE = 2;
    private static final int TEXT_PREVNODE = 3;
    private static final int TEXT_OFFSET = 4;
    private static final int TEXT_READER = 5;
    private static final int TEXT_DATASZ = 4;

    public XMLText() {
        this.setNodeFlag(131072);
    }

    public XMLText(String string) {
        this.setNodeValue(string);
    }

    protected XMLText(XMLDocument xMLDocument) {
        super(xMLDocument);
        this.setNodeFlag(131072);
    }

    XMLText(char[] cArray, int n, int n2) {
        this.addText(cArray, n, n2);
    }

    public short getNodeType() {
        return 3;
    }

    public QxName getQName() {
        return CLASS_QNAME;
    }

    public String getNodeName() {
        return "#text";
    }

    public boolean checkTypeNSName(int n, String string, String string2) {
        return n == 3;
    }

    public Text splitText(int n) throws DOMException {
        XMLText xMLText;
        this.checkReadOnly();
        String string = this.getNodeValueNoNull();
        int n2 = string.length();
        try {
            this.setData(string.substring(0, n));
            XMLDocument xMLDocument = (XMLDocument)this.getOwnerDocument();
            xMLText = (XMLText)xMLDocument.createTextNode(string.substring(n, n2));
            Node node = this.getParentNode();
            if (node != null) {
                if (((XMLNode)node).isScalable()) {
                    ((XMLNode)node).xdkKeepNode();
                }
                node.replaceChild(xMLText, this);
                xMLText.getParentNode().insertBefore(this, xMLText);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new XMLDOMException(1, 21001, this.getXMLError(), String.valueOf(n), String.valueOf(n2));
        }
        return xMLText;
    }

    private boolean isWhitespace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (XMLUtil.isWhiteSpaceChar(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isWhitespace(char[] cArray) {
        if (cArray == null) {
            return false;
        }
        return this.isWhitespace(cArray, 0, cArray.length);
    }

    private boolean isWhitespace(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return false;
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            if (XMLUtil.isWhiteSpaceChar(c)) continue;
            return false;
        }
        return true;
    }

    private boolean hasWhitespace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!XMLUtil.isWhiteSpaceChar(c)) continue;
            return true;
        }
        return false;
    }

    private boolean hasWhitespace(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return false;
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            if (!XMLUtil.isWhiteSpaceChar(c)) continue;
            return true;
        }
        return false;
    }

    public boolean isElementContentWhitespace() {
        switch (this.flags & 3) {
            case 1: {
                boolean bl;
                if (this.getParentNode() == null) {
                    return false;
                }
                if (this.isNodeFlag(65536)) {
                    return true;
                }
                if (!this.isNodeFlag(131072)) {
                    String string = this.getNodeValue();
                    bl = this.hasWhitespace(string);
                } else {
                    char[] cArray = this.getTextChars();
                    int n = cArray == null ? 0 : cArray.length;
                    bl = this.hasWhitespace(cArray, 0, n);
                }
                return bl;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return false;
    }

    public String getWholeText() {
        switch (this.flags & 3) {
            case 1: {
                Node node = this;
                Node node2 = null;
                while ((node2 = this.getPreviousSibling()) != null && (node2.getNodeType() == 3 || node2.getNodeType() == 4)) {
                    node = node2;
                }
                StringBuffer stringBuffer = new StringBuffer();
                do {
                    String string = ((CharData)node).getNodeValueNoNull();
                    stringBuffer.append(string);
                } while ((node = node.getNextSibling()) != null && (node.getNodeType() == 3 || node.getNodeType() == 4));
                return stringBuffer.toString();
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public Text replaceWholeText(String string) throws DOMException {
        if (string == null || string == "") {
            return null;
        }
        switch (this.flags & 3) {
            case 1: {
                Node node = null;
                Node node2 = this.getParentNode();
                while ((node = this.getPreviousSibling()) != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
                    node2.removeChild(node);
                }
                while ((node = this.getNextSibling()) != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
                    node2.removeChild(node);
                }
                this.xdkSetNodeValue(string);
                if (this.isScalable()) {
                    this.xdkKeepNode();
                }
                return this;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public boolean isWhiteSpaceNode() {
        boolean bl = false;
        switch (this.flags & 3) {
            case 1: {
                bl = this.isNodeFlag(65536);
                break;
            }
            case 2: {
                String string = this.getNodeValue();
                bl = this.isWhitespace(string);
            }
        }
        return bl;
    }

    public void addText(char[] cArray, int n, int n2) {
        switch (this.flags & 3) {
            case 1: {
                boolean bl;
                this.convertContentToCharArray();
                char[] cArray2 = this.getTextChars();
                if (this.isNodeFlag(65536) && !(bl = this.isWhitespace(cArray, n, n2))) {
                    this.resetNodeFlag(65536);
                }
                if (cArray2 != null) {
                    char[] cArray3 = cArray2;
                    int n3 = cArray2.length;
                    cArray2 = new char[n2 + n3];
                    System.arraycopy(cArray3, 0, cArray2, 0, n3);
                    System.arraycopy(cArray, n, cArray2, n3, n2);
                } else {
                    cArray2 = new char[n2];
                    System.arraycopy(cArray, n, cArray2, 0, n2);
                }
                this.xdkSetTextArray(cArray2);
                return;
            }
            case 2: {
                this.appendData(new String(cArray, n, n2));
                return;
            }
        }
    }

    public String getData() throws DOMException {
        return this.getNodeValue();
    }

    public void reportSAXEvents(ContentHandler contentHandler) throws SAXException {
        String string = this.getNodeValueNoNull();
        char[] cArray = string.toCharArray();
        int n = string.length();
        this.getDOMLocator().setCurrentNode(this);
        contentHandler.characters(cArray, 0, n);
    }

    void reportSAXEvents(boolean bl, ContentHandler contentHandler) throws SAXException {
        String string = this.getNodeValueNoNull();
        char[] cArray = string.toCharArray();
        int n = string.length();
        this.getDOMLocator().setCurrentNode(this);
        contentHandler.characters(cArray, 0, n);
    }

    public short isWhitespaceOnly() {
        switch (this.flags & 3) {
            case 1: {
                if (this.isWhiteSpaceNode()) {
                    return 5;
                }
                return 6;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canSetData(String string) {
        switch (this.flags & 3) {
            case 1: {
                XMLNSNode xMLNSNode = (XMLNSNode)this.getParentNode();
                if (xMLNSNode == null || xMLNSNode.getNodeType() != 1) {
                    return 7;
                }
                XSDElement xSDElement = ((XMLElement)xMLNSNode).getElementDeclaration();
                if (xSDElement == null || xSDElement.getType() instanceof XSDComplexType) {
                    return 5;
                }
                try {
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDElement.getType();
                    String string2 = xSDElement.getFixedVal();
                    if (string2 != null && xSDSimpleType.compareValues(string2, string) != 0) {
                        return 6;
                    }
                    xSDSimpleType.validateValue(string);
                }
                catch (Exception exception) {
                    return 6;
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canAppendData(String string) {
        switch (this.flags & 3) {
            case 1: {
                XMLNSNode xMLNSNode = (XMLNSNode)this.getParentNode();
                if (xMLNSNode == null || xMLNSNode.getNodeType() != 1) {
                    return 7;
                }
                XSDElement xSDElement = ((XMLElement)xMLNSNode).getElementDeclaration();
                if (xSDElement == null || xSDElement.getType() instanceof XSDComplexType) {
                    return 5;
                }
                try {
                    String string2;
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDElement.getType();
                    String string3 = this.getNodeValueNoNull();
                    StringBuffer stringBuffer = new StringBuffer(string3);
                    String string4 = string == null ? "" : string;
                    stringBuffer.append(string4);
                    XMLNode xMLNode = null;
                    for (xMLNode = (XMLNode)this.getPreviousSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getPreviousSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        string2 = ((CharData)xMLNode).getNodeValueNoNull();
                        stringBuffer.insert(0, string2);
                    }
                    for (xMLNode = (XMLNode)this.getNextSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.append(string3);
                    }
                    string2 = xSDElement.getFixedVal();
                    if (string2 != null && xSDSimpleType.compareValues(string2, stringBuffer.toString()) != 0) {
                        return 6;
                    }
                    xSDSimpleType.validateValue(stringBuffer.toString());
                }
                catch (Exception exception) {
                    return 6;
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canReplaceData(int n, int n2, String string) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                super.canReplaceData(n, n2, string);
                XMLNSNode xMLNSNode = (XMLNSNode)this.getParentNode();
                if (xMLNSNode == null || xMLNSNode.getNodeType() != 1) {
                    return 7;
                }
                XSDElement xSDElement = ((XMLElement)xMLNSNode).getElementDeclaration();
                if (xSDElement == null || xSDElement.getType() instanceof XSDComplexType) {
                    return 5;
                }
                try {
                    String string2;
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDElement.getType();
                    String string3 = this.xdkGetNodeValueNoNull();
                    StringBuffer stringBuffer = new StringBuffer(string3);
                    stringBuffer.replace(n, n + n2, string);
                    XMLNode xMLNode = null;
                    for (xMLNode = (XMLNode)this.getPreviousSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getPreviousSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        string2 = ((CharData)xMLNode).getNodeValueNoNull();
                        stringBuffer.insert(0, string2);
                    }
                    for (xMLNode = (XMLNode)this.getNextSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.append(string3);
                    }
                    string2 = xSDElement.getFixedVal();
                    if (string2 != null && xSDSimpleType.compareValues(string2, stringBuffer.toString()) != 0) {
                        return 6;
                    }
                    xSDSimpleType.validateValue(stringBuffer.toString());
                }
                catch (Exception exception) {
                    return 6;
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canInsertData(int n, String string) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                super.canInsertData(n, string);
                XMLNSNode xMLNSNode = (XMLNSNode)this.getParentNode();
                if (xMLNSNode == null || xMLNSNode.getNodeType() != 1) {
                    return 7;
                }
                XSDElement xSDElement = ((XMLElement)xMLNSNode).getElementDeclaration();
                if (xSDElement == null || xSDElement.getType() instanceof XSDComplexType) {
                    return 5;
                }
                try {
                    String string2;
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDElement.getType();
                    String string3 = this.xdkGetNodeValueNoNull();
                    StringBuffer stringBuffer = new StringBuffer(string3);
                    String string4 = string == null ? "" : string;
                    stringBuffer.insert(n, string4);
                    XMLNode xMLNode = null;
                    for (xMLNode = (XMLNode)this.getPreviousSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getPreviousSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        string2 = ((CharData)xMLNode).getNodeValueNoNull();
                        stringBuffer.insert(0, string2);
                    }
                    for (xMLNode = (XMLNode)this.getNextSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.append(string3);
                    }
                    string2 = xSDElement.getFixedVal();
                    if (string2 != null && xSDSimpleType.compareValues(string2, stringBuffer.toString()) != 0) {
                        return 6;
                    }
                    xSDSimpleType.validateValue(stringBuffer.toString());
                }
                catch (Exception exception) {
                    return 6;
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canDeleteData(int n, int n2) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                super.canDeleteData(n, n2);
                XMLNSNode xMLNSNode = (XMLNSNode)this.getParentNode();
                if (xMLNSNode == null || xMLNSNode.getNodeType() != 1) {
                    return 7;
                }
                XSDElement xSDElement = ((XMLElement)xMLNSNode).getElementDeclaration();
                if (xSDElement == null || xSDElement.getType() instanceof XSDComplexType) {
                    return 5;
                }
                try {
                    String string;
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDElement.getType();
                    String string2 = this.xdkGetNodeValueNoNull();
                    StringBuffer stringBuffer = new StringBuffer(string2);
                    stringBuffer.delete(n, n + n2);
                    XMLNode xMLNode = null;
                    for (xMLNode = (XMLNode)this.getPreviousSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getPreviousSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        string = ((CharData)xMLNode).getNodeValueNoNull();
                        stringBuffer.insert(0, string);
                    }
                    for (xMLNode = (XMLNode)this.getNextSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.append(string2);
                    }
                    string = xSDElement.getFixedVal();
                    if (string != null && xSDSimpleType.compareValues(string, stringBuffer.toString()) != 0) {
                        return 6;
                    }
                    xSDSimpleType.validateValue(stringBuffer.toString());
                }
                catch (Exception exception) {
                    return 6;
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    void writeNodeInfo(InfosetWriter infosetWriter, boolean bl, boolean bl2) {
        String string = this.xdkGetNodeValue();
        if (string == null) {
            return;
        }
        infosetWriter.createEvent(4);
        infosetWriter.setValue(string);
        infosetWriter.save();
    }

    void readNodeInfo(InfosetReader infosetReader, boolean bl) {
        int n = infosetReader.getEventType();
        this.setNodeFlag(65536, n == 6);
        int n2 = infosetReader.getDataLength();
        if (n2 <= 4096 || !this.isScalable()) {
            String string = infosetReader.getValue();
            this.xdkSetNodeValue(string);
        } else {
            this.setNodeFlag(262144);
        }
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        XMLNode xMLNode;
        char[] cArray = this.getTextChars();
        if (cArray == null) {
            return;
        }
        if (this.isNodeFlag(65536) && (xMLNode = (XMLNode)this.getParentNode()) != null && xMLNode.isNodeFlag(131072)) {
            return;
        }
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            String string = null;
            char c = cArray[i];
            if (c == '&') {
                string = "&amp;";
            } else if (c == '<') {
                string = "&lt;";
            } else if (i > 1 && c == '>') {
                string = bl || cArray[i - 1] == ']' && cArray[i - 2] == ']' ? "&gt;" : ">";
            }
            if (string == null) {
                xMLOutputStream.write(c);
                continue;
            }
            xMLOutputStream.writeChars(string);
        }
    }

    private char[] getTextChars() {
        char[] cArray = null;
        switch (this.flags & 3) {
            case 1: {
                cArray = this.xdkGetTextArray();
                break;
            }
            case 2: {
                String string = this.getNodeValue();
                if (this.isWhitespace(string)) {
                    this.setNodeFlag(65536);
                } else {
                    this.resetNodeFlag(65536);
                }
                if (string == null) break;
                cArray = string.toCharArray();
            }
        }
        return cArray;
    }

    XMLNode xdkCopyNode(XMLDocument xMLDocument, int n) {
        String string = this.xdkGetNodeValue();
        XMLText xMLText = (XMLText)xMLDocument.createTextNode(string);
        short s = this.getUserDataHandlerOpcode(n);
        this.callUserDataHandlers(s, xMLText);
        return xMLText;
    }

    XMLNode xdkGetParentNode() {
        int n = (int)this.nodeId + 0;
        return (XMLNode)this.data[n];
    }

    void xdkSetParentNode(XMLNode xMLNode) {
        int n = (int)this.nodeId + 0;
        this.data[n] = xMLNode;
    }

    String xdkGetNodeValue() {
        if (this.isNodeFlag(262144)) {
            InfosetReader infosetReader = this.xdkGetReader();
            infosetReader.seek(this.xdkGetOffset());
            this.resetNodeFlag(262144);
            this.xdkSetNodeValue(infosetReader.getValue());
        } else if (this.isNodeFlag(131072)) {
            this.convertContentToString();
        }
        int n = (int)this.nodeId + 1;
        return (String)this.data[n];
    }

    void xdkSetNodeValue(String string) {
        int n = (int)this.nodeId + 1;
        this.data[n] = string;
        if (this.isWhitespace(string)) {
            this.setNodeFlag(65536);
        } else {
            this.resetNodeFlag(65536);
        }
        this.resetNodeFlag(131072);
    }

    private synchronized char[] xdkGetTextArray() {
        char[] cArray = null;
        int n = (int)this.nodeId + 1;
        if (this.isNodeFlag(131072)) {
            cArray = (char[])this.data[n];
        } else {
            String string = (String)this.data[n];
            if (string != null) {
                cArray = string.toCharArray();
            }
        }
        return cArray;
    }

    private void xdkSetTextArray(char[] cArray) {
        this.setNodeFlag(131072);
        int n = (int)this.nodeId + 1;
        this.data[n] = cArray;
        if (this.isWhitespace(cArray)) {
            this.setNodeFlag(65536);
        } else {
            this.resetNodeFlag(65536);
        }
    }

    XMLNode xdkGetNextNode() {
        InfosetReader.Offset offset;
        NodeReference nodeReference;
        int n = (int)this.nodeId + 2;
        Object object = this.data[n];
        if (!this.isNodeFlag(2048)) {
            return (XMLNode)object;
        }
        if (object instanceof NodeReference) {
            nodeReference = (NodeReference)object;
            if ((object = nodeReference.get()) != null) {
                return (XMLNode)object;
            }
            offset = nodeReference.offset;
        } else if (object instanceof InfosetReader.Offset) {
            offset = (InfosetReader.Offset)object;
        } else {
            if (object instanceof XMLNode) {
                return (XMLNode)object;
            }
            return null;
        }
        XMLNode xMLNode = this.xdkGetParentNode();
        XMLDocument xMLDocument = this.getDocument();
        XMLNode xMLNode2 = xMLDocument.createNodeFromOffset(offset, this.xdkGetReader(), xMLNode);
        xMLNode.updateNext();
        if (xMLDocument.scalable) {
            nodeReference = new NodeReference(xMLNode2, offset);
            this.xdkSetNextNode(nodeReference);
            xMLNode.xdkSetLastChild(nodeReference);
        } else {
            this.xdkSetNextNode(xMLNode2);
            xMLNode.xdkSetLastChild(xMLNode2);
        }
        xMLNode2.xdkSetParentNode(xMLNode);
        if (!xMLDocument.isNodeFlag(0x200000)) {
            xMLNode2.xdkSetPrevNode(this);
        }
        if (xMLDocument.nodeHandler != null) {
            xMLDocument.nodeHandler.reportNodeRead(xMLNode2);
            return this.xdkGetNextNode();
        }
        return xMLNode2;
    }

    void xdkSetNextNode(Object object) {
        if (this.isScalable() && object instanceof XMLNode) {
            this.xdkKeepNode();
            this.resetNodeFlag(4096);
        }
        int n = (int)this.nodeId + 2;
        this.data[n] = object;
    }

    XMLNode xdkGetPrevNode() {
        int n = (int)this.nodeId + 3;
        return (XMLNode)this.data[n];
    }

    void xdkSetPrevNode(XMLNode xMLNode) {
        int n = (int)this.nodeId + 3;
        this.data[n] = xMLNode;
    }

    int xdkGetNodeArraySize() {
        if (this.isNodeFlag(2048)) {
            return 6;
        }
        return 4;
    }

    InfosetReader.Offset xdkGetOffset() {
        int n = (int)this.nodeId + 4;
        return (InfosetReader.Offset)this.data[n];
    }

    InfosetReader xdkGetReader() {
        int n = (int)this.nodeId + 5;
        return (InfosetReader)this.data[n];
    }

    void xdkSetOffset(InfosetReader.Offset offset, InfosetReader infosetReader) {
        int n = (int)this.nodeId + 4;
        this.data[n] = offset;
        int n2 = (int)this.nodeId + 5;
        this.data[n2] = infosetReader;
    }

    private synchronized void convertContentToString() {
        if (!this.isNodeFlag(131072)) {
            return;
        }
        int n = (int)this.nodeId + 1;
        char[] cArray = (char[])this.data[n];
        String string = cArray == null ? null : new String(cArray, 0, cArray.length);
        this.xdkSetNodeValue(string);
    }

    private void convertContentToCharArray() {
        if (this.isNodeFlag(131072)) {
            return;
        }
        this.setNodeFlag(131072);
        int n = (int)this.nodeId + 1;
        String string = (String)this.data[n];
        if (string == null) {
            return;
        }
        this.data[n] = string.toCharArray();
    }
}

