/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathVariableResolver;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xpath.XPathConstantExpr;
import oracle.xml.xpath.XPathContext;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathPredicate;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XPathStep;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class JXPathExpression
implements XPathExpression {
    private String exprString;
    private XSLExprBase expression;
    private XPathVariableResolver varResolver;
    private boolean createNode;
    private boolean enableException;

    JXPathExpression(XSLExprBase xSLExprBase, XPathVariableResolver xPathVariableResolver, String string) {
        this.exprString = string;
        this.expression = xSLExprBase;
        this.varResolver = xPathVariableResolver;
    }

    public String toString() {
        return this.exprString;
    }

    public Object evaluate(Object object, QName qName) throws XPathExpressionException {
        if (qName == null) {
            throw new NullPointerException();
        }
        XPathRuntimeContext xPathRuntimeContext = null;
        XMLError xMLError = new XMLError();
        try {
            Object object2;
            xPathRuntimeContext = new XPathRuntimeContext();
            xPathRuntimeContext.init();
            if (this.varResolver != null) {
                xPathRuntimeContext.setVarResolver(this.varResolver);
            }
            XMLNode xMLNode = null;
            XPathContext xPathContext = null;
            if (object instanceof XMLNode) {
                xMLNode = (XMLNode)object;
            } else if (object instanceof XPathContext) {
                ((XPathContext)object).resetXPathError();
                xPathContext = (XPathContext)object;
                xMLNode = (XMLNode)xPathContext.getContextNode();
                if (xMLNode == null) {
                    xMLNode = new XMLDocument();
                }
                if ((object2 = xPathContext.getXPathVariableResolver()) != null) {
                    xPathRuntimeContext.setVarResolver((XPathVariableResolver)object2);
                }
            } else if (object == null) {
                xMLNode = new XMLDocument();
            } else {
                throw new IllegalArgumentException();
            }
            object2 = xMLNode.getSrcRoot();
            xPathRuntimeContext.addSourceContext((XMLElement)object2, xMLNode.getDocument());
            xPathRuntimeContext.setContextSize(1);
            xPathRuntimeContext.setContextPosition(1);
            xPathRuntimeContext.setContextNode(xMLNode);
            xPathRuntimeContext.setXPathContext(xPathContext);
            xPathRuntimeContext.setCreateNode(this.createNode);
            xPathRuntimeContext.setEnableException(this.enableException);
            try {
                if (this.expression.isStreamable()) {
                    this.expression.streamingEvaluate(xPathRuntimeContext);
                } else {
                    this.expression.evaluate(xPathRuntimeContext);
                }
                XPathSequence xPathSequence = (XPathSequence)xPathRuntimeContext.peekExprValue();
                if (qName.equals(XPathConstants.NODESET)) {
                    return xPathSequence.getNodeList();
                }
                if (qName.equals(XPathConstants.NODE)) {
                    if (xPathSequence.next()) {
                        return XPathSequence.nextNode(xPathSequence);
                    }
                    return null;
                }
                if (qName.equals(XPathConstants.STRING)) {
                    return xPathSequence.getStringValue();
                }
                if (qName.equals(XPathConstants.BOOLEAN)) {
                    return new Boolean(xPathSequence.getEffectiveBooleanValue());
                }
                if (qName.equals(XPathConstants.NUMBER)) {
                    return new Double(xPathSequence.getNumberValue());
                }
                if (qName.equals(XPathContext.OBJECT)) {
                    return xPathSequence.getObjectValue();
                }
                if (qName.equals(XPathContext.SEQUENCE)) {
                    return xPathSequence;
                }
                throw new IllegalArgumentException();
            }
            catch (XQException xQException) {
                Throwable throwable = xQException.getCause();
                if (throwable != null && throwable instanceof XSLException && throwable.getMessage().equals("TERMINATE PROCESSING")) {
                    throw (XSLException)throwable;
                }
                String string = null;
                String string2 = XMLError.getXPathErrorID(xQException.getErrorCode());
                if (string2 != null) {
                    string = xMLError.getMessage0(Integer.parseInt(string2));
                } else if (throwable != null && throwable instanceof Exception) {
                    string = throwable.getMessage();
                }
                if (string == null) {
                    string = xMLError.getMessage0(23002);
                }
                XPathExpressionException xPathExpressionException = new XPathExpressionException(string);
                if (throwable != null) {
                    xPathExpressionException.initCause(throwable);
                }
                throw xPathExpressionException;
            }
        }
        catch (XSLException xSLException) {
            XPathExpressionException xPathExpressionException = new XPathExpressionException(xSLException.getMessage());
            xPathExpressionException.initCause(xSLException);
            throw xPathExpressionException;
        }
    }

    public String evaluate(Object object) throws XPathExpressionException {
        return (String)this.evaluate(object, XPathConstants.STRING);
    }

    public Object evaluate(InputSource inputSource, QName qName) throws XPathExpressionException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(true);
        dOMParser.setValidationMode(0);
        try {
            dOMParser.parse(inputSource);
        }
        catch (IOException iOException) {
            XPathExpressionException xPathExpressionException = new XPathExpressionException(iOException.getMessage());
            xPathExpressionException.initCause(iOException);
            throw xPathExpressionException;
        }
        catch (SAXException sAXException) {
            XPathExpressionException xPathExpressionException = new XPathExpressionException(sAXException.getMessage());
            xPathExpressionException.initCause(sAXException);
            throw xPathExpressionException;
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        return this.evaluate(xMLDocument, qName);
    }

    public String evaluate(InputSource inputSource) throws XPathExpressionException {
        return (String)this.evaluate(inputSource, XPathConstants.STRING);
    }

    public void setCreateNode(boolean bl) {
        this.createNode = bl;
    }

    public boolean getCreateNode() {
        return this.createNode;
    }

    void setEnableException(boolean bl) {
        this.enableException = bl;
    }

    boolean getEnableException() {
        return this.enableException;
    }

    boolean validateXPathExpression() throws XPathException {
        int n = this.expression.getStepList().size();
        for (int i = 0; i < n; ++i) {
            XPathStep xPathStep = (XPathStep)this.expression.getStepList().get(i);
            if (xPathStep.axisClass.axisType != 3) {
                throw new XPathException(1013, this.exprString);
            }
            if (xPathStep.prevSeparator == 6) {
                throw new XPathException(1013, this.exprString);
            }
            if (xPathStep.predicates == null) continue;
            XPathPredicate xPathPredicate = xPathStep.predicates;
            for (int j = 0; j < xPathPredicate.predicates.size(); ++j) {
                if (xPathPredicate.predicates.elementAt(j) instanceof XPathConstantExpr) continue;
                throw new XPathException(1013, this.exprString);
            }
        }
        return true;
    }
}

