/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.etf;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.jacorb.orb.etf.ConnectionBase;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.ETF.BufferHolder;

public abstract class StreamConnectionBase
extends ConnectionBase {
    protected InputStream in_stream = null;
    protected OutputStream out_stream = null;

    protected StreamConnectionBase() {
    }

    protected StreamConnectionBase(StreamConnectionBase streamConnectionBase) {
        super(streamConnectionBase);
        this.in_stream = streamConnectionBase.in_stream;
        this.out_stream = streamConnectionBase.out_stream;
    }

    public int read(BufferHolder bufferHolder, int n, int n2, int n3, long l) {
        int n4;
        int n5;
        for (n4 = 0; n4 < n2; n4 += n5) {
            n5 = 0;
            try {
                n5 = this.in_stream.read(bufferHolder.value, n + n4, n3 - n4);
            }
            catch (InterruptedIOException interruptedIOException) {
                int n6 = this.getTimeout();
                if (n6 != 0) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Socket timeout (timeout period: " + n6 + ")");
                    }
                    throw new TIMEOUT();
                }
                throw new TRANSIENT("Interrupted I/O: " + interruptedIOException);
            }
            catch (IOException iOException) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Transport to " + this.connection_info + ": stream closed " + iOException.getMessage());
                }
                throw this.to_COMM_FAILURE(iOException);
            }
            if (n5 >= 0) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Transport to " + this.connection_info + ": stream closed on read  < 0");
            }
            throw new COMM_FAILURE("read() did not return any data");
        }
        return n4;
    }

    public void write(boolean bl, boolean bl2, byte[] byArray, int n, int n2, long l) {
        try {
            this.out_stream.write(byArray, n, n2);
            if (this.b_out != null) {
                this.b_out.write(byArray, n, n2);
            }
        }
        catch (IOException iOException) {
            throw this.to_COMM_FAILURE(iOException);
        }
    }

    public void flush() {
        try {
            if (this.b_out != null) {
                if (this.logger.isInfoEnabled()) {
                    byte[] byArray = this.b_out.toByteArray();
                    this.logger.info("sendMessages(): " + ObjectUtil.bufToString(byArray, 0, byArray.length));
                }
                this.b_out.reset();
            }
            this.out_stream.flush();
        }
        catch (IOException iOException) {
            throw this.to_COMM_FAILURE(iOException);
        }
    }

    public boolean is_data_available() {
        try {
            return this.in_stream.available() > 0;
        }
        catch (IOException iOException) {
            throw this.to_COMM_FAILURE(iOException);
        }
    }
}

