/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.util;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.trading.util.QueryContainer;
import org.jacorb.trading.util.Semaphore;
import org.jacorb.trading.util.TimeoutThread;
import org.omg.CORBA.UserException;
import org.omg.CosTrading.Offer;

public class QueryPropagator
implements Configurable {
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger = null;
    private int m_idle_threads = 0;
    private int m_total_threads = 0;
    private Semaphore m_idle_threads_sema = new Semaphore();
    private QueryContainer m_new_query;
    private Semaphore m_query_cons = new Semaphore(0);
    private Semaphore m_query_prod = new Semaphore();
    private int m_max_threads = 10;
    private int m_min_threads = 5;
    private int m_query_timeout = 60000;
    private TimeoutThread m_timer = new TimeoutThread(this.m_query_timeout);
    private static int threadc = 0;
    private int m_debug_verbosity = 2;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.trading");
        this.m_max_threads = this.configuration.getAttributeAsInteger("jtrader.util.max_threads", 10);
        this.m_min_threads = this.configuration.getAttributeAsInteger("jtrader.util.min_threads", 1);
        this.m_query_timeout = this.configuration.getAttributeAsInteger("jtrader.util.query_timeout", 60000);
    }

    public void putWork(QueryContainer queryContainer) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Put work (waiting): query(" + queryContainer.no + ")");
        }
        this.m_query_prod.P();
        boolean bl = this.m_idle_threads < this.m_min_threads && this.m_total_threads < this.m_max_threads;
        this.m_new_query = queryContainer;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Put work (got P) query(" + this.m_new_query.no + ")");
        }
        this.m_query_cons.V();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("left put work: query(" + this.m_new_query.no + ")");
        }
        if (bl) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Not enough Threads: " + this.m_idle_threads);
            }
            QueryThread queryThread = new QueryThread(this.m_timer);
        }
    }

    static /* synthetic */ int access$008() {
        return threadc++;
    }

    private class QueryThread
    extends Thread {
        private QueryContainer m_query = null;
        private int no = QueryPropagator.access$008();
        private TimeoutThread m_timer;

        public QueryThread(TimeoutThread timeoutThread) {
            QueryPropagator.this.m_total_threads++;
            this.m_timer = timeoutThread;
            this.start();
        }

        public void run() {
            while (true) {
                QueryPropagator.this.m_idle_threads++;
                this.getWork();
                this.executeQuery();
            }
        }

        private synchronized void executeQuery() {
            try {
                this.m_timer.setTimeout(this);
                this.m_query.m_target.query(this.m_query.m_type, this.m_query.m_constr, this.m_query.m_pref, this.m_query.m_policies, this.m_query.m_desired_props, this.m_query.m_how_many, this.m_query.m_offers, this.m_query.m_offer_itr, this.m_query.m_limits_applied);
                this.m_timer.stopTimer(this);
            }
            catch (UserException userException) {
                this.m_query.m_exception = userException;
                this.m_query.m_offers.value = new Offer[0];
                this.m_query.m_limits_applied.value = new String[0];
            }
            catch (Exception exception) {
                this.m_query.m_offers.value = new Offer[0];
                this.m_query.m_limits_applied.value = new String[0];
            }
            this.m_query.m_mutex.V();
            this.m_query = null;
        }

        private void getWork() {
            QueryPropagator.this.m_query_cons.P();
            this.m_query = QueryPropagator.this.m_new_query;
            QueryPropagator.this.m_idle_threads--;
            QueryPropagator.this.m_query_prod.V();
        }
    }
}

