/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.LoggerModule;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class MSAAppender
extends AppenderSkeleton {
    boolean append;
    String basePattern = "msa.bms.";
    String filePattern = "'.'yyyyMMdd";
    String rollPattern = "D";
    String freqPattern = null;
    File file = null;
    FileWriter fw = null;
    String lastWriteDay = "";
    SimpleDateFormat rollData;
    SimpleDateFormat filedate;
    Date date = new Date();

    public MSAAppender() {
        this.rollData = new SimpleDateFormat(this.rollPattern);
        this.rollData.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.filedate = new SimpleDateFormat(this.filePattern);
        this.filedate.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    protected void append(LoggingEvent le) {
        block9: {
            FileWriter oldfw = null;
            this.date.setTime(System.currentTimeMillis());
            String rollSig = this.rollData.format(this.date);
            if (this.lastWriteDay.compareTo(this.rollData.format(this.date)) != 0) {
                String filename = this.basePattern + this.filedate.format(this.date);
                LogLog.debug((String)("New msa file is " + filename));
                oldfw = this.fw;
                try {
                    this.file = new File(filename);
                    try {
                        this.fw = new FileWriter(this.file, true);
                    }
                    catch (IOException e1) {
                        LogLog.error((String)("Unable to create new file : " + filename));
                        oldfw = null;
                        throw e1;
                    }
                    this.lastWriteDay = rollSig;
                    if (oldfw == null) break block9;
                    try {
                        oldfw.close();
                    }
                    catch (IOException e2) {
                        LogLog.error((String)"Unable to close old file");
                        throw e2;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            this.fw.write(this.layout.format(le));
            this.fw.flush();
        }
        catch (IOException e) {
            LogLog.error((String)"Error writing to log file.");
        }
    }

    public void close() {
        LogLog.debug((String)"close()");
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    public boolean requiresLayout() {
        LogLog.debug((String)"requiresLayout()");
        return true;
    }

    public void setFileBase(String file) {
        LogLog.debug((String)"setFileBase()");
        this.basePattern = file;
    }

    public void setFilePattern(String pattern) {
        LogLog.debug((String)"setFilePattern()");
        this.filePattern = pattern;
        this.filedate = new SimpleDateFormat(this.filePattern);
        this.filedate.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void setRollPattern(String pattern) {
        LogLog.debug((String)"setRollPattern()");
        this.rollPattern = pattern;
        this.rollData = new SimpleDateFormat(this.rollPattern);
        this.rollData.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

