/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.LoggerModule.log4j;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public final class GMTPatternParser
extends PatternParser {
    private static final String DEFAULT_PTRN = "MMddyyyy HHmmss.SSS";
    private static final char DATE_CHAR = 'd';

    public GMTPatternParser(String pattern) {
        super(pattern);
    }

    public void finalizeConverter(char formatChar) {
        GMTPatternConverter pc = null;
        switch (formatChar) {
            case 'd': {
                pc = new GMTPatternConverter(this.formattingInfo, this.extractOption());
                this.currentLiteral.setLength(0);
                this.addConverter(pc);
                break;
            }
            default: {
                super.finalizeConverter(formatChar);
            }
        }
    }

    private static class GMTPatternConverter
    extends PatternConverter {
        private SimpleDateFormat gmtSdf = null;
        private Date date = new Date();

        public GMTPatternConverter(FormattingInfo formattingInfo, String pattern) {
            super(formattingInfo);
            this.initFormatters(pattern);
        }

        private void initFormatters(String ptrn) {
            this.gmtSdf = null;
            String gmtptrn = ptrn == null ? GMTPatternParser.DEFAULT_PTRN : ptrn;
            this.gmtSdf = new SimpleDateFormat(gmtptrn);
            this.gmtSdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        public String convert(LoggingEvent event) {
            this.date.setTime(event.timeStamp);
            return this.gmtSdf.format(this.date);
        }
    }
}

