/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.transform.Templates;
import javax.xml.transform.sax.TemplatesHandler;
import oracle.xml.jaxp.JXEntityResolver;
import oracle.xml.jdwp.LineTable;
import oracle.xml.jdwp.VariableTable;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.util.FastVector;
import oracle.xml.util.XMLError;
import oracle.xml.util.XMLUtil;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLApplyImport;
import oracle.xml.xslt.XSLApplyTemplates;
import oracle.xml.xslt.XSLAttribute;
import oracle.xml.xslt.XSLAttributeSet;
import oracle.xml.xslt.XSLCallTemplate;
import oracle.xml.xslt.XSLCharacterMap;
import oracle.xml.xslt.XSLCondition;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLCopy;
import oracle.xml.xslt.XSLCopyOf;
import oracle.xml.xslt.XSLDocument;
import oracle.xml.xslt.XSLElement;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLFallback;
import oracle.xml.xslt.XSLForEach;
import oracle.xml.xslt.XSLForEachGroup;
import oracle.xml.xslt.XSLFunction;
import oracle.xml.xslt.XSLKey;
import oracle.xml.xslt.XSLMiscElements;
import oracle.xml.xslt.XSLNamespace2;
import oracle.xml.xslt.XSLNextMatch;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLNumber;
import oracle.xml.xslt.XSLOtherElements;
import oracle.xml.xslt.XSLOutput;
import oracle.xml.xslt.XSLOutputCharacter;
import oracle.xml.xslt.XSLPerfSort;
import oracle.xml.xslt.XSLResultDocument;
import oracle.xml.xslt.XSLResultElement;
import oracle.xml.xslt.XSLSequence;
import oracle.xml.xslt.XSLSort;
import oracle.xml.xslt.XSLSortKey;
import oracle.xml.xslt.XSLSpaceElem;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTemplate;
import oracle.xml.xslt.XSLText;
import oracle.xml.xslt.XSLValueOf;
import oracle.xml.xslt.XSLVariable;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSLBuilder
extends DefaultHandler
implements XSLConstants,
TemplatesHandler {
    private int classID = 0;
    private int methodID = 1;
    private int dmethodID = -1;
    private boolean fixedXss;
    private boolean compat2029 = false;
    private XSLStylesheet xss;
    private XSLNode xssRoot;
    private URL baseURL;
    private String baseStr;
    private Stack xbases = new Stack();
    private URL xssURL;
    private Stack<String> impNinc;
    private XMLError err;
    private Locator locator;
    private EntityResolver entityResolver;
    private FastVector nodeStack;
    private XSLNode currentNode;
    private int contentMode;
    private int importLevel;
    private int importPriority;
    private int skipTopLevel;
    private int includeProcessing;
    private int xsltversion;
    private int version;
    private boolean bkwdCompFlag;
    private boolean fwdCompFlag;
    private boolean isSecure;
    int codeIndex = 0;

    public XSLBuilder() {
        this.nodeStack = new FastVector(16);
        this.contentMode = 0;
    }

    XSLBuilder(XSLStylesheet xSLStylesheet) {
        this.xss = xSLStylesheet;
        this.fixedXss = true;
        this.nodeStack = new FastVector(16);
        this.contentMode = 0;
    }

    public XSLStylesheet getStylesheet() throws XSLException {
        this.xss.setSecure(this.isSecure ? Boolean.TRUE : Boolean.FALSE);
        return this.xss;
    }

    public void reset() {
        if (!this.fixedXss) {
            this.xss = null;
        }
        this.locator = null;
        this.nodeStack.setSize(0);
        this.currentNode = null;
        this.contentMode = 0;
        this.importLevel = 0;
        this.importPriority = 0;
        this.skipTopLevel = 0;
        this.includeProcessing = 0;
        this.bkwdCompFlag = false;
        this.fwdCompFlag = false;
        this.impNinc = null;
    }

    public void setBaseURL(URL uRL) {
        this.xssURL = this.baseURL = uRL;
    }

    public void setError(XMLError xMLError) {
        this.err = xMLError;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setSecure(boolean bl) {
        this.isSecure = bl;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        try {
            if (this.includeProcessing == 0) {
                if (this.err == null) {
                    this.err = new XMLError();
                }
                if (this.xss == null) {
                    this.xss = new XSLStylesheet();
                }
                this.xss.set2029Compatibility(this.compat2029);
            }
            this.xssRoot = new XSLNode(this.xss);
            this.xssRoot.elementType = 1;
            this.xssRoot.xssImportPriority = this.importPriority;
            this.xssRoot.setLocalName("stylesheet");
            if (this.xss.getXSLDebugProp().debug()) {
                this.methodID = 1;
            }
            if (this.includeProcessing > 0) {
                return;
            }
            this.xss.err = this.err;
            this.nodeStack.addElement(this.xss);
            if (this.locator != null) {
                this.err.setLocator(this.locator);
                this.xss.setDebugInfo(this.locator.getLineNumber(), this.locator.getColumnNumber(), this.locator.getSystemId());
            }
            this.currentNode = this.xss;
            this.contentMode = 0;
        }
        catch (XSLException xSLException) {
            throw new SAXException(xSLException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.xss.appendChild(this.xssRoot);
            if (this.xss.getXSLDebugProp().debug()) {
                this.methodID = 1;
            }
            if (this.includeProcessing > 0) {
                this.importPriority = this.xssRoot.xssImportPriority;
                return;
            }
            this.xss.endContent();
        }
        catch (XSLException xSLException) {
            throw new SAXException(xSLException);
        }
        catch (XQException xQException) {
            throw new SAXException(xQException);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            XSLNode xSLNode = null;
            if (this.skipTopLevel > 0) {
                ++this.skipTopLevel;
                return;
            }
            switch (this.contentMode) {
                case 3: 
                case 8: {
                    break;
                }
                case 0: {
                    xSLNode = this.processStylesheetRoot(string, string2, string3, attributes);
                    break;
                }
                case 1: {
                    xSLNode = this.processImport(string, string2, attributes);
                    if (xSLNode != null) break;
                }
                case 2: {
                    xSLNode = this.createTopLevelInstruction(string, string2, attributes);
                    if (xSLNode != null) break;
                    if (this.version == 10) {
                        return;
                    }
                    this.xbases.push(this.baseURL);
                    return;
                }
                case 6: {
                    xSLNode = this.createMiscTemplateInstruction(string, string2);
                    if (xSLNode != null) break;
                }
                case 7: {
                    xSLNode = this.createTemplateInstruction(string, string2);
                    if (xSLNode != null) break;
                }
                case 5: {
                    xSLNode = this.createCharTemplateInstruction(string, string2);
                    if (xSLNode != null) break;
                }
                case 4: {
                    xSLNode = this.createMiscTemplateElement(string, string2);
                }
            }
            if (xSLNode == null) {
                xSLNode = new XSLNode(this.xss);
                xSLNode.elementType = 7;
                String string4 = this.currentNode.getQualifiedName();
                String string5 = this.currentNode.getLocalName();
                if (string5.equals("template") && string2.equals("param") || string5.equals("for-each") && string2.equals("sort") || string5.equals("for-each-group") && string2.equals("sort") || string5.equals("perform-sort") && string2.equals("sort")) {
                    this.err.error2(1048, 2, string3, string4);
                } else {
                    this.err.error2(1029, 2, string3, string4);
                    xSLNode.setErrorId(1047, 1, 2);
                    xSLNode.addErrorParam(0, string3);
                    xSLNode.addErrorParam(1, string4);
                }
            }
            xSLNode.setURI(string);
            xSLNode.setPrefix(XMLUtil.getPrefix(string3));
            xSLNode.setLocalName(string2);
            this.pushXSLNode(xSLNode);
            this.processAttributes(xSLNode, attributes);
            xSLNode.startContent();
            this.contentMode = xSLNode.getElementType();
            this.pushBaseURL(xSLNode, string, string2);
            if (this.xss.getXSLDebugProp().debug()) {
                ++this.codeIndex;
                XSLJDWPUtil.printTrace(this.xss.dbgProp, "XSLBuilder.startElement: " + string2 + " is: " + xSLNode.getLineNumber() + ":" + this.codeIndex);
                xSLNode.setCodeIndexBegin(this.codeIndex);
                this.addMethodID(xSLNode);
                this.addGlobalLineVarTableData(xSLNode.getLineNumber(), string, string2, xSLNode, true);
                this.addLineTableData(xSLNode.getLineNumber(), string, string2, xSLNode, true);
                this.addVariableTableData(xSLNode, string, string2);
            }
        }
        catch (XSLException xSLException) {
            throw new SAXException(xSLException);
        }
        catch (XQException xQException) {
            throw new SAXException(xQException);
        }
    }

    private void pushBaseURL(XSLNode xSLNode, String string, String string2) {
        if (this.version == 10) {
            return;
        }
        URL uRL = xSLNode.getXBaseURL();
        this.baseURL = uRL != null ? uRL : (this.xbases.size() > 0 ? (URL)this.xbases.peek() : this.xssURL);
        this.xbases.push(this.baseURL);
        xSLNode.setBaseURL(this.baseURL);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.skipTopLevel > 0) {
            --this.skipTopLevel;
            return;
        }
        try {
            this.currentNode.endContent();
            if (this.xss.getXSLDebugProp().debug()) {
                if (this.locator != null) {
                    this.currentNode.setEndingLineNumber(this.locator.getLineNumber());
                }
                ++this.codeIndex;
                XSLJDWPUtil.printTrace(this.xss.dbgProp, "XSLBuilder.endElement: " + string2 + " is: " + this.currentNode.getEndingLineNumber() + ":" + this.codeIndex);
                this.currentNode.setCodeIndexEnd(this.codeIndex);
                this.addGlobalLineVarTableData(this.currentNode.getEndingLineNumber(), string, string2, this.currentNode, false);
                this.addLineTableData(this.currentNode.getEndingLineNumber(), string, string2, this.currentNode, false);
                this.processMethodEnd(this.currentNode);
            }
        }
        catch (XSLException xSLException) {
            throw new SAXException(xSLException);
        }
        catch (XQException xQException) {
            throw new SAXException(xQException);
        }
        int n = this.nodeStack.size();
        this.currentNode = (XSLNode)this.nodeStack.elementAt(n - 2);
        this.contentMode = this.currentNode.elementType;
        this.nodeStack.setSize(n - 1);
        if (this.version != 10) {
            this.xbases.pop();
        }
        this.version = this.currentNode.getXSLTVersion();
        this.bkwdCompFlag = this.currentNode.isBackwardCompatibilityMode();
        this.fwdCompFlag = this.currentNode.isForwardCompatibilityMode();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (this.skipTopLevel > 0) {
                return;
            }
            if (this.contentMode == 1 || this.contentMode == 2 || this.contentMode == 4 || this.contentMode == 3) {
                if (!XMLUtil.isWhiteSpace(cArray, n, n2)) {
                    this.err.error2(1029, 2, "text", this.currentNode.getQualifiedName());
                }
            } else {
                this.currentNode.appendText(cArray, n, n2);
            }
        }
        catch (XSLException xSLException) {
            throw new SAXException(xSLException);
        }
    }

    void setXSLTVersion(int n) {
        this.xsltversion = n;
    }

    void set2029Compatibility(boolean bl) {
        this.compat2029 = bl;
    }

    private XSLNode processStylesheetRoot(String string, String string2, String string3, Attributes attributes) throws XSLException, SAXException, XQException {
        String string4;
        XSLNode xSLNode = this.xssRoot;
        String string5 = "";
        if ("http://www.w3.org/1999/XSL/Transform".equals(string)) {
            if (!string2.equals("stylesheet") && !string2.equals("transform")) {
                this.err.error1(1001, 1, string3);
                return null;
            }
        } else {
            string5 = "http://www.w3.org/1999/XSL/Transform";
        }
        if ((string4 = attributes.getValue(string5, "version")) != null) {
            double d = new Double(string4);
            this.setCompatibilityFlags(d);
            if (this.includeProcessing == 0) {
                this.xss.setCompatibilityFlags(this.version, this.bkwdCompFlag, this.fwdCompFlag);
            }
        } else {
            String string6 = "version";
            if (string5.equals("http://www.w3.org/1999/XSL/Transform")) {
                string6 = "{http://www.w3.org/1999/XSL/Transform}:version";
            }
            this.err.error2(1009, 1, string6, string3);
        }
        if (!string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (string2.equalsIgnoreCase("html") && string.equals("")) {
                this.xss.output.setMethod("html");
            }
            this.xssRoot.setCompatibilityFlags(this.version, this.bkwdCompFlag, this.fwdCompFlag);
            XSLTemplate xSLTemplate = new XSLTemplate(this.xss);
            xSLTemplate.setAttribute("", "", "match", "/");
            xSLTemplate.setURI("http://www.w3.org/1999/XSL/Transform");
            xSLTemplate.setLocalName("template");
            xSLTemplate.startContent();
            xSLTemplate.endContent();
            this.xssRoot.appendChild(xSLTemplate);
            this.currentNode = xSLTemplate;
            this.contentMode = 7;
            xSLTemplate.elementType = 7;
            xSLNode = this.createTemplateInstruction(string, string2);
        }
        return xSLNode;
    }

    private void setCompatibilityFlags(double d) {
        if (this.xsltversion == 10) {
            this.version = 10;
            if (d > 1.0) {
                this.fwdCompFlag = true;
            }
        } else if (this.xsltversion == 20) {
            this.version = 20;
            if (d < 2.0) {
                this.bkwdCompFlag = true;
            } else if (d > 2.0) {
                this.fwdCompFlag = true;
            }
        } else if (d >= 2.0) {
            this.version = 20;
            if (d > 2.0) {
                this.fwdCompFlag = true;
            }
        } else {
            this.version = 10;
            if (d > 1.0) {
                this.fwdCompFlag = true;
            }
        }
    }

    private XSLNode createMiscTemplateInstruction(String string, String string2) throws XSLException {
        XSLNode xSLNode = null;
        String string3 = this.currentNode.getLocalName();
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (string3.equals("template") && string2.equals("param")) {
                xSLNode = new XSLVariable(this.xss, string2);
                if (this.xss.getXSLDebugProp().debug()) {
                    Long l;
                    String string4 = this.currentNode.baseURL.toString();
                    this.classID = this.xss.getJDWPVirtualMachine().getClassID(string4);
                    long l2 = ((long)this.classID << 32) + (long)this.methodID;
                    Hashtable hashtable = this.xss.getClassMethodParams();
                    Integer n = (Integer)hashtable.get(l = new Long(l2));
                    if (n == null) {
                        int n2 = 1;
                        hashtable.put(l, new Integer(n2));
                    } else {
                        int n3 = n;
                        hashtable.put(l, new Integer(++n3));
                    }
                }
            } else if (string3.equals("for-each") && string2.equals("sort")) {
                xSLNode = new XSLSort(this.xss);
            } else if (this.version >= 20 && string3.equals("for-each-group") && string2.equals("sort")) {
                xSLNode = new XSLSort(this.xss);
            } else if (this.version >= 20 && string3.equals("function") && string2.equals("param")) {
                xSLNode = new XSLVariable(this.xss, string2);
            } else if (this.version >= 20 && string3.equals("perform-sort") && string2.equals("sort")) {
                xSLNode = new XSLSort(this.xss);
            }
        }
        if (xSLNode == null) {
            this.contentMode = 7;
            this.currentNode.elementType = 7;
        }
        return xSLNode;
    }

    private XSLNode createTemplateInstruction(String string, String string2) throws XSLException {
        XSLNode xSLNode = null;
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (string2.equals("attribute")) {
                xSLNode = new XSLAttribute(this.xss);
            } else if (string2.equals("element")) {
                xSLNode = new XSLElement(this.xss);
            } else if (string2.equals("sequence") && this.version >= 20) {
                xSLNode = new XSLSequence(this.xss);
            } else if (string2.equals("document") && this.version >= 20) {
                xSLNode = new XSLDocument(this.xss);
            } else if (string2.equals("result-document") && this.version >= 20) {
                xSLNode = new XSLResultDocument(this.xss);
            } else if (string2.equals("namespace") && this.version >= 20) {
                xSLNode = new XSLNamespace2(this.xss);
            } else if (string2.equals("processing-instruction") || string2.equals("comment")) {
                xSLNode = new XSLMiscElements(string2, this.xss);
            }
        } else {
            xSLNode = new XSLResultElement(this.xss);
        }
        return xSLNode;
    }

    private XSLNode createCharTemplateInstruction(String string, String string2) throws XSLException {
        XSLNode xSLNode = null;
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (string2.equals("text")) {
                xSLNode = new XSLText(this.xss);
            } else if (string2.equals("message")) {
                xSLNode = new XSLMiscElements(string2, this.xss);
            } else if (string2.equals("apply-imports")) {
                xSLNode = new XSLApplyImport(this.xss);
            } else if (string2.equals("next-match") && this.version >= 20) {
                xSLNode = new XSLNextMatch(this.xss);
            } else if (string2.equals("apply-templates")) {
                xSLNode = new XSLApplyTemplates(this.xss);
            } else if (string2.equals("for-each")) {
                xSLNode = new XSLForEach(this.xss);
            } else if (string2.equals("for-each-group") && this.version >= 20) {
                xSLNode = new XSLForEachGroup(this.xss);
            } else if (string2.equals("perform-sort") && this.version >= 20) {
                xSLNode = new XSLPerfSort(this.xss);
            } else if (string2.equals("call-template")) {
                xSLNode = new XSLCallTemplate(this.xss);
            } else if (string2.equals("copy")) {
                xSLNode = new XSLCopy(this.xss);
            } else if (string2.equals("copy-of")) {
                xSLNode = new XSLCopyOf(this.xss);
            } else if (string2.equals("value-of")) {
                xSLNode = new XSLValueOf(this.xss);
            } else if (string2.equals("number")) {
                xSLNode = new XSLNumber(this.xss);
            } else if (string2.equals("choose") || string2.equals("if")) {
                xSLNode = new XSLCondition(this.xss);
            } else if (string2.equals("variable")) {
                xSLNode = new XSLVariable(this.xss, string2);
            } else if (string2.equals("fallback")) {
                xSLNode = new XSLFallback(this.xss);
            } else if (this.fwdCompFlag) {
                xSLNode = new XSLOtherElements(this.xss);
            }
        }
        return xSLNode;
    }

    private XSLNode createMiscTemplateElement(String string, String string2) throws XSLException {
        XSLNode xSLNode = null;
        String string3 = this.currentNode.getLocalName();
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (string3.equals("apply-templates")) {
                if (string2.equals("with-param")) {
                    xSLNode = new XSLVariable(this.xss, string2);
                } else if (string2.equals("sort")) {
                    xSLNode = new XSLSort(this.xss);
                }
            } else if (this.version >= 20 && string3.equals("apply-imports") && string2.equals("with-param")) {
                xSLNode = new XSLVariable(this.xss, string2);
            } else if (this.version >= 20 && string3.equals("next-match") && string2.equals("with-param")) {
                xSLNode = new XSLVariable(this.xss, string2);
            } else if (string3.equals("call-template") && string2.equals("with-param")) {
                xSLNode = new XSLVariable(this.xss, string2);
            } else if (string3.equals("choose")) {
                if (string2.equals("when") || string2.equals("otherwise")) {
                    xSLNode = new XSLCondition(this.xss);
                }
            } else if (string3.equals("attribute-set") && string2.equals("attribute")) {
                xSLNode = new XSLAttribute(this.xss);
            } else if (string3.equals("sort-key") && this.version >= 20) {
                if (string2.equals("sort")) {
                    xSLNode = new XSLSort(this.xss);
                }
            } else if (string3.equals("character-map")) {
                if (string2.equals("output-character")) {
                    xSLNode = new XSLOutputCharacter(this.xss);
                }
            } else if (this.currentNode instanceof XSLOtherElements && string2.equals("fallback")) {
                xSLNode = new XSLFallback(this.xss);
            }
        } else if (string.equals("http://www.oracle.com/XSL/Transform/java") && string3.equals("extlib") && string2.equals("element")) {
            xSLNode = new XSLNode(this.xss);
        }
        return xSLNode;
    }

    private XSLNode createTopLevelInstruction(String string, String string2, Attributes attributes) throws XSLException, SAXException {
        XSLNode xSLNode = null;
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (string2.equals("import")) {
                xSLNode = this.processImport(string, string2, attributes);
                this.err.error2(1048, 1, string2, "stylesheet");
            } else if (string2.equals("include")) {
                xSLNode = this.processInclude(string, string2, attributes);
            } else if (string2.equals("template")) {
                xSLNode = new XSLTemplate(this.xss);
                xSLNode.setBaseURL(this.baseURL);
                ((XSLTemplate)xSLNode).importLevel = this.importLevel;
                ((XSLTemplate)xSLNode).importPriority = this.xssRoot.xssImportPriority;
            } else if (string2.equals("variable") || string2.equals("param")) {
                xSLNode = new XSLVariable(this.xss, string2);
                xSLNode.setBaseURL(this.baseURL);
            } else if (string2.equals("attribute-set")) {
                xSLNode = new XSLAttributeSet(this.xss);
            } else if (string2.equals("key")) {
                xSLNode = new XSLKey(this.xss);
            } else if (string2.equals("strip-space") || string2.equals("preserve-space")) {
                xSLNode = new XSLSpaceElem(this.xss, string2);
                ((XSLSpaceElem)xSLNode).importPriority = this.xssRoot.xssImportPriority;
            } else if (string2.equals("output")) {
                xSLNode = new XSLOutput(this.xss);
            } else if (string2.equals("namespace-alias")) {
                xSLNode = new XSLNode(this.xss);
            } else if (string2.equals("decimal-format")) {
                xSLNode = new XSLNode(this.xss);
            } else if (string2.equals("function") && this.version >= 20) {
                xSLNode = new XSLFunction(this.xss);
                ((XSLFunction)xSLNode).funcstruc.importprecedence = this.importLevel;
            } else if (string2.equals("sort-key") && this.version >= 20) {
                xSLNode = new XSLSortKey(this.xss);
            } else if (string2.equals("character-map") && this.version >= 20) {
                xSLNode = new XSLCharacterMap(this.xss);
                ((XSLCharacterMap)xSLNode).importLevel = this.importLevel;
            }
        } else if (string.equals("http://www.oracle.com/XSL/Transform/java")) {
            if (string2.equals("output")) {
                xSLNode = new XSLOutput(this.xss);
            } else if (string2.equals("extlib")) {
                xSLNode = new XSLNode(this.xss);
                xSLNode.elementType = 4;
            }
        }
        if (xSLNode == null) {
            ++this.skipTopLevel;
        }
        return xSLNode;
    }

    private void processAttributes(XSLNode xSLNode, Attributes attributes) throws XSLException, SAXException, XQException {
        String string;
        String string2;
        String string3;
        String string4;
        int n;
        int n2 = attributes.getLength();
        for (n = 0; n < n2; ++n) {
            string4 = ((SAXAttrList)attributes).getPrefix(n);
            string3 = attributes.getLocalName(n);
            string2 = attributes.getURI(n);
            string = attributes.getValue(n);
            if (string4.equals("xmlns")) {
                xSLNode.addNamespace(string3, string.intern());
                continue;
            }
            if (string3.equals("xmlns")) {
                xSLNode.addNamespace("#default", string.intern());
                continue;
            }
            if (this.version < 20 || !string3.equals("xpath-default-namespace")) continue;
            xSLNode.addNamespace("#xpath-default-namespace", string.intern());
        }
        for (n = 0; n < n2; ++n) {
            string4 = ((SAXAttrList)attributes).getPrefix(n);
            string3 = attributes.getLocalName(n);
            string2 = attributes.getURI(n);
            string = attributes.getValue(n);
            if (!(string4.equals("xmlns") || string3.equals("xmlns") || string3.equals("xpath-default-namespace"))) {
                xSLNode.setAttribute(string2.intern(), string4.intern(), string3.intern(), string.intern());
            }
            if (!string3.equals("version") || xSLNode.getLocalName().equals("output")) continue;
            String string5 = xSLNode.getURI();
            if ((!string2.equals("") || !string5.equals("http://www.w3.org/1999/XSL/Transform")) && (string2.equals("http://www.w3.org/1999/XSL/Transform") || string5.equals("http://www.w3.org/1999/XSL/Transform"))) continue;
            double d = new Double(string);
            this.setCompatibilityFlags(d);
            xSLNode.setCompatibilityFlags(this.version, this.bkwdCompFlag, this.fwdCompFlag);
        }
        if (this.version == 10 && xSLNode.prefixHash != null) {
            xSLNode.prefixHash.put("#xpath-default-namespace", "");
        }
    }

    private XSLNode processImport(String string, String string2, Attributes attributes) throws XSLException, SAXException {
        XSLNode xSLNode = null;
        if (string.equals("http://www.w3.org/1999/XSL/Transform") && string2.equals("import")) {
            String string3;
            xSLNode = new XSLNode(this.xss);
            String string4 = string3 = attributes.getValue("href");
            if (string3 != null) {
                URL uRL = this.getAbsoluteURL(attributes, this.xssURL, string3);
                if (uRL != null) {
                    string4 = uRL.toString();
                } else if (this.entityResolver == null) {
                    this.err.error1(1006, 1, string3);
                }
                if (this.impNinc == null) {
                    this.impNinc = new Stack();
                }
                if (this.xssURL != null && string4.equals(this.xssURL.toString()) || this.impNinc.contains(string4)) {
                    this.err.error2(1123, 0, uRL.toString(), "xsl:import or xsl:include");
                    throw new XSLException(this.err, 0);
                }
                this.impNinc.push(string4);
                this.processImportHref(string3, attributes);
                this.impNinc.pop();
            } else {
                this.err.error2(1009, 1, "href", "xsl:import");
            }
        } else {
            this.xssRoot.elementType = 2;
            this.contentMode = 2;
        }
        return xSLNode;
    }

    private XSLNode processInclude(String string, String string2, Attributes attributes) throws XSLException, SAXException {
        XSLNode xSLNode = null;
        if (string.equals("http://www.w3.org/1999/XSL/Transform") && string2.equals("include")) {
            String string3;
            xSLNode = new XSLNode(this.xss);
            String string4 = string3 = attributes.getValue("href");
            if (string3 != null) {
                URL uRL = this.getAbsoluteURL(attributes, this.xssURL, string3);
                if (uRL != null) {
                    string4 = uRL.toString();
                } else if (this.entityResolver == null) {
                    this.err.error1(1006, 1, string3);
                }
                if (this.impNinc == null) {
                    this.impNinc = new Stack();
                }
                if (this.xssURL != null && string4.equals(this.xssURL.toString()) || this.impNinc.contains(string4)) {
                    this.err.error2(1123, 0, uRL.toString(), "xsl:import or xsl:include");
                    throw new XSLException(this.err, 0);
                }
                this.impNinc.push(string4);
                this.processIncludeHref(string3, attributes);
                this.impNinc.pop();
            } else {
                this.err.error2(1009, 1, "href", "xsl:include");
            }
        }
        return xSLNode;
    }

    private void processImportHref(String string, Attributes attributes) throws SAXException {
        int n = this.importPriority++;
        ++this.importLevel;
        this.processIncludeHref(string, attributes);
        --this.importLevel;
    }

    private URL getAbsoluteURL(Attributes attributes, URL uRL, String string) throws SAXException {
        URL uRL2 = null;
        try {
            Object object;
            if (this.version >= 20 && (object = attributes.getValue("xml:base")) != null) {
                uRL = new URL(uRL, (String)object);
            }
            if (this.entityResolver != null && this.entityResolver instanceof JXEntityResolver) {
                object = this.entityResolver.resolveEntity("", string);
                uRL2 = new URL(uRL, ((InputSource)object).getSystemId());
            }
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            this.err.setException(iOException);
            this.err.error1(1002, 0, string);
        }
        return uRL2;
    }

    private void processIncludeHref(String string, Attributes attributes) throws SAXException {
        boolean bl;
        int n;
        URL uRL;
        Locator locator;
        XSLNode xSLNode;
        block15: {
            xSLNode = this.xssRoot;
            locator = this.locator;
            uRL = this.baseURL;
            n = this.contentMode;
            bl = false;
            ++this.includeProcessing;
            try {
                Object object;
                if (this.version >= 20 && (object = attributes.getValue("xml:base")) != null) {
                    this.baseURL = new URL(this.baseURL, (String)object);
                }
                object = new SAXParser();
                ((XMLParser)object).setPreserveWhitespace(true);
                ((SAXParser)object).setContentHandler(this);
                this.contentMode = 0;
                if (this.entityResolver != null) {
                    InputSource inputSource;
                    if (this.entityResolver instanceof JXEntityResolver) {
                        if (this.version >= 20) {
                            this.xbases.push(this.baseURL);
                            bl = true;
                        }
                        inputSource = this.entityResolver.resolveEntity("", string);
                    } else {
                        URL uRL2 = null;
                        try {
                            uRL2 = new URL(this.baseURL, string);
                            String string2 = uRL2.toString();
                            inputSource = this.entityResolver.resolveEntity("", string2);
                        }
                        catch (MalformedURLException malformedURLException) {
                            inputSource = this.entityResolver.resolveEntity("", string);
                            uRL2 = this.xbases.size() > 0 ? (URL)this.xbases.peek() : this.xssURL;
                        }
                        this.baseURL = uRL2;
                        ((XMLParser)object).setBaseURL(uRL2);
                        if (this.version >= 20) {
                            this.xbases.push(this.baseURL);
                            bl = true;
                        }
                    }
                    ((XMLParser)object).setEntityResolver(this.entityResolver);
                    ((XMLParser)object).parse(inputSource);
                    break block15;
                }
                if (!this.isSecure) {
                    URL uRL3;
                    this.baseURL = uRL3 = new URL(this.baseURL, string);
                    if (this.version >= 20) {
                        this.xbases.push(this.baseURL);
                        bl = true;
                    }
                    ((XMLParser)object).setBaseURL(uRL3);
                    ((XMLParser)object).parse(uRL3);
                } else {
                    this.err.error1(21028, 0, string);
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.err.setException(malformedURLException);
                this.err.error1(1002, 0, string);
            }
            catch (IOException iOException) {
                this.err.setException(iOException);
                this.err.error1(1002, 0, string);
            }
        }
        this.locator = locator;
        this.baseURL = uRL;
        this.xssRoot = xSLNode;
        this.contentMode = n;
        if (this.version >= 20 && bl) {
            this.xbases.pop();
        }
        --this.includeProcessing;
    }

    private void pushXSLNode(XSLNode xSLNode) throws XSLException {
        this.nodeStack.addElement(xSLNode);
        if (xSLNode != this.xssRoot) {
            this.currentNode.appendChild(xSLNode);
        }
        this.currentNode = xSLNode;
        if (this.locator != null) {
            xSLNode.setDebugInfo(this.locator.getLineNumber(), this.locator.getColumnNumber(), this.locator.getSystemId());
        }
    }

    private void addMethodID(XSLNode xSLNode) {
        String string;
        if (!(xSLNode instanceof XSLTemplate) && !(xSLNode instanceof XSLFunction)) {
            return;
        }
        String string2 = xSLNode.baseURL.toString();
        NSName nSName = xSLNode instanceof XSLTemplate ? ((XSLTemplate)xSLNode).templateNSName : ((XSLFunction)xSLNode).funcstruc.funcqname;
        ++this.methodID;
        this.classID = this.xss.getJDWPVirtualMachine().getClassID(string2);
        if (nSName != null) {
            string = nSName.getExpandedName();
        } else {
            this.dmethodID = this.dmethodID == -1 ? 2 : ++this.dmethodID;
            string = "$$" + new Integer(this.dmethodID).toString();
        }
        XSLJDWPUtil.printTrace(this.xss.dbgProp, "methodID: " + this.classID + ":" + this.methodID + " -> " + string + " " + string2);
        Hashtable[] hashtableArray = this.xss.getClassID2methodID();
        Hashtable[] hashtableArray2 = this.xss.getClassID2methodName();
        hashtableArray = XSLJDWPUtil.ensureHashtableSize(hashtableArray, this.classID);
        hashtableArray2 = XSLJDWPUtil.ensureHashtableSize(hashtableArray2, this.classID);
        Hashtable hashtable = hashtableArray[this.classID - 1];
        Hashtable hashtable2 = hashtableArray2[this.classID - 1];
        if (hashtable == null) {
            hashtable = new Hashtable();
            hashtable.put(new Integer(this.methodID), string);
            hashtableArray[this.classID - 1] = hashtable;
        } else {
            hashtable = hashtableArray[this.classID - 1];
            hashtable.put(new Integer(this.methodID), string);
        }
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
            hashtable2.put(string, new Integer(this.methodID));
            hashtableArray2[this.classID - 1] = hashtable2;
        } else {
            hashtable2 = hashtableArray2[this.classID - 1];
            hashtable2.put(string, new Integer(this.methodID));
        }
        this.xss.setClassID2methodID(hashtableArray);
        this.xss.setClassID2methodName(hashtableArray2);
        LineTable lineTable = new LineTable(this.classID, this.methodID, this.xss);
        lineTable.setStart(this.codeIndex);
        lineTable.setStartLine(xSLNode.getLineNumber());
        this.xss.lineTables.push(lineTable);
        VariableTable variableTable = new VariableTable(this.classID, this.methodID, this.xss, this.codeIndex);
        this.xss.variableTables.push(variableTable);
    }

    private void addGlobalMethodID() {
        Hashtable[] hashtableArray = this.xss.getClassID2methodID();
        Hashtable[] hashtableArray2 = this.xss.getClassID2methodName();
        hashtableArray = XSLJDWPUtil.ensureHashtableSize(hashtableArray, this.classID);
        hashtableArray2 = XSLJDWPUtil.ensureHashtableSize(hashtableArray2, this.classID);
        Hashtable hashtable = hashtableArray[this.classID - 1];
        Hashtable hashtable2 = hashtableArray2[this.classID - 1];
        if (hashtable == null) {
            hashtable = new Hashtable();
            hashtable.put(new Integer(1), "$$1");
            hashtableArray[this.classID - 1] = hashtable;
        } else {
            hashtable = hashtableArray[this.classID - 1];
            hashtable.put(new Integer(1), "$$1");
        }
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
            hashtable2.put("$$1", new Integer(1));
            hashtableArray2[this.classID - 1] = hashtable2;
        } else {
            hashtable2 = hashtableArray2[this.classID - 1];
            hashtable2.put("$$1", new Integer(1));
        }
        this.xss.setClassID2methodID(hashtableArray);
        this.xss.setClassID2methodName(hashtableArray2);
    }

    private void addGlobalLineVarTableData(int n, String string, String string2, XSLNode xSLNode, boolean bl) {
        VariableTable variableTable;
        LineTable lineTable;
        if (!string.equals("http://www.w3.org/1999/XSL/Transform")) {
            return;
        }
        if (string2.equals("transform") || string2.equals("stylesheet")) {
            if (bl) {
                String string3 = xSLNode.getSystemId();
                this.classID = this.xss.getJDWPVirtualMachine().getClassID(string3);
                this.addGlobalMethodID();
                lineTable = new LineTable(this.classID, 1, this.xss);
                lineTable.setStart(this.codeIndex);
                lineTable.setStartLine(xSLNode.getLineNumber());
                lineTable.setCodeIndexLineNumber(this.codeIndex, xSLNode.getLineNumber());
                this.xss.glbLineTable.push(lineTable);
                variableTable = new VariableTable(this.classID, 1, this.xss, this.codeIndex);
                this.xss.glbVarTable.push(variableTable);
            } else {
                lineTable = (LineTable)this.xss.glbLineTable.pop();
                lineTable.setEnd(this.codeIndex);
                lineTable.setEndLine(xSLNode.getEndingLineNumber());
                lineTable.setCodeIndexLineNumber(this.codeIndex, xSLNode.getEndingLineNumber());
                lineTable.notifyEnd();
                variableTable = (VariableTable)this.xss.glbVarTable.pop();
                variableTable.setEndCodeIndex(this.codeIndex);
                variableTable.notifyEnd();
            }
        }
        if (string2.equals("variable") && bl && string.equals("http://www.w3.org/1999/XSL/Transform") && (xSLNode.parent.localName.equals("transform") || xSLNode.parent.localName.equals("stylesheet"))) {
            lineTable = (LineTable)this.xss.glbLineTable.peek();
            lineTable.setCodeIndexLineNumber(this.codeIndex, n);
            variableTable = (VariableTable)this.xss.glbVarTable.peek();
            variableTable.set(this.codeIndex, (XSLVariable)xSLNode);
        }
    }

    private void addLineTableData(int n, String string, String string2, XSLNode xSLNode, boolean bl) {
        if (this.xss.lineTables.empty()) {
            return;
        }
        if (string.equals("http://www.w3.org/1999/XSL/Transform") && (string2.equals("with-param") || string2.equals("param"))) {
            return;
        }
        LineTable lineTable = (LineTable)this.xss.lineTables.peek();
        if (n == lineTable.getLastVisitedLine()) {
            return;
        }
        lineTable.setCodeIndexLineNumber(this.codeIndex, n);
    }

    private void addVariableTableData(XSLNode xSLNode, String string, String string2) {
        if (!(xSLNode instanceof XSLVariable)) {
            return;
        }
        if (string.equals("http://www.w3.org/1999/XSL/Transform") && string2.equals("with-param")) {
            return;
        }
        if (xSLNode.parent.localName.equals("transform") || xSLNode.parent.localName.equals("stylesheet")) {
            return;
        }
        VariableTable variableTable = (VariableTable)this.xss.variableTables.peek();
        variableTable.set(this.codeIndex, (XSLVariable)xSLNode);
    }

    private void processMethodEnd(XSLNode xSLNode) {
        if (!(xSLNode instanceof XSLTemplate) && !(xSLNode instanceof XSLFunction)) {
            return;
        }
        LineTable lineTable = (LineTable)this.xss.lineTables.pop();
        lineTable.setEnd(this.codeIndex);
        lineTable.setEndLine(xSLNode.getEndingLineNumber());
        lineTable.notifyEnd();
        VariableTable variableTable = (VariableTable)this.xss.variableTables.pop();
        variableTable.setEndCodeIndex(this.codeIndex);
        variableTable.notifyEnd();
    }

    public Templates getTemplates() {
        try {
            return this.getStylesheet();
        }
        catch (XSLException xSLException) {
            return null;
        }
    }

    public void setSystemId(String string) {
        try {
            this.baseStr = string;
            if (string != null) {
                this.xssURL = this.baseURL = new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            if (this.err == null) {
                this.err = new XMLError();
            }
            this.err.setException(malformedURLException);
            this.err.error1(1002, 1, string);
        }
    }

    public String getSystemId() {
        if (this.baseURL != null) {
            return this.baseURL.toString();
        }
        return this.baseStr;
    }
}

