/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Locale;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import oracle.xml.jaxp.JXUtil;
import oracle.xml.jdwp.XSLDebugProp;
import oracle.xml.jdwp.XSLJDWPDebugger;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLContentHandler;
import oracle.xml.parser.v2.XMLDOMImplementation;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLDocumentHandler;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.scalable.PageManager;
import oracle.xml.util.NSNameImpl;
import oracle.xml.util.XMLUtil;
import oracle.xml.xpath.XPathException;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLBuilder;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLDocumentBuilder;
import oracle.xml.xslt.XSLEventHandler;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLOutput;
import oracle.xml.xslt.XSLSAXPrintDriver;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XSLProcessor
implements XSLConstants {
    URL baseURL;
    SAXParser parser;
    XSLBuilder xslBuilder;
    DocumentBuilder docBuilder;
    LexicalHandler lexHandler;
    XSLEventHandler eventHandler;
    XSLTContext context = new XSLTContext();
    Hashtable params;
    XMLError err;
    OutputStream errOut;
    boolean warnings;
    Locale errLocale;
    XSLDebugProp debugProp;
    boolean extencspecified = false;
    String extEncoding;
    Connection domConn;
    String domKind;
    boolean isJAXP = false;
    static XMLContentHandler sLexHandler = new XMLContentHandler();
    XSLOutput m_xslOutput = null;
    public static final String STREAMING_PROCESSING = "StreamingProcessing";
    public static final XSLTVersion XSLT10 = new XSLTVersion(10);
    public static final XSLTVersion XSLT20 = new XSLTVersion(20);

    public XSLProcessor() {
        this.parser = new SAXParser();
        this.xslBuilder = new XSLBuilder();
        this.docBuilder = new DocumentBuilder();
        this.eventHandler = new XSLEventHandler();
        this.lexHandler = sLexHandler;
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocument xMLDocument, ContentHandler contentHandler) throws XSLException {
        this.processXSL(xSLStylesheet, (XMLElement)xMLDocument, contentHandler);
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocument xMLDocument, XMLDocumentHandler xMLDocumentHandler) throws XSLException {
        XMLContentHandler xMLContentHandler = new XMLContentHandler(xMLDocumentHandler);
        this.lexHandler = xMLContentHandler;
        this.processXSL(xSLStylesheet, xMLDocument, (ContentHandler)xMLContentHandler);
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocument xMLDocument, OutputStream outputStream) throws XSLException, IOException {
        XSLSAXPrintDriver xSLSAXPrintDriver = this.getPrintHandler(xSLStylesheet, outputStream);
        this.lexHandler = xSLSAXPrintDriver;
        this.processXSL(xSLStylesheet, xMLDocument, (ContentHandler)xSLSAXPrintDriver);
        xSLSAXPrintDriver.flush();
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocument xMLDocument, PrintWriter printWriter) throws XSLException, IOException {
        XSLSAXPrintDriver xSLSAXPrintDriver = this.getPrintHandler(xSLStylesheet, printWriter);
        this.lexHandler = xSLSAXPrintDriver;
        this.processXSL(xSLStylesheet, xMLDocument, (ContentHandler)xSLSAXPrintDriver);
        xSLSAXPrintDriver.flush();
    }

    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, XMLDocument xMLDocument) throws XSLException {
        XSLDocumentBuilder xSLDocumentBuilder = "oracle.xml.parser.XMLDocument.THICK".equals(this.domKind) ? new XSLDocumentBuilder(this.domConn) : new XSLDocumentBuilder();
        XMLDocumentFragment xMLDocumentFragment = null;
        this.lexHandler = xSLDocumentBuilder;
        this.processXSL(xSLStylesheet, xMLDocument, (ContentHandler)xSLDocumentBuilder);
        xMLDocumentFragment = xSLDocumentBuilder.getResultFragment();
        return xMLDocumentFragment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processXSL(XSLStylesheet xSLStylesheet, XMLElement xMLElement, ContentHandler contentHandler) throws XSLException {
        XSLJDWPDebugger xSLJDWPDebugger = null;
        if (this.debugProp == null) {
            this.debugProp = new XSLDebugProp();
        }
        if (this.debugProp.debug()) {
            XSLJDWPUtil.printForTest("Debug properties set");
            xSLJDWPDebugger = new XSLJDWPDebugger(xSLStylesheet);
            xSLJDWPDebugger.setTransportType(this.debugProp.getTransport());
            xSLJDWPDebugger.setServer(this.debugProp.getServer());
            xSLJDWPDebugger.setHostName(this.debugProp.getHostname());
            xSLJDWPDebugger.setPort(this.debugProp.getPort());
            xSLJDWPDebugger.setSuspend(this.debugProp.getSuspend());
            xSLStylesheet.setSuspendFlag(this.debugProp.getSuspend());
            xSLJDWPDebugger.setErrorStream(this.errOut);
            xSLStylesheet.setJDWPDebugger(xSLJDWPDebugger);
            xSLJDWPDebugger.run();
        }
        try {
            block24: {
                try {
                    Object object;
                    this.init();
                    if (contentHandler instanceof LexicalHandler) {
                        this.lexHandler = (LexicalHandler)((Object)contentHandler);
                    }
                    this.eventHandler.reset(contentHandler, this.lexHandler, this.context);
                    if (XMLUtil.reportDocEvents(this.eventHandler, XMLParser.getReportedCHClasses())) {
                        this.eventHandler.startDocument();
                    }
                    if (xMLElement instanceof XMLDocument) {
                        if (xMLElement.isNodeFlag(2048) && !xSLStylesheet.precedingAxis && !xMLElement.isNodeFlag(0x200000)) {
                            object = new XMLDOMImplementation();
                            ((XMLDOMImplementation)object).setAttribute("oracle.xml.parser.XMLDocument.SCALABLE_DOM", Boolean.TRUE);
                            XMLDocument xMLDocument = (XMLDocument)((XMLDOMImplementation)object).createDocument(null);
                            XMLNode xMLNode = (XMLNode)((Object)xMLElement.getDocument().getDocumentElement());
                            for (XMLNode xMLNode2 = (XMLNode)xMLElement.getFirstChild(); xMLNode2 != null && !xMLNode2.equals(xMLNode); xMLNode2 = (XMLNode)xMLNode2.getNextSibling()) {
                                if (xMLNode2.getNodeType() != 8 && xMLNode2.getNodeType() != 7) continue;
                                xMLDocument.appendChild((XMLNode)xMLDocument.importNode((Node)xMLNode2, true));
                            }
                            xMLNode = (XMLNode)xMLDocument.importNode((Node)xMLNode, true);
                            xMLDocument.appendChild(xMLNode);
                            xMLElement = xMLDocument;
                            xMLElement.setNodeFlag(0x200000);
                        }
                        this.context.addSourceContext(xMLElement, (XMLDocument)xMLElement);
                    } else {
                        this.context.addSourceContext(xMLElement.getSrcRoot(), (XMLDocument)xMLElement.getOwnerDocument());
                    }
                    this.context.setEventHandler(this.eventHandler);
                    this.context.setContextSize(1);
                    this.context.setContextPosition(1);
                    this.context.setContextNode(xMLElement);
                    this.context.setCurrentNode(xMLElement);
                    this.context.setStyleSheet(xSLStylesheet);
                    this.context.setIsJAXP(this.isJAXP);
                    if (this.params != null) {
                        if (!this.debugProp.debug()) {
                            xSLStylesheet.execute(this.context, this.params);
                        } else {
                            this.context.setDebugMode(true);
                            this.context.setJDWPContentHandler(contentHandler);
                            xSLStylesheet.executeDebug(this.context, this.params, contentHandler);
                        }
                    } else if (!this.debugProp.debug()) {
                        xSLStylesheet.execute(this.context);
                    } else {
                        this.context.setDebugMode(true);
                        this.context.setJDWPContentHandler(contentHandler);
                        xSLStylesheet.executeDebug(this.context, contentHandler);
                    }
                    if (xMLElement instanceof XMLDocument && xMLElement.isNodeFlag(2048) && (object = ((XMLDocument)xMLElement).getInfosetReader()) != null) {
                        object.close();
                    }
                    if (!XMLUtil.reportDocEvents(this.eventHandler, XMLParser.getReportedCHClasses())) break block24;
                    this.eventHandler.endDocument();
                }
                catch (XSLException xSLException) {
                    if (!xSLException.getMessage().equals("TERMINATE PROCESSING")) {
                        throw xSLException;
                    }
                    Object var10_15 = null;
                    this.context.reset();
                    this.eventHandler.flushEvents();
                    this.eventHandler.reset(null, null, this.context);
                    this.lexHandler = sLexHandler;
                    return;
                }
                catch (XQException xQException) {
                    Exception exception = xQException.getException();
                    if (exception != null && exception instanceof XSLException && exception.getMessage().equals("TERMINATE PROCESSING")) {
                        throw (XSLException)exception;
                    }
                    String string = null;
                    String string2 = XMLError.getXPathErrorID(xQException.getErrorCode());
                    if (string2 == null) {
                        string = this.err.getMessage0(Integer.parseInt(string2));
                        throw new XSLException(string);
                    }
                    string = this.err.getMessage0(23002);
                    throw new XSLException(string);
                }
            }
            Object var10_14 = null;
            this.context.reset();
            this.eventHandler.flushEvents();
            this.eventHandler.reset(null, null, this.context);
            this.lexHandler = sLexHandler;
            return;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            this.context.reset();
            this.eventHandler.flushEvents();
            this.eventHandler.reset(null, null, this.context);
            this.lexHandler = sLexHandler;
            throw throwable;
        }
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLElement xMLElement, XMLDocumentHandler xMLDocumentHandler) throws XSLException {
        XMLContentHandler xMLContentHandler = new XMLContentHandler(xMLDocumentHandler);
        this.lexHandler = xMLContentHandler;
        this.processXSL(xSLStylesheet, xMLElement, (ContentHandler)xMLContentHandler);
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLElement xMLElement, OutputStream outputStream) throws XSLException, IOException {
        XSLSAXPrintDriver xSLSAXPrintDriver = this.getPrintHandler(xSLStylesheet, outputStream);
        this.lexHandler = xSLSAXPrintDriver;
        this.processXSL(xSLStylesheet, xMLElement, (ContentHandler)xSLSAXPrintDriver);
        xSLSAXPrintDriver.flush();
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLElement xMLElement, PrintWriter printWriter) throws XSLException, IOException {
        XSLSAXPrintDriver xSLSAXPrintDriver = this.getPrintHandler(xSLStylesheet, printWriter);
        this.lexHandler = xSLSAXPrintDriver;
        this.processXSL(xSLStylesheet, xMLElement, (ContentHandler)xSLSAXPrintDriver);
        xSLSAXPrintDriver.flush();
    }

    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, XMLElement xMLElement) throws XSLException {
        XSLDocumentBuilder xSLDocumentBuilder = "oracle.xml.parser.XMLDocument.THICK".equals(this.domKind) ? new XSLDocumentBuilder(this.domConn) : new XSLDocumentBuilder();
        XMLDocumentFragment xMLDocumentFragment = null;
        this.lexHandler = xSLDocumentBuilder;
        this.processXSL(xSLStylesheet, xMLElement, (ContentHandler)xSLDocumentBuilder);
        xMLDocumentFragment = xSLDocumentBuilder.getResultFragment();
        return xMLDocumentFragment;
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocumentFragment xMLDocumentFragment, XMLDocumentHandler xMLDocumentHandler) throws XSLException {
        this.processXSL(xSLStylesheet, (XMLElement)xMLDocumentFragment, xMLDocumentHandler);
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocumentFragment xMLDocumentFragment, OutputStream outputStream) throws XSLException, IOException {
        this.processXSL(xSLStylesheet, (XMLElement)xMLDocumentFragment, outputStream);
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocumentFragment xMLDocumentFragment, PrintWriter printWriter) throws XSLException, IOException {
        this.processXSL(xSLStylesheet, (XMLElement)xMLDocumentFragment, printWriter);
    }

    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, XMLDocumentFragment xMLDocumentFragment) throws XSLException {
        return this.processXSL(xSLStylesheet, (XMLElement)xMLDocumentFragment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, InputStream inputStream, URL uRL) throws XSLException {
        block4: {
            try {
                try {
                    this.init();
                    this.debugProp = new XSLDebugProp();
                    this.docBuilder.setDebugMode(this.debugProp.debug());
                    this.parser.setContentHandler(this.docBuilder);
                    this.parser.setBaseURL(uRL);
                    this.parser.parse(inputStream);
                }
                catch (Exception exception) {
                    this.reportException(exception, 1005);
                    Object var6_5 = null;
                    this.parser.setBaseURL(this.baseURL);
                    break block4;
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.parser.setBaseURL(this.baseURL);
                throw throwable;
            }
            this.parser.setBaseURL(this.baseURL);
        }
        XMLDocument xMLDocument = this.docBuilder.getDocument();
        return this.processXSL(xSLStylesheet, xMLDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, URL uRL, URL uRL2) throws XSLException {
        block4: {
            try {
                try {
                    this.init();
                    this.debugProp = new XSLDebugProp();
                    this.docBuilder.setDebugMode(this.debugProp.debug());
                    this.parser.setContentHandler(this.docBuilder);
                    this.parser.setBaseURL(uRL2);
                    this.parser.parse(uRL);
                }
                catch (Exception exception) {
                    this.reportException(exception, 1006);
                    Object var6_5 = null;
                    this.parser.setBaseURL(this.baseURL);
                    break block4;
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.parser.setBaseURL(this.baseURL);
                throw throwable;
            }
            this.parser.setBaseURL(this.baseURL);
        }
        XMLDocument xMLDocument = this.docBuilder.getDocument();
        return this.processXSL(xSLStylesheet, xMLDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, Reader reader, URL uRL) throws XSLException {
        block4: {
            try {
                try {
                    this.init();
                    this.debugProp = new XSLDebugProp();
                    this.docBuilder.setDebugMode(this.debugProp.debug());
                    this.parser.setContentHandler(this.docBuilder);
                    this.parser.setBaseURL(uRL);
                    this.parser.parse(reader);
                }
                catch (Exception exception) {
                    this.reportException(exception, 1007);
                    Object var6_5 = null;
                    this.parser.setBaseURL(this.baseURL);
                    break block4;
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.parser.setBaseURL(this.baseURL);
                throw throwable;
            }
            this.parser.setBaseURL(this.baseURL);
        }
        XMLDocument xMLDocument = this.docBuilder.getDocument();
        return this.processXSL(xSLStylesheet, xMLDocument);
    }

    public XSLStylesheet newXSLStylesheet(XMLDocument xMLDocument) throws XSLException {
        try {
            this.init();
            xMLDocument.reportSAXEvents(this.xslBuilder);
        }
        catch (Exception exception) {
            this.reportException(exception, 1900);
        }
        XSLStylesheet xSLStylesheet = this.xslBuilder.getStylesheet();
        xSLStylesheet.setDocument(xMLDocument);
        return xSLStylesheet;
    }

    public XSLStylesheet newXSLStylesheet(InputStream inputStream) throws XSLException {
        try {
            this.init();
            this.parser.setContentHandler(this.xslBuilder);
            this.parser.parse(inputStream);
        }
        catch (Exception exception) {
            this.reportException(exception, 1000);
        }
        return this.xslBuilder.getStylesheet();
    }

    public XSLStylesheet newXSLStylesheet(URL uRL) throws XSLException {
        try {
            this.init();
            this.setBaseURL(uRL);
            this.parser.setContentHandler(this.xslBuilder);
            this.parser.parse(uRL);
        }
        catch (Exception exception) {
            this.reportException(exception, 1000);
        }
        return this.xslBuilder.getStylesheet();
    }

    public XSLStylesheet newXSLStylesheet(Reader reader) throws XSLException {
        try {
            this.init();
            this.parser.setContentHandler(this.xslBuilder);
            this.parser.parse(reader);
        }
        catch (Exception exception) {
            this.reportException(exception, 1000);
        }
        return this.xslBuilder.getStylesheet();
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if ((string = string.intern()) == "http://javax.xml.XMLConstants/feature/secure-processing" && object instanceof Boolean) {
            boolean bl = (Boolean)object;
            this.context.setSecure(bl);
            this.xslBuilder.setSecure(bl);
        } else if (string == "oracle.xml.parser.DOMParser.PartialDOM" && object instanceof Boolean) {
            this.context.getParser().setAttribute(string, object);
        } else if (string == "oracle.xml.parser.DOMParser.PageManager" && object instanceof PageManager) {
            this.context.setPageManager((PageManager)object);
            this.context.getParser().setAttribute(string, object);
        } else if (string == "oracle.xml.parser.XMLDocument.Connection" && object instanceof Connection) {
            this.domConn = (Connection)object;
            this.docBuilder.setAttribute(string, object);
            this.context.setConnection(this.domConn);
        } else if (string == STREAMING_PROCESSING && object instanceof Boolean) {
            this.context.setStreaming((Boolean)object);
        } else if (string == "oracle.xml.parser.XMLDocument.Kind" && object instanceof String) {
            if (!object.equals("oracle.xml.parser.XMLDocument.THICK") && !object.equals("oracle.xml.parser.XMLDocument.THIN")) {
                throw new IllegalArgumentException();
            }
            this.domKind = (String)object;
            this.docBuilder.setAttribute(string, object);
            this.context.setDOMKind(this.domKind);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public final void setErrorStream(OutputStream outputStream) throws IOException {
        this.errOut = outputStream;
    }

    public void setLocale(Locale locale) {
        this.errLocale = locale;
    }

    public void setDecimalFormatLocale(Locale locale) {
        this.context.setDecimalFormatLocale(locale);
    }

    public final void showWarnings(boolean bl) {
        this.warnings = bl;
    }

    public void set2029Compatibility(boolean bl) {
        this.xslBuilder.set2029Compatibility(bl);
    }

    public void setBaseURL(URL uRL) {
        this.baseURL = uRL;
        this.parser.setBaseURL(uRL);
        this.xslBuilder.setBaseURL(uRL);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.parser.setEntityResolver(entityResolver);
        this.xslBuilder.setEntityResolver(entityResolver);
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.context.setURIResolver(uRIResolver);
    }

    public void setParam(String string, String string2, Object object) throws XSLException {
        if (this.params == null) {
            this.params = new Hashtable(20);
        }
        this.params.put(new NSNameImpl("", string2, string), object);
    }

    public Object getParam(String string, String string2) throws XSLException {
        Object var3_3 = null;
        if (this.params != null) {
            NSNameImpl nSNameImpl = new NSNameImpl("", string2, string);
            var3_3 = this.params.get(nSNameImpl);
        }
        return var3_3;
    }

    public void removeParam(String string, String string2) throws XSLException {
        if (this.params != null) {
            this.params.remove(new NSNameImpl("", string2, string));
        }
    }

    public void resetParams() throws XSLException {
        if (this.params != null) {
            this.params.clear();
        }
    }

    public static boolean supportsJDWP() {
        return true;
    }

    private void reportException(Exception exception, int n) throws XSLException {
        if (exception instanceof SAXException) {
            Exception exception2 = ((SAXException)exception).getException();
            if (exception2 != null) {
                if (exception2 instanceof XPathException) {
                    XPathException xPathException = (XPathException)exception2;
                    this.err.error(xPathException.errId, 1, xPathException.errParams);
                } else {
                    if (exception2 instanceof XSLException) {
                        throw (XSLException)exception2;
                    }
                    this.reportException(exception2, n);
                }
            } else {
                this.err.error1(n, 1, exception.getMessage());
            }
        } else if (!(exception instanceof XMLParseException)) {
            this.err.error1(n, 1, exception.getMessage());
        }
        try {
            this.err.flushErrorStream();
        }
        catch (IOException iOException) {
            this.err.setException(iOException);
            this.err.error1(1900, 1, iOException.getMessage());
        }
        throw new XSLException(this.err, this.err.getFirstError(), exception);
    }

    private void init() {
        if (this.err != null) {
            this.err.reset();
        } else {
            this.err = new XMLError();
            if (this.errOut != null) {
                this.err.setErrorStream(this.errOut);
            }
            if (this.errLocale != null) {
                this.err.setLocale(this.errLocale);
            }
            this.err.showWarnings(this.warnings);
        }
        this.context.init();
        this.context.setError(this.err);
        this.docBuilder.reset();
        this.docBuilder.setXMLError(this.err);
        this.docBuilder.retainCDATASection(false);
        this.xslBuilder.reset();
        this.xslBuilder.setError(this.err);
        this.parser.reset();
        this.parser.setError(this.err);
        this.parser.setPreserveWhitespace(true);
    }

    public void setOutputEncoding(String string) {
        this.extencspecified = true;
        this.extEncoding = string;
    }

    public void setXSLTVersion(XSLTVersion xSLTVersion) {
        if (xSLTVersion == XSLT10) {
            this.xslBuilder.setXSLTVersion(10);
        } else if (xSLTVersion == XSLT20) {
            this.xslBuilder.setXSLTVersion(20);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setXSLTVersion(int n) {
        if (n == 10) {
            this.setXSLTVersion(XSLT10);
        } else {
            this.setXSLTVersion(XSLT20);
        }
    }

    public void setXSLOutput(XSLOutput xSLOutput) {
        this.m_xslOutput = xSLOutput;
    }

    public void setIsJAXP(boolean bl) {
        this.isJAXP = bl;
    }

    private XSLSAXPrintDriver getPrintHandler(XSLStylesheet xSLStylesheet, OutputStream outputStream) throws IOException {
        XSLSAXPrintDriver xSLSAXPrintDriver = this.m_xslOutput == null ? new XSLSAXPrintDriver(outputStream, xSLStylesheet.output) : new XSLSAXPrintDriver(outputStream, this.m_xslOutput);
        if (this.extencspecified) {
            xSLSAXPrintDriver.setOutputEncoding(this.extEncoding);
        }
        return xSLSAXPrintDriver;
    }

    private XSLSAXPrintDriver getPrintHandler(XSLStylesheet xSLStylesheet, PrintWriter printWriter) throws IOException {
        XSLSAXPrintDriver xSLSAXPrintDriver = this.m_xslOutput == null ? new XSLSAXPrintDriver(printWriter, xSLStylesheet.output) : new XSLSAXPrintDriver(printWriter, this.m_xslOutput);
        if (this.extencspecified) {
            xSLSAXPrintDriver.setOutputEncoding(this.extEncoding);
        }
        return xSLSAXPrintDriver;
    }

    public Object getParam(String string) throws TransformerException, IOException {
        Object var2_2 = null;
        if (this.params != null) {
            NSNameImpl nSNameImpl = new NSNameImpl("", JXUtil.getLocalName(string), JXUtil.getURI(string));
            var2_2 = this.params.get(nSNameImpl);
        }
        return var2_2;
    }

    public static final class XSLTVersion {
        int version;

        XSLTVersion(int n) {
            this.version = n;
        }
    }
}

