/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxp;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import oracle.xml.jaxp.JXSAXParser;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class JXSAXParserFactory
extends SAXParserFactory {
    private Hashtable features;
    private boolean secure = false;
    private boolean deterministic = true;

    public javax.xml.parsers.SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        JXSAXParser jXSAXParser = new JXSAXParser();
        SAXParser sAXParser = jXSAXParser.getSAXParser();
        sAXParser.setValidationMode(this.isValidating());
        if (this.secure) {
            sAXParser.setEntityDepth(11);
            sAXParser.setAttribute("oracle.xdkjava.security.resolveEntityDefault", Boolean.FALSE);
        } else {
            sAXParser.setEntityDepth(16);
        }
        if (!this.deterministic) {
            sAXParser.setAttribute("oracle.xml.parser.XMLParser.ContentModelDeterministic", Boolean.FALSE);
        }
        if (this.features != null) {
            Enumeration enumeration = this.features.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl = (Boolean)this.features.get(string);
                sAXParser.setFeature(string, bl);
            }
        }
        return jXSAXParser;
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new SAXNotRecognizedException("" + string);
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this.secure = bl;
            return;
        }
        if (string.equals("oracle.xml.parser.XMLParser.ContentModelDeterministic")) {
            this.deterministic = bl;
            return;
        }
        if (!(string.equals("http://xml.org/sax/features/namespaces") || string.equals("http://xml.org/sax/features/namespace-prefixes") || string.equals("http://xml.org/sax/features/string-interning") || string.equals("http://xml.org/sax/features/validation") || string.equals("http://xml.org/sax/features/external-general-entities") || string.equals("http://xml.org/sax/features/external-parameter-entities"))) {
            throw new SAXNotRecognizedException(string);
        }
        if (this.features == null) {
            this.features = new Hashtable(5);
        }
        if (bl) {
            this.features.put(string, Boolean.TRUE);
        } else {
            this.features.put(string, Boolean.FALSE);
        }
    }

    public boolean getFeature(String string) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.secure;
        }
        if (string.equals("oracle.xml.parser.XMLParser.ContentModelDeterministic")) {
            return this.deterministic;
        }
        if (!(string.equals("http://xml.org/sax/features/namespaces") || string.equals("http://xml.org/sax/features/namespace-prefixes") || string.equals("http://xml.org/sax/features/string-interning") || string.equals("http://xml.org/sax/features/validation") || string.equals("http://xml.org/sax/features/external-general-entities") || string.equals("http://xml.org/sax/features/external-parameter-entities"))) {
            throw new SAXNotRecognizedException(string);
        }
        if (this.features == null) {
            return false;
        }
        return (Boolean)this.features.get(string);
    }
}

