/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.util.Hashtable;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLEntity;
import oracle.xml.xslt.XSLException;
import org.w3c.dom.NamedNodeMap;

public class XSLSourceContext {
    XMLElement srcRoot;
    Hashtable idHashTable;
    NamedNodeMap entityMap;
    Hashtable keyTables;

    public XSLSourceContext(XMLElement xMLElement, XMLDocument xMLDocument) throws XSLException {
        this.srcRoot = xMLElement;
        if (xMLDocument == null) {
            this.srcRoot.makeDocumentOrder(0);
        } else if (!xMLDocument.isDocOrdered()) {
            xMLDocument.setDocOrder(0);
        }
        if (xMLDocument != null) {
            this.idHashTable = xMLDocument.getIDHashtable();
            DTD dTD = (DTD)xMLDocument.getDoctype();
            if (dTD != null) {
                this.entityMap = dTD.getEntities();
            }
        }
    }

    public Hashtable getKeyTable(NSName nSName) throws XSLException {
        if (this.keyTables == null) {
            return null;
        }
        return (Hashtable)this.keyTables.get(nSName);
    }

    public void setKeyTable(NSName nSName, Hashtable hashtable) throws XSLException {
        if (this.keyTables == null) {
            this.keyTables = new Hashtable(20);
        }
        this.keyTables.put(nSName, hashtable);
    }

    public XMLElement getIDElement(String string) throws XSLException {
        if (this.idHashTable == null) {
            return null;
        }
        return (XMLElement)this.idHashTable.get(string);
    }

    public String getUnparsedEntityUri(String string) throws XSLException {
        if (this.entityMap == null) {
            return "";
        }
        XMLEntity xMLEntity = (XMLEntity)this.entityMap.getNamedItem(string);
        if (xMLEntity == null) {
            return "";
        }
        if (xMLEntity.getNotationName() == null) {
            return "";
        }
        return xMLEntity.getSystemId();
    }

    public String getUnparsedEntityPublicId(String string) throws XSLException {
        if (this.entityMap == null) {
            return "";
        }
        XMLEntity xMLEntity = (XMLEntity)this.entityMap.getNamedItem(string);
        if (xMLEntity == null) {
            return "";
        }
        if (xMLEntity.getNotationName() == null) {
            return "";
        }
        return xMLEntity.getPublicId();
    }
}

