/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.io.PrintStream;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.TypeCode;
import org.omg.CORBA.AliasDef;
import org.omg.CORBA.AliasDefHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.AttributeDescription;
import org.omg.CORBA.AttributeDescriptionHelper;
import org.omg.CORBA.AttributeMode;
import org.omg.CORBA.ConstantDescription;
import org.omg.CORBA.ConstantDescriptionHelper;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ContainedPackage.Description;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.EnumDef;
import org.omg.CORBA.EnumDefHelper;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.ExceptionDefHelper;
import org.omg.CORBA.ExceptionDescription;
import org.omg.CORBA.ExceptionDescriptionHelper;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription;
import org.omg.CORBA.InterfaceDescriptionHelper;
import org.omg.CORBA.ModuleDef;
import org.omg.CORBA.ModuleDefHelper;
import org.omg.CORBA.ModuleDescription;
import org.omg.CORBA.ModuleDescriptionHelper;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.OperationDescription;
import org.omg.CORBA.OperationDescriptionHelper;
import org.omg.CORBA.OperationMode;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.StructDef;
import org.omg.CORBA.StructDefHelper;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeDescription;
import org.omg.CORBA.TypeDescriptionHelper;
import org.omg.CORBA.UnionDef;
import org.omg.CORBA.UnionDefHelper;
import org.omg.CORBA.UnionMember;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynEnum;
import org.omg.DynamicAny.DynEnumHelper;

public class IdlWriter {
    private final PrintStream printStream;
    private final Repository ir;
    private final DynAnyFactory factory;
    private final Logger logger;
    private int indent = 0;

    public IdlWriter(ORB oRB, PrintStream printStream, Logger logger) {
        this.printStream = printStream;
        this.logger = logger;
        try {
            this.ir = RepositoryHelper.narrow(oRB.resolve_initial_references("InterfaceRepository"));
            this.factory = DynAnyFactoryHelper.narrow(oRB.resolve_initial_references("DynAnyFactory"));
        }
        catch (InvalidName invalidName) {
            throw new INTERNAL(invalidName.toString());
        }
        if (this.ir == null) {
            logger.fatalError("No IR configured! Exiting..");
            System.exit(1);
        }
    }

    public void close() {
        this.printStream.flush();
        this.printStream.close();
    }

    private void indent(int n) {
        this.indent = n;
    }

    private void print(String string) {
        for (int i = 0; i < this.indent; ++i) {
            this.printStream.print(" ");
        }
        this.printStream.print(string);
    }

    public void printContained(Contained contained, int n) {
        Description description = contained.describe();
        switch (description.kind.value()) {
            case 6: {
                this.printModule(ModuleDescriptionHelper.extract(description.value), n + 3);
                break;
            }
            case 5: {
                InterfaceDef interfaceDef = InterfaceDefHelper.narrow(this.ir.lookup_id(InterfaceDescriptionHelper.extract((Any)description.value).id));
                this.printInterface(interfaceDef, n + 3);
                break;
            }
            case 2: {
                this.printAttribute(AttributeDescriptionHelper.extract(description.value), n + 3);
                break;
            }
            case 7: {
                this.printOperation(OperationDescriptionHelper.extract(description.value), n + 3);
                break;
            }
            case 4: {
                this.printException(ExceptionDescriptionHelper.extract(description.value), n + 3);
                break;
            }
            case 3: {
                this.printConstant(ConstantDescriptionHelper.extract(description.value), n + 3);
                break;
            }
            case 10: {
                this.printStruct(TypeDescriptionHelper.extract(description.value), n + 3);
                break;
            }
            case 12: {
                this.printEnum(TypeDescriptionHelper.extract(description.value), n + 3);
                break;
            }
            case 11: {
                this.printUnion(TypeDescriptionHelper.extract(description.value), n + 3);
                break;
            }
            case 9: {
                this.printAlias(TypeDescriptionHelper.extract(description.value), n + 3);
            }
        }
    }

    public void printModule(ModuleDescription moduleDescription, int n) {
        this.indent(n);
        ModuleDef moduleDef = ModuleDefHelper.narrow(this.ir.lookup_id(moduleDescription.id));
        this.print("module " + moduleDef.name() + "\n");
        this.print("{\n");
        Contained[] containedArray = moduleDef.contents(DefinitionKind.dk_all, true);
        for (int i = 0; i < containedArray.length; ++i) {
            this.printContained(containedArray[i], n);
        }
        this.indent(n);
        this.print("};\n\n");
    }

    public void printInterface(InterfaceDef interfaceDef, int n) {
        int n2;
        FullInterfaceDescription fullInterfaceDescription = interfaceDef.describe_interface();
        Contained[] containedArray = interfaceDef.contents(DefinitionKind.dk_all, true);
        this.indent(n);
        StringBuffer stringBuffer = new StringBuffer();
        if (fullInterfaceDescription.base_interfaces.length > 0) {
            stringBuffer.append(" : " + fullInterfaceDescription.base_interfaces[0]);
        }
        for (n2 = 1; n2 < fullInterfaceDescription.base_interfaces.length; ++n2) {
            stringBuffer.append(", " + fullInterfaceDescription.base_interfaces[n2]);
        }
        this.print("interface " + fullInterfaceDescription.name + stringBuffer.toString() + "\n");
        this.print("{\n");
        for (n2 = 0; n2 < containedArray.length; ++n2) {
            this.printContained(containedArray[n2], n);
        }
        this.indent(n);
        this.print("};\n\n");
    }

    public void printException(ExceptionDescription exceptionDescription, int n) {
        ExceptionDef exceptionDef = ExceptionDefHelper.narrow(this.ir.lookup_id(exceptionDescription.id));
        if (exceptionDef != null) {
            StructMember[] structMemberArray = exceptionDef.members();
            this.indent(n);
            this.print("exception " + exceptionDescription.name + " {" + "\n");
            this.indent(n + 3);
            for (int i = 0; i < structMemberArray.length; ++i) {
                this.print(TypeCode.idlTypeName(structMemberArray[i].type) + " " + structMemberArray[i].name + ";" + "\n");
            }
            this.indent(n);
            this.print("};\n\n");
        } else {
            this.logger.error("Error, could not find exception " + exceptionDescription.id + " in IR ");
        }
    }

    public void printStruct(TypeDescription typeDescription, int n) {
        StructDef structDef = StructDefHelper.narrow(this.ir.lookup_id(typeDescription.id));
        if (structDef != null) {
            int n2;
            StructMember[] structMemberArray = structDef.members();
            Contained[] containedArray = structDef.contents(DefinitionKind.dk_all, false);
            this.indent(n);
            this.print("struct " + structDef.name() + " {" + "\n");
            this.indent(n + 3);
            for (n2 = 0; n2 < structMemberArray.length; ++n2) {
                this.print(TypeCode.idlTypeName(structMemberArray[n2].type) + " " + structMemberArray[n2].name + ";" + "\n");
            }
            for (n2 = 0; n2 < containedArray.length; ++n2) {
                this.printContained(containedArray[n2], n);
            }
            this.indent(n);
            this.print("};\n\n");
        } else {
            this.logger.error("Error, could not find struct " + typeDescription.id + " in IR ");
        }
    }

    public void printConstant(ConstantDescription constantDescription, int n) {
        this.indent(n);
        StringBuffer stringBuffer = new StringBuffer("const " + TypeCode.idlTypeName(constantDescription.type) + " " + constantDescription.name + " = ");
        switch (constantDescription.type.kind().value()) {
            case 18: {
                stringBuffer.append("\"" + constantDescription.value.extract_string() + "\"");
                break;
            }
            case 27: {
                stringBuffer.append("\"" + constantDescription.value.extract_wstring() + "\"");
                break;
            }
            case 8: {
                stringBuffer.append(constantDescription.value.extract_boolean());
                break;
            }
            case 3: {
                stringBuffer.append(constantDescription.value.extract_long());
                break;
            }
            case 5: {
                stringBuffer.append(constantDescription.value.extract_ulong());
                break;
            }
            case 23: {
                stringBuffer.append(constantDescription.value.extract_longlong());
                break;
            }
            case 24: {
                stringBuffer.append(constantDescription.value.extract_ulonglong());
                break;
            }
            case 2: {
                stringBuffer.append(constantDescription.value.extract_short());
                break;
            }
            case 4: {
                stringBuffer.append(constantDescription.value.extract_ushort());
                break;
            }
            case 6: {
                stringBuffer.append(constantDescription.value.extract_float());
                break;
            }
            case 10: {
                stringBuffer.append(constantDescription.value.extract_octet());
                break;
            }
            case 9: {
                stringBuffer.append("'" + constantDescription.value.extract_char() + "'");
                break;
            }
            case 26: {
                stringBuffer.append("'" + constantDescription.value.extract_wchar() + "'");
                break;
            }
            case 28: {
                stringBuffer.append(constantDescription.value.extract_fixed());
            }
        }
        this.print(stringBuffer.toString() + ";\n\n");
    }

    public void printAttribute(AttributeDescription attributeDescription, int n) {
        this.indent(n);
        String string = "";
        if (attributeDescription.mode.equals(AttributeMode.ATTR_READONLY)) {
            string = "readonly ";
        }
        this.print(string + "attribute " + TypeCode.idlTypeName(attributeDescription.type) + " " + attributeDescription.name + ";" + "\n");
    }

    public void printEnum(TypeDescription typeDescription, int n) {
        EnumDef enumDef = EnumDefHelper.narrow(this.ir.lookup_id(typeDescription.id));
        if (enumDef != null) {
            String[] stringArray = enumDef.members();
            this.indent(n);
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray.length > 0) {
                stringBuffer.append(stringArray[0]);
            }
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append("," + stringArray[i]);
            }
            this.print("enum " + enumDef.name() + " {" + stringBuffer + "};" + "\n\n");
        } else {
            this.logger.error("Error, could not find enum " + typeDescription.id + " in IR ");
        }
    }

    public void printUnion(TypeDescription typeDescription, int n) {
        UnionDef unionDef = UnionDefHelper.narrow(this.ir.lookup_id(typeDescription.id));
        if (unionDef != null) {
            UnionMember[] unionMemberArray = unionDef.members();
            this.indent(n);
            this.print("union " + unionDef.name() + " switch ( " + TypeCode.idlTypeName(unionDef.discriminator_type()) + " )\n");
            this.print("{\n");
            this.indent(n + 4);
            int n2 = -1;
            for (int i = 0; i < unionMemberArray.length; ++i) {
                if (unionMemberArray[i].label.type().kind() == TCKind.tk_octet && unionMemberArray[i].label.extract_octet() == 0) {
                    n2 = i;
                    continue;
                }
                if (unionMemberArray[i].label.type().kind() == TCKind.tk_char) {
                    this.print("case '" + unionMemberArray[i].label.extract_char() + "' : " + TypeCode.idlTypeName(unionMemberArray[i].type) + " " + unionMemberArray[i].name + ";" + "\n");
                    continue;
                }
                if (unionMemberArray[i].label.type().kind() == TCKind.tk_enum) {
                    try {
                        DynEnum dynEnum = DynEnumHelper.narrow(this.factory.create_dyn_any(unionMemberArray[i].label));
                        this.print("case " + dynEnum.get_as_string() + " : " + TypeCode.idlTypeName(unionMemberArray[i].type) + " " + unionMemberArray[i].name + ";" + "\n");
                    }
                    catch (Exception exception) {
                        this.logger.error("unexpected exception", exception);
                    }
                    continue;
                }
                this.print("case " + unionMemberArray[i].label.type() + " : " + TypeCode.idlTypeName(unionMemberArray[i].type) + " " + unionMemberArray[i].name + ";" + "\n");
            }
            if (n2 != -1) {
                this.print("default : " + TypeCode.idlTypeName(unionMemberArray[n2].type) + " " + unionMemberArray[n2].name + ";" + "\n");
            }
            this.indent(n);
            this.print("};\n\n");
        } else {
            this.logger.error("Error, could not find union " + typeDescription.id + " in IR ");
        }
    }

    public void printAlias(TypeDescription typeDescription, int n) {
        AliasDef aliasDef = AliasDefHelper.narrow(this.ir.lookup_id(typeDescription.id));
        this.indent(n);
        String string = TypeCode.idlTypeName(aliasDef.original_type_def().type());
        this.print("typedef " + string + " " + aliasDef.name() + ";\n\n");
    }

    public void printOperation(OperationDescription operationDescription, int n) {
        int n2;
        this.indent(n);
        String string = "";
        if (operationDescription.mode.equals(OperationMode.OP_ONEWAY)) {
            string = "oneway ";
        }
        this.print(string + TypeCode.idlTypeName(operationDescription.result) + " " + operationDescription.name + "(");
        this.indent(0);
        for (n2 = 0; n2 < operationDescription.parameters.length - 1; ++n2) {
            this.printParameter(operationDescription.parameters[n2], ",");
        }
        if (operationDescription.parameters.length > 0) {
            this.printParameter(operationDescription.parameters[operationDescription.parameters.length - 1], "");
        }
        this.print(")");
        if (operationDescription.exceptions.length > 0) {
            this.print(" raises (");
            this.print(TypeCode.idlTypeName(operationDescription.exceptions[0].type));
            for (n2 = 1; n2 < operationDescription.exceptions.length; ++n2) {
                this.print(TypeCode.idlTypeName(operationDescription.exceptions[0].type) + ",");
            }
            this.print(")");
        }
        this.print(";\n");
        this.indent(n);
    }

    public void printParameter(ParameterDescription parameterDescription, String string) {
        if (parameterDescription.mode.equals(ParameterMode.PARAM_OUT)) {
            this.print("out ");
        } else if (parameterDescription.mode.equals(ParameterMode.PARAM_INOUT)) {
            this.print("inout ");
        } else {
            this.print("in ");
        }
        this.print(TypeCode.idlTypeName(parameterDescription.type) + " " + parameterDescription.name);
        this.print(string);
    }
}

