/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.LoggerModule;

import com.n2bb.LoggerModule.MessageQueue;
import com.n2bb.LoggerModule.UDPListener;
import org.apache.log4j.Logger;

public abstract class LocalLoggerListener {
    static Logger logger;
    private MessageQueue mq;
    private Thread listener;
    private Thread processor;

    public LocalLoggerListener(int listenPort, int rcvBufferSize) throws Exception {
        logger = Logger.getLogger(LocalLoggerListener.class);
        logger.info((Object)("LocalLoggerListener starting - UDP receive port... " + listenPort));
        this.mq = new MessageQueue();
        this.listener = new UDPListener(listenPort, this.mq, rcvBufferSize);
        this.processor = new MsgProcessor();
        this.listener.start();
        this.processor.start();
    }

    protected abstract void processMsg(byte[] var1);

    public static void usage() throws Exception {
        System.out.println("Usage:  LocalLoggerListener listenPort rcvBufferSize");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            LocalLoggerListener.usage();
            return;
        }
        try {
            int listenPort = Integer.parseInt(args[0]);
            int rcvBufferSize = Integer.parseInt(args[1]);
        }
        catch (Exception e) {
            LocalLoggerListener.usage();
            throw e;
        }
    }

    private class MsgProcessor
    extends Thread {
        private MsgProcessor() {
        }

        public void run() {
            logger.info((Object)"MsgProcessor thread running");
            while (true) {
                try {
                    while (true) {
                        LocalLoggerListener.this.processMsg((byte[])LocalLoggerListener.this.mq.getMessage());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"processMsg exception... ", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

