/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxp;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import oracle.xml.jaxp.JXTransformerHandler;
import oracle.xml.jaxp.JXUtil;
import oracle.xml.jaxp.JXXMLFilter;
import oracle.xml.parser.v2.DOMLocator;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.util.XMLError;
import oracle.xml.util.XMLUtil;
import oracle.xml.xslt.XSLDocumentBuilder;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLOutput;
import oracle.xml.xslt.XSLProcessor;
import oracle.xml.xslt.XSLSAXPrintDriver;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.ext.LexicalHandler;

public class JXTransformer
extends Transformer
implements XMLConstants {
    URIResolver m_uriResolver;
    ErrorListener m_errorListener;
    oracle.xml.xslt.XSLStylesheet m_templates;
    XSLOutput m_output;
    Properties m_transXSLT;
    Properties m_transProps;
    XMLError m_err = new XMLError();
    XSLProcessor m_processor = new XSLProcessor();
    Connection m_domConn;
    String m_domKind;
    String compVersion = JDKVERSION;
    boolean m_doe_pi = false;
    private static HashMap outputKeys = new HashMap(20);
    private static final String IDENXSLSTR = "<stylesheet version='1.0' xmlns='http://www.w3.org/1999/XSL/Transform'>  <template match='@*|node()'>     <copy-of select='.'/>  </template></stylesheet>";
    private static final String IDENXSLSTROOT = "<stylesheet version='1.0' xmlns='http://www.w3.org/1999/XSL/Transform'>  <template match='/'>     <copy-of select='.'/>  </template></stylesheet>";
    private static oracle.xml.xslt.XSLStylesheet IDENXSL;
    private static oracle.xml.xslt.XSLStylesheet IDENXSLROOT;
    private static String JDKVERSION;

    public JXTransformer() {
        try {
            this.m_output = new XSLOutput(new oracle.xml.xslt.XSLStylesheet());
            XSLOutput xSLOutput = new XSLOutput(new oracle.xml.xslt.XSLStylesheet());
            this.m_transXSLT = xSLOutput.getDefaultProps();
            this.m_transProps = xSLOutput.getProps();
            this.m_templates = IDENXSL;
        }
        catch (XSLException xSLException) {
            try {
                this.reportException(xSLException, 0, 1900, null);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
        }
    }

    public JXTransformer(XSLStylesheet xSLStylesheet) {
        this(xSLStylesheet.xss);
    }

    public JXTransformer(oracle.xml.xslt.XSLStylesheet xSLStylesheet) {
        try {
            this.m_output = new XSLOutput(xSLStylesheet);
            this.m_output.setPrefixHash(xSLStylesheet.getXSLOutput().getPrefixHash());
            this.m_templates = xSLStylesheet;
            this.m_transXSLT = xSLStylesheet.getXSLOutput().getDefaultProps();
            this.m_transProps = xSLStylesheet.getOutputProperties();
        }
        catch (XSLException xSLException) {
            try {
                this.reportException(xSLException, 0, 1900, null);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
        }
    }

    public void setGenerate_Output_Escaping_PIs(boolean bl) {
        this.m_doe_pi = bl;
    }

    void setCompVersion(String string) {
        if (string != null) {
            this.compVersion = string;
        }
    }

    public void setSecure(Boolean bl) {
        this.m_processor.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", bl);
    }

    public void transform(Source source, Result result) throws TransformerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        XMLElement xMLElement = null;
        Node node = null;
        Properties properties = this.m_output.getProps();
        if (this.m_uriResolver != null) {
            this.m_processor.setURIResolver(this.m_uriResolver);
        }
        if (source instanceof DOMSource) {
            object5 = ((DOMSource)source).getNode();
            if (object5 instanceof XMLElement) {
                xMLElement = (XMLElement)object5;
            } else {
                node = object5;
            }
        } else {
            object5 = null;
            object4 = SAXSource.sourceToInputSource(source);
            object3 = null;
            if (source instanceof SAXSource && (object5 = ((SAXSource)source).getXMLReader()) instanceof JXXMLFilter) {
                properties = ((JXXMLFilter)object5).getTransHandler().getTransformer().getOutputProperties();
            }
            if (object5 == null) {
                object5 = new SAXParser();
            }
            if (object5 instanceof SAXParser && (object2 = source.getSystemId()) != null) {
                try {
                    ((SAXParser)object5).setBaseURL(new URL((String)object2));
                }
                catch (MalformedURLException malformedURLException) {
                    this.reportException(malformedURLException, 1, 1108, null);
                }
            }
            try {
                object3 = object5 instanceof JXXMLFilter ? new XSLDocumentBuilder() : new DocumentBuilder();
                if ("oracle.xml.parser.XMLDocument.THICK".equals(this.m_domKind)) {
                    ((DocumentBuilder)object3).setAttribute("oracle.xml.parser.XMLDocument.Connection", this.m_domConn);
                    ((DocumentBuilder)object3).setAttribute("oracle.xml.parser.XMLDocument.Kind", this.m_domKind);
                }
                object5.setContentHandler((ContentHandler)object3);
                if (object5 instanceof SAXParser) {
                    ((SAXParser)object5).setLexHandler((LexicalHandler)object3);
                }
                object5.parse((InputSource)object4);
            }
            catch (Exception exception) {
                object = new DOMLocator(((DocumentBuilder)object3).getLocator());
                this.reportException(exception, 0, 1004, (SourceLocator)object);
            }
            xMLElement = object5 instanceof JXXMLFilter ? ((XSLDocumentBuilder)object3).getResultFragment() : ((DocumentBuilder)object3).getDocument();
        }
        object5 = null;
        if (result instanceof DOMResult) {
            object4 = ((DOMResult)result).getNode();
            if (object4 == null) {
                object4 = "oracle.xml.parser.XMLDocument.THICK".equals(this.m_domKind) ? new XMLDocument(this.m_domConn, 0L) : new XMLDocument();
                ((DOMResult)result).setNode((Node)object4);
            }
            if (!(object4 instanceof XMLElement)) {
                this.reportException(null, 0, 1103, null);
            }
            object5 = new XSLDocumentBuilder((XMLElement)object4);
        } else if (result instanceof SAXResult) {
            object5 = ((SAXResult)result).getHandler();
        } else {
            Object object6;
            object4 = (StreamResult)result;
            object3 = ((StreamResult)object4).getOutputStream();
            object2 = ((StreamResult)object4).getWriter();
            object = ((StreamResult)object4).getSystemId();
            Object var11_15 = null;
            if (object3 == null && object2 == null) {
                if (object == null) {
                    this.reportException(null, 0, 1122, null);
                }
                try {
                    if (((String)object).startsWith("file:/")) {
                        object6 = new URL((String)object);
                        object = ((URL)object6).getFile();
                    }
                    object3 = new FileOutputStream((String)object);
                }
                catch (IOException iOException) {
                    this.reportException(iOException, 0, 1110, null);
                }
            }
            if (this.m_transProps.size() == 0 && properties.size() > 0) {
                this.m_output.setProps(properties);
            } else {
                this.m_output.setProps(this.m_transProps);
            }
            if (object3 != null) {
                object5 = new XSLSAXPrintDriver((OutputStream)object3, this.m_output);
            } else {
                object6 = null;
                object6 = object2 instanceof PrintWriter ? (PrintWriter)object2 : new PrintWriter((Writer)object2);
                object5 = new XSLSAXPrintDriver((PrintWriter)object6, this.m_output);
            }
        }
        try {
            if (this.m_templates == IDENXSL) {
                if (XMLUtil.reportDocEvents(object5, XMLParser.getReportedCHClasses())) {
                    object5.startDocument();
                }
                if (this.compVersion == "JDK_1.4") {
                    if (xMLElement instanceof XMLDocument) {
                        for (object4 = (XMLNode)xMLElement.getFirstChild(); object4 != null; object4 = (XMLNode)((XMLNode)object4).getNextSibling()) {
                            ((XMLNode)object4).reportSAXEvents((ContentHandler)object5);
                        }
                    } else if (xMLElement != null) {
                        xMLElement.reportSAXEvents((ContentHandler)object5);
                    } else if (node instanceof XMLNode) {
                        if (object5 instanceof XSLSAXPrintDriver) {
                            ((XSLSAXPrintDriver)object5).setPrintWS(true);
                        }
                        ((XMLNode)node).reportSAXEvents((ContentHandler)object5);
                    }
                } else if (xMLElement != null) {
                    object4 = xMLElement.getParentNode();
                    if (object4 == null) {
                        this.m_templates = IDENXSLROOT;
                    }
                    this.m_processor.processXSL(this.m_templates, xMLElement, (ContentHandler)object5);
                } else if (node instanceof XMLNode) {
                    if (object5 instanceof XSLSAXPrintDriver) {
                        ((XSLSAXPrintDriver)object5).setPrintWS(true);
                    }
                    ((XMLNode)node).reportSAXEvents((ContentHandler)object5);
                }
                if (XMLUtil.reportDocEvents(object5, XMLParser.getReportedCHClasses())) {
                    object5.endDocument();
                }
            } else if (xMLElement != null) {
                if (this.m_doe_pi) {
                    this.m_processor.setIsJAXP(true);
                }
                this.m_processor.processXSL(this.m_templates, xMLElement, (ContentHandler)object5);
            } else {
                this.reportException(null, 0, 1101, null);
            }
            if (object5 instanceof XSLSAXPrintDriver) {
                ((XSLSAXPrintDriver)object5).flush();
            }
            if (object5 instanceof JXTransformerHandler) {
                object5.endDocument();
            }
        }
        catch (XSLException xSLException) {
            this.reportXSLException(xSLException);
        }
        catch (Exception exception) {
            this.reportException(exception, 0, 1900, null);
        }
    }

    public void setParameter(String string, Object object) {
        String string2 = JXUtil.getURI(string);
        String string3 = JXUtil.getLocalName(string);
        try {
            if (string2 == null) {
                this.reportException(null, 1, 1113, null);
                return;
            }
            if (string3 == null) {
                this.reportException(null, 1, 1112, null);
                return;
            }
            try {
                if (object instanceof String) {
                    object = new StringBuffer((String)object);
                }
                this.m_processor.setParam(string2, string3, object);
            }
            catch (XSLException xSLException) {
                this.reportException(xSLException, 0, 1900, null);
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public Object getParameter(String string) {
        Object object = null;
        String string2 = JXUtil.getURI(string);
        String string3 = JXUtil.getLocalName(string);
        try {
            if (string2 == null) {
                this.reportException(null, 1, 1113, null);
                return null;
            }
            if (string3 == null) {
                this.reportException(null, 1, 1112, null);
                return null;
            }
            try {
                String string4;
                object = this.m_processor.getParam(string2, string3);
                if (object != null && object instanceof StringBuffer && (string4 = object.toString()) != null && string4.length() > 2) {
                    if (string4.startsWith("'") && string4.endsWith("'")) {
                        string4 = string4.substring(1, string4.length() - 1);
                        return string4;
                    }
                    return string4;
                }
            }
            catch (XSLException xSLException) {
                this.reportException(xSLException, 0, 1900, null);
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return object;
    }

    public void clearParameters() {
        try {
            this.m_processor.resetParams();
        }
        catch (XSLException xSLException) {
            try {
                this.reportException(xSLException, 0, 1900, null);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
        }
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public void setOutputProperties(Properties properties) throws IllegalArgumentException {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = properties.get(string);
                if (object != null) {
                    this.m_transProps.put(string, object);
                } else {
                    this.m_transProps.remove(string);
                }
                if (!string.equals("method")) continue;
                if (object != null) {
                    JXUtil.setDefaultProps(this.m_transXSLT, (String)object);
                    continue;
                }
                JXUtil.setDefaultProps(this.m_transXSLT, "xml");
            }
        } else {
            this.m_transProps.clear();
        }
    }

    public Properties getOutputProperties() {
        return (Properties)this.m_transProps.clone();
    }

    public void setOutputProperty(String string, String string2) throws IllegalArgumentException {
        if (outputKeys.get(string) == null) {
            throw new IllegalArgumentException();
        }
        this.m_transProps.put(string, string2);
        if (string.equals("method")) {
            if (string2 != null) {
                JXUtil.setDefaultProps(this.m_transXSLT, string2);
            } else {
                JXUtil.setDefaultProps(this.m_transXSLT, "xml");
            }
        }
    }

    public String getOutputProperty(String string) throws IllegalArgumentException {
        if (outputKeys.get(string) == null) {
            throw new IllegalArgumentException();
        }
        return this.m_transProps.getProperty(string);
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        this.m_errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        if (this.m_errorListener == null) {
            return new ErrorListener(){

                public void warning(TransformerException transformerException) {
                }

                public void error(TransformerException transformerException) {
                }

                public void fatalError(TransformerException transformerException) {
                }
            };
        }
        return this.m_errorListener;
    }

    void setConnection(Connection connection) {
        this.m_domConn = connection;
    }

    void setDOMKind(String string) {
        this.m_domKind = string;
        if (string == null) {
            this.m_domKind = "oracle.xml.parser.XMLDocument.THIN";
        }
    }

    private void reportException(Exception exception, int n, int n2, SourceLocator sourceLocator) throws TransformerException {
        String string = null;
        this.m_err.reset();
        if (exception == null) {
            this.m_err.error0(n2, n);
        } else if (exception.getMessage() == null) {
            this.m_err.error1(n2, n, "null");
        } else {
            this.m_err.error1(n2, n, exception.getMessage());
        }
        string = this.m_err.formatErrorMesg(0);
        TransformerException transformerException = sourceLocator != null ? (exception != null ? new TransformerException(string, sourceLocator, exception) : new TransformerException(string, sourceLocator)) : (exception != null ? new TransformerException(string, exception) : new TransformerException(string));
        if (this.m_errorListener == null) {
            try {
                if (!XMLParser.getNoShowForInvalidURLError()) {
                    this.m_err.setErrorStream(System.err);
                }
                this.m_err.printErrorListener();
                if (n == 0) {
                    throw transformerException;
                }
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
            return;
        }
        switch (n) {
            case 0: {
                this.m_errorListener.fatalError(transformerException);
                throw transformerException;
            }
            case 1: {
                this.m_errorListener.error(transformerException);
                break;
            }
            case 2: {
                this.m_errorListener.warning(transformerException);
            }
        }
    }

    private void reportXSLException(XSLException xSLException) throws TransformerException {
        XMLError xMLError = xSLException.getXMLError();
        DOMLocator dOMLocator = new DOMLocator(xMLError.getLocator());
        int n = xSLException.getMessageType(0);
        String string = xMLError.formatErrorMesg(0);
        TransformerException transformerException = new TransformerException(string, dOMLocator, xSLException);
        if (this.m_errorListener == null) {
            try {
                if (!XMLParser.getNoShowForInvalidURLError()) {
                    xMLError.setErrorStream(System.err);
                }
                xMLError.printErrorListener();
                if (n == 0) {
                    throw transformerException;
                }
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
            return;
        }
        switch (n) {
            case 0: {
                this.m_errorListener.fatalError(transformerException);
                throw transformerException;
            }
            case 1: {
                this.m_errorListener.error(transformerException);
                break;
            }
            case 2: {
                this.m_errorListener.warning(transformerException);
            }
        }
    }

    static {
        outputKeys.put("method", "method");
        outputKeys.put("version", "version");
        outputKeys.put("encoding", "encoding");
        outputKeys.put("omit-xml-declaration", "omit-xml-declaration");
        outputKeys.put("standalone", "standalone");
        outputKeys.put("doctype-public", "doctype-public");
        outputKeys.put("doctype-system", "doctype-system");
        outputKeys.put("cdata-section-elements", "cdata-section-elements");
        outputKeys.put("indent", "indent");
        outputKeys.put("media-type", "media-type");
        JDKVERSION = XMLUtil.getProperty("oracle.xdkjava.transformer.compatible.jdkversion", "JDK_1.5");
        JDKVERSION = JDKVERSION.equals("JDK_1.4") ? "JDK_1.4" : "JDK_1.5";
        try {
            IDENXSL = new oracle.xml.xslt.XSLStylesheet(new StringReader(IDENXSLSTR), null);
            IDENXSLROOT = new oracle.xml.xslt.XSLStylesheet(new StringReader(IDENXSLSTROOT), null);
        }
        catch (XSLException xSLException) {
            // empty catch block
        }
    }
}

