/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.rmi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.ObjectImpl;

public class PortableRemoteObjectDelegateImpl
implements PortableRemoteObjectDelegate {
    private static ORB _orb = null;

    public static synchronized ORB getORB() {
        if (_orb == null) {
            System.out.println("Unknown ORB");
            _orb = ORB.init(new String[0], null);
        }
        return _orb;
    }

    public static synchronized void setORB(ORB oRB) {
        if (_orb != null) {
            throw new IllegalStateException("RMI orb has already been initialized");
        }
        _orb = oRB;
    }

    public void exportObject(Remote remote) throws RemoteException {
        if (remote == null) {
            throw new NullPointerException();
        }
        if (remote instanceof Stub) {
            throw new ExportException("Attempted to export a stub class");
        }
        Tie tie = Util.getTie((Remote)remote);
        if (tie != null) {
            throw new ExportException("Object already exported");
        }
        tie = this.toTie(remote);
        tie.orb(PortableRemoteObjectDelegateImpl.getORB());
        Util.registerTarget((Tie)tie, (Remote)remote);
    }

    public Remote toStub(Remote remote) throws NoSuchObjectException {
        if (remote instanceof Stub) {
            return remote;
        }
        Tie tie = null;
        if (remote instanceof Tie) {
            tie = (Tie)remote;
            remote = tie.getTarget();
        } else {
            tie = Util.getTie((Remote)remote);
        }
        if (tie == null) {
            throw new NoSuchObjectException("Object not exported");
        }
        ObjectImpl objectImpl = (ObjectImpl)tie.thisObject();
        String[] stringArray = objectImpl._ids();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = this.newRMIStubName(string);
            try {
                Stub stub = this.newStub(string2, remote.getClass());
                stub._set_delegate(objectImpl._get_delegate());
                return (Remote)stub;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        throw new NoSuchObjectException("Object not exported");
    }

    public void unexportObject(Remote remote) throws NoSuchObjectException {
        Tie tie = Util.getTie((Remote)remote);
        if (tie == null) {
            throw new NoSuchObjectException("Object not exported");
        }
        Util.unexportObject((Remote)remote);
    }

    public Object narrow(Object object, Class clazz) throws ClassCastException {
        Object object2;
        Class<?> clazz2;
        block8: {
            if (clazz == null) {
                throw new ClassCastException("Can't narrow to null class");
            }
            if (object == null) {
                return null;
            }
            clazz2 = object.getClass();
            object2 = null;
            try {
                if (clazz.isAssignableFrom(clazz2)) {
                    object2 = object;
                    break block8;
                }
                Class<?>[] classArray = clazz2.getInterfaces();
                Exception exception = new Exception();
                try {
                    throw exception;
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                    System.exit(2);
                }
            }
            catch (Exception exception) {
                object2 = null;
            }
        }
        if (object2 == null) {
            throw new ClassCastException("Can't narrow from " + clazz2 + " to " + clazz);
        }
        return object2;
    }

    public void connect(Remote remote, Remote remote2) throws RemoteException {
        throw new Error("Not implemented for PortableRemoteObjectDelegateImpl");
    }

    private Tie toTie(Remote remote) throws ExportException {
        for (Class<?> clazz = remote.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                String string = this.newRMIClassName(clazz.getName(), "Tie");
                return this.newTie(string, clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                throw new ExportException("InstantiationException: " + instantiationException, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ExportException("IllegalAccessException: " + illegalAccessException, illegalAccessException);
            }
        }
        throw new ExportException("Tie class not found ");
    }

    private Stub newStub(String string, Class clazz) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            return (Stub)this.newInstance(string, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return (Stub)this.newInstance("org.omg.stub." + string, clazz);
        }
    }

    private Tie newTie(String string, Class clazz) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            return (Tie)this.newInstance(string, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return (Tie)this.newInstance("org.omg.stub." + string, clazz);
        }
    }

    private Object newInstance(String string, Class clazz) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.loadClass(string, clazz).newInstance();
    }

    private Class loadClass(String string, Class clazz) throws ClassNotFoundException {
        return Util.loadClass((String)string, (String)Util.getCodebase((Class)clazz), (ClassLoader)clazz.getClassLoader());
    }

    private String newRMIStubName(String string) {
        String string2 = string.substring(4, string.lastIndexOf(":"));
        return this.newRMIClassName(string2, "Stub");
    }

    private String newRMIClassName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2 + string2.length());
        int n = string.lastIndexOf(46) + 1;
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append("_");
        stringBuffer.append(string.substring(n, string.length()));
        stringBuffer.append("_");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }
}

