/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.IOException;
import java.io.InputStream;
import org.jacorb.orb.iiop.IIOPLoopbackOutputStream;

class IIOPLoopbackInputStream
extends InputStream {
    private static final int BUF_SIZE = 2048;
    private final byte[] buf = new byte[2048];
    private boolean connected;
    private boolean closed;
    private int writerIndex;
    private int readerIndex;

    IIOPLoopbackInputStream() {
    }

    IIOPLoopbackInputStream(IIOPLoopbackOutputStream iIOPLoopbackOutputStream) throws IOException {
        this.connect(iIOPLoopbackOutputStream);
    }

    synchronized void connect(IIOPLoopbackOutputStream iIOPLoopbackOutputStream) throws IOException {
        if (this.connected) {
            throw new IOException("Alread connected");
        }
        this.connected = true;
        iIOPLoopbackOutputStream.connect(this);
    }

    public synchronized int read() throws IOException {
        this.checkConnect();
        return this.internalRead();
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        this.checkConnect();
        this.checkBuffer(byArray, n, n2);
        for (n4 = 0; n4 < n2 && (n3 = this.internalRead()) != -1; ++n4) {
            byArray[n + n4] = (byte)n3;
        }
        return n4 > 0 ? n4 : -1;
    }

    public synchronized int available() throws IOException {
        this.checkConnect();
        if (this.writerIndex > this.readerIndex) {
            return this.writerIndex - this.readerIndex;
        }
        if (this.readerIndex > this.writerIndex) {
            return 2048 + this.writerIndex - this.readerIndex;
        }
        this.checkClosed();
        return 0;
    }

    public synchronized void close() throws IOException {
        this.checkConnect();
        this.closed = true;
        this.notifyAll();
    }

    synchronized void writerClose() throws IOException {
        this.checkConnect();
        this.closed = true;
        this.notifyAll();
    }

    synchronized void writeIntoBuffer(int n) throws IOException {
        this.checkConnect();
        this.internalWrite((byte)n);
    }

    synchronized void writeIntoBuffer(byte[] byArray, int n, int n2) throws IOException {
        this.checkConnect();
        this.checkBuffer(byArray, n, n2);
        for (int i = 0; i < n2; ++i) {
            this.internalWrite(byArray[n + i]);
        }
    }

    private int internalRead() {
        while (this.bufferEmpty()) {
            if (this.closed) {
                return -1;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        boolean bl = this.bufferFull();
        int n = this.buf[this.readerIndex] & 0xFF;
        this.readerIndex = this.nextIndex(this.readerIndex);
        if (bl) {
            this.notifyAll();
        }
        return n;
    }

    private void internalWrite(byte by) throws IOException {
        while (this.bufferFull()) {
            this.checkClosed();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.checkClosed();
        boolean bl = this.bufferEmpty();
        this.buf[this.writerIndex] = by;
        this.writerIndex = this.nextIndex(this.writerIndex);
        if (bl) {
            this.notifyAll();
        }
    }

    private void checkConnect() throws IOException {
        if (!this.connected) {
            throw new IOException("IIOPLoopbackInputStream not connected");
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("IIOPLoopbackInputStream closed");
        }
    }

    private void checkBuffer(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException("Null buffer");
        }
        int n3 = byArray.length;
        if (n < 0 || n >= n3 || n2 < 0 || n2 > n3 || n + n2 > n3) {
            throw new IndexOutOfBoundsException("Invalid offset/length");
        }
    }

    private boolean bufferEmpty() {
        return this.readerIndex == this.writerIndex;
    }

    private boolean bufferFull() {
        return this.readerIndex == this.nextIndex(this.writerIndex);
    }

    private int nextIndex(int n) {
        int n2 = n + 1;
        return n2 == 2048 ? 0 : n2;
    }
}

