/*
 * Decompiled with CFR 0.152.
 */
package com.edb.util;

import com.edb.core.Utils;
import com.edb.jdbc2.Struct;
import com.edb.util.StructParser;
import java.sql.SQLException;
import java.util.List;

public class StructUtils {
    public static java.sql.Struct toStruct(String structValue, String typeName) {
        List al = StructParser.parse(structValue);
        return new Struct(al, typeName);
    }

    public static String toString(java.sql.Struct struct, boolean standardConformingStrings, boolean supportsEStringSyntax) throws SQLException {
        return StructUtils.toString(struct, standardConformingStrings, supportsEStringSyntax, 0);
    }

    private static String toString(java.sql.Struct struct, boolean standardConformingStrings, boolean supportsEStringSyntax, int level) throws SQLException {
        if (struct == null || struct.getAttributes() == null) {
            return null;
        }
        String output = "";
        output = output + "(";
        Object[] attributes = struct.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            String param;
            if (i > 0) {
                output = output + ",";
            }
            if (attributes[i] == null) {
                output = output + "null";
                continue;
            }
            if (attributes[i] instanceof Number) {
                output = output + attributes[i];
                continue;
            }
            if (attributes[i] instanceof java.sql.Struct) {
                param = StructUtils.toString((java.sql.Struct)attributes[i], standardConformingStrings, supportsEStringSyntax, level + 1);
                String quotes = StructUtils.getQuotes(level);
                output = output + quotes + param.toString() + quotes;
                continue;
            }
            param = attributes[i].toString();
            boolean hasBackslash = param.indexOf(92) != -1;
            StringBuffer p = new StringBuffer(3 + param.length() * 11 / 10);
            if (hasBackslash && !standardConformingStrings && supportsEStringSyntax) {
                p.append('E');
            }
            try {
                p = Utils.appendEscapedLiteral(p, param, standardConformingStrings);
            }
            catch (SQLException sqle) {
                throw new IllegalArgumentException(sqle.toString());
            }
            output = output + p.toString();
        }
        output = output + ")";
        return output;
    }

    private static String getQuotes(int level) {
        String quotes = "\"";
        for (int i = 0; i < level; ++i) {
            quotes = quotes + "\"";
        }
        return quotes;
    }
}

